/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.CompoundList;
import com.mojang.datafixers.types.templates.List;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u00022\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r0\u00152\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00152\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0014\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J \u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016\u00a8\u0006\""}, d2={"Ljuuxel/adorn/util/JanksonOps;", "Lcom/mojang/datafixers/types/DynamicOps;", "Lblue/endless/jankson/JsonElement;", "()V", "createBoolean", "Lblue/endless/jankson/JsonPrimitive;", "value", "", "createList", "input", "Ljava/util/stream/Stream;", "createMap", "map", "", "createNumeric", "i", "", "createString", "", "empty", "getMapValues", "Ljava/util/Optional;", "getNumberValue", "getStream", "getStringValue", "getType", "Lcom/mojang/datafixers/types/Type;", "merge", "first", "second", "mergeInto", "key", "remove", "toString", "Adorn"})
public final class JanksonOps
implements DynamicOps<JsonElement> {
    public static final JanksonOps INSTANCE;

    @NotNull
    public JsonElement empty() {
        JsonNull jsonNull = JsonNull.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
        return (JsonElement)jsonNull;
    }

    @NotNull
    public Type<?> getType(@NotNull JsonElement input) {
        Type type;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        JsonElement jsonElement = input;
        if (jsonElement instanceof JsonObject) {
            CompoundList.CompoundListType compoundListType = DSL.compoundList((Type)DSL.remainderType(), (Type)DSL.remainderType());
            Intrinsics.checkExpressionValueIsNotNull((Object)compoundListType, (String)"DSL.compoundList(DSL.rem\u2026e(), DSL.remainderType())");
            type = (Type)compoundListType;
        } else if (jsonElement instanceof JsonArray) {
            List.ListType listType = DSL.list((Type)DSL.remainderType());
            Intrinsics.checkExpressionValueIsNotNull((Object)listType, (String)"DSL.list(DSL.remainderType())");
            type = (Type)listType;
        } else if (jsonElement instanceof JsonNull) {
            Type type2 = DSL.nilType();
            type = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"DSL.nilType()");
        } else if (jsonElement instanceof JsonPrimitive) {
            Type type3;
            Object object = ((JsonPrimitive)input).getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"input.value");
            Object value = object;
            if (value instanceof String) {
                type3 = DSL.string();
            } else if (value instanceof Boolean) {
                type3 = DSL.bool();
            } else if (value instanceof Byte) {
                type3 = DSL.byteType();
            } else if (value instanceof Short) {
                type3 = DSL.shortType();
            } else if (value instanceof Integer) {
                type3 = DSL.intType();
            } else if (value instanceof Long) {
                type3 = DSL.longType();
            } else if (value instanceof Float) {
                type3 = DSL.floatType();
            } else if (value instanceof Double) {
                type3 = DSL.doubleType();
            } else {
                throw (Throwable)new IllegalArgumentException("JsonPrimitive '" + input + "' has an unknown value type: " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName());
            }
            type = type3;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"when (val value = input.\u2026          )\n            }");
        } else {
            throw (Throwable)new IllegalArgumentException("JsonElement '" + input + "' has an unknown type: " + Reflection.getOrCreateKotlinClass(input.getClass()).getQualifiedName());
        }
        return type;
    }

    @NotNull
    public Optional<Number> getNumberValue(@NotNull JsonElement input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (input instanceof JsonPrimitive) {
            Object object = ((JsonPrimitive)input).getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"input.value");
            Object value = object;
            if (value instanceof Number) {
                Optional<Object> optional = Optional.of(value);
                Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(value)");
                return optional;
            }
            if (value instanceof Boolean) {
                Optional<Number> optional = Optional.of((Boolean)value != false ? 1 : 0);
                Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(if (value) 1 else 0)");
                return optional;
            }
        }
        Optional<Number> optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        return optional;
    }

    @NotNull
    public JsonPrimitive createNumeric(@NotNull Number i2) {
        Intrinsics.checkParameterIsNotNull((Object)i2, (String)"i");
        return new JsonPrimitive((Object)i2);
    }

    @NotNull
    public JsonPrimitive createBoolean(boolean value) {
        return new JsonPrimitive((Object)value);
    }

    @NotNull
    public Optional<String> getStringValue(@NotNull JsonElement input) {
        Optional<String> optional;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (input instanceof JsonPrimitive && ((JsonPrimitive)input).getValue() instanceof String) {
            Object object = ((JsonPrimitive)input).getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            Optional<String> optional2 = Optional.of((String)object);
            optional = optional2;
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.of(input.value as String)");
        } else {
            Optional<String> optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"Optional.empty()");
        }
        return optional;
    }

    @NotNull
    public JsonElement createString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return (JsonElement)new JsonPrimitive((Object)value);
    }

    @NotNull
    public JsonElement mergeInto(@NotNull JsonElement input, @NotNull JsonElement value) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value instanceof JsonNull) {
            return value;
        }
        boolean bl = !(input instanceof JsonNull);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "mergeInto called with null input.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (input instanceof JsonObject) {
            if (value instanceof JsonObject) {
                JsonObject result = new JsonObject();
                result.putAll((Map)input);
                result.putAll((Map)value);
                return (JsonElement)result;
            }
            return input;
        }
        if (input instanceof JsonArray) {
            JsonArray result = new JsonArray();
            result.addAll((Collection)input);
            result.add(value);
            return (JsonElement)result;
        }
        return input;
    }

    @NotNull
    public JsonElement mergeInto(@NotNull JsonElement input, @NotNull JsonElement key, @NotNull JsonElement value) {
        JsonObject jsonObject;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonElement jsonElement = input;
        if (jsonElement instanceof JsonNull) {
            jsonObject = new JsonObject();
        } else if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject2 = new JsonObject();
            boolean bl = false;
            boolean bl2 = false;
            JsonObject it = jsonObject2;
            boolean bl3 = false;
            it.putAll((Map)input);
            jsonObject = jsonObject2;
        } else {
            return input;
        }
        JsonObject output = jsonObject;
        ((Map)output).put(((JsonPrimitive)key).asString(), value);
        return (JsonElement)output;
    }

    @NotNull
    public JsonElement merge(@NotNull JsonElement first, @NotNull JsonElement second) {
        JsonElement jsonElement;
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
        if (first instanceof JsonNull) {
            jsonElement = second;
        } else if (second instanceof JsonNull) {
            jsonElement = first;
        } else if (first instanceof JsonObject && second instanceof JsonObject) {
            JsonObject jsonObject = new JsonObject();
            boolean bl = false;
            boolean bl2 = false;
            JsonObject result = jsonObject;
            boolean bl3 = false;
            result.putAll((Map)first);
            result.putAll((Map)second);
            jsonElement = (JsonElement)jsonObject;
        } else if (first instanceof JsonArray && second instanceof JsonArray) {
            JsonArray jsonArray = new JsonArray();
            boolean bl = false;
            boolean bl4 = false;
            JsonArray result = jsonArray;
            boolean bl5 = false;
            result.addAll((Collection)first);
            result.addAll((Collection)second);
            jsonElement = (JsonElement)jsonArray;
        } else {
            throw (Throwable)new IllegalArgumentException("Could not merge " + first + " and " + second);
        }
        return jsonElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Optional<Map<JsonElement, JsonElement>> getMapValues(@NotNull JsonElement input) {
        Optional<Map<JsonElement, JsonElement>> optional;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (input instanceof JsonObject) {
            void $this$mapKeysTo$iv$iv;
            Map $this$mapKeys$iv = (Map)input;
            boolean $i$f$mapKeys = false;
            Map map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void $dstr$key$_u24__u24;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                void var13_13 = $dstr$key$_u24__u24;
                boolean bl2 = false;
                String key = (String)var13_13.getKey();
                JsonPrimitive jsonPrimitive = new JsonPrimitive((Object)key);
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                JsonPrimitive jsonPrimitive2 = jsonPrimitive;
                Map map3 = map2;
                boolean bl3 = false;
                entry = it$iv$iv.getValue();
                map3.put(jsonPrimitive2, entry);
            }
            Optional<Map> optional2 = Optional.of(destination$iv$iv);
            optional = optional2;
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.of(input.mapKey\u2026 -> JsonPrimitive(key) })");
        } else {
            Optional<Map<JsonElement, JsonElement>> optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"Optional.empty()");
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsonElement createMap(@NotNull Map<JsonElement, ? extends JsonElement> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject result = jsonObject;
        boolean bl3 = false;
        JsonElement jsonElement = map;
        boolean bl4 = false;
        Iterator<Map.Entry<JsonElement, ? extends JsonElement>> iterator = jsonElement.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<JsonElement, ? extends JsonElement> entry;
            Map.Entry<JsonElement, ? extends JsonElement> entry2 = entry = iterator.next();
            boolean bl5 = false;
            jsonElement = entry2.getKey();
            entry2 = entry;
            bl5 = false;
            JsonElement value = entry2.getValue();
            void v0 = key;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type blue.endless.jankson.JsonPrimitive");
            }
            ((Map)result).put(((JsonPrimitive)v0).asString(), value);
        }
        return (JsonElement)jsonObject;
    }

    @NotNull
    public Optional<Stream<JsonElement>> getStream(@NotNull JsonElement input) {
        Optional<Stream<JsonElement>> optional;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (input instanceof JsonArray) {
            Optional<Stream> optional2 = Optional.of(((JsonArray)input).stream());
            optional = optional2;
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.of(input.stream())");
        } else {
            Optional optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"Optional.empty()");
        }
        return optional;
    }

    @NotNull
    public JsonElement createList(@NotNull Stream<JsonElement> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        JsonArray jsonArray = new JsonArray();
        boolean bl = false;
        boolean bl2 = false;
        JsonArray result = jsonArray;
        boolean bl3 = false;
        input.forEach(new Consumer<JsonElement>(result){
            final /* synthetic */ JsonArray $result;

            public final void accept(JsonElement it) {
                this.$result.add(it);
            }
            {
                this.$result = jsonArray;
            }
        });
        return (JsonElement)jsonArray;
    }

    @NotNull
    public JsonElement remove(@NotNull JsonElement input, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (input instanceof JsonObject) {
            JsonObject result = new JsonObject();
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)MapsKt.asSequence((Map)((Map)input)), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends JsonElement>, Boolean>(key){
                final /* synthetic */ String $key;

                public final boolean invoke(@NotNull Map.Entry<String, ? extends JsonElement> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getKey(), (Object)this.$key) ^ true;
                }
                {
                    this.$key = string;
                    super(1);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry $dstr$key$value = (Map.Entry)element$iv;
                boolean bl = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl2 = false;
                String key2 = (String)entry.getKey();
                entry = $dstr$key$value;
                bl2 = false;
                JsonElement value = (JsonElement)entry.getValue();
                ((Map)result).put(key2, value);
            }
            return (JsonElement)result;
        }
        return input;
    }

    @NotNull
    public String toString() {
        return "JSON";
    }

    private JanksonOps() {
    }

    static {
        JanksonOps janksonOps;
        INSTANCE = janksonOps = new JanksonOps();
    }
}

