/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.gui.config.EntityListConfigScreen;
import dlovin.advancedcompass.gui.config.widgets.ButtonWidget;
import dlovin.advancedcompass.gui.config.widgets.ImageWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.IconCreator;
import dlovin.advancedcompass.utils.TextureRes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class IconConfigGui
extends Screen {
    EntityType type;
    Collection<Widget> widgets;
    boolean inGame;
    int scroll;
    private ArrayDeque<IconQueue> queue;
    ImageWidget image;

    protected IconConfigGui(EntityType type, boolean inGame, int scroll) {
        super((Component)new TextComponent(""));
        this.type = type;
        this.inGame = inGame;
        this.scroll = scroll;
    }

    public void m_7856_() {
        this.queue = new ArrayDeque();
        this.widgets = new ArrayList<Widget>();
        TextureRes res = (TextureRes)HeadUtils.heads.get(this.type);
        this.image = new ImageWidget(this.f_96543_ / 2 - res.width, this.f_96544_ / 2 - 95, res.width * 2, res.height * 2, res.res, Color.WHITE);
        this.widgets.add(this.image);
        int max = Math.max(res.width, res.height) * 2 + 8;
        this.image.setupBorder(max, max);
        String text = Translation.GENERATION_HEAD.getString();
        ButtonWidget tmp = new ButtonWidget(this.f_96543_ / 2 - (this.f_96547_.m_92895_(text) + 10) / 2, this.f_96544_ / 2 - 40, this.f_96547_.m_92895_(text) + 10, 20, text);
        this.widgets.add(tmp);
        tmp.addListener(() -> this.Regenerate(0));
        text = Translation.GENERATION_FULL.getString();
        tmp = new ButtonWidget(this.f_96543_ / 2 - (this.f_96547_.m_92895_(text) + 10) / 2, this.f_96544_ / 2 - 10, this.f_96547_.m_92895_(text) + 10, 20, text);
        this.widgets.add(tmp);
        tmp.addListener(() -> this.Regenerate(1));
        text = Translation.GENERATION_DEF.getString();
        tmp = new ButtonWidget(this.f_96543_ / 2 - (this.f_96547_.m_92895_(text) + 10) / 2, this.f_96544_ / 2 + 20, this.f_96547_.m_92895_(text) + 10, 20, text);
        this.widgets.add(tmp);
        tmp.addListener(() -> this.Regenerate(2));
        text = Translation.BACK.getString();
        tmp = new ButtonWidget(this.f_96543_ / 2 - 20, this.f_96544_ / 2 + 70, 50, 20, text);
        this.widgets.add(tmp);
        tmp.addListener(this::m_7379_);
        this.m_6702_().addAll(this.widgets);
    }

    private void recalculateImageSize() {
        TextureRes tex = (TextureRes)HeadUtils.heads.get(this.type);
        this.image.x = this.f_96543_ / 2 - tex.width;
        this.image.width = tex.width * 2;
        this.image.height = tex.height * 2;
        int max = Math.max(tex.width, tex.height) * 2 + 8;
        this.image.setupBorder(max, max);
    }

    private void Regenerate(int i) {
        Entity en = this.type.m_20615_((Level)this.f_96541_.f_91073_);
        this.queue.add(new IconQueue(en, i));
    }

    public void m_6305_(PoseStack mat, int mouseX, int mouseY, float partialTicks) {
        super.m_7333_(mat);
        this.widgets.forEach(w -> w.m_6305_(mat, mouseX, mouseY, partialTicks));
        while (this.queue.peek() != null) {
            IconQueue item = this.queue.pop();
            Entity en = item.en;
            ResourceLocation resourceLocation = this.f_96541_.m_91290_().m_114382_(en).m_5478_(en);
            RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
            String namespace = en.m_6095_().getRegistryName().m_135827_();
            ResourceLocation res = switch (item.type) {
                case 0 -> IconCreator.fullCycle(en, namespace, resourceLocation, partialTicks);
                case 1 -> IconCreator.bodyCycle(en, namespace);
                case 2 -> IconCreator.saveDefault(en, namespace);
                default -> null;
            };
            if (res != null) {
                Minecraft.m_91087_().f_90987_.m_118513_(res);
            }
            this.f_96541_.f_91073_.m_171642_(en.m_142049_(), Entity.RemovalReason.DISCARDED);
            this.recalculateImageSize();
        }
    }

    public void m_7379_() {
        EntityListConfigScreen screen = new EntityListConfigScreen(this.inGame);
        this.f_96541_.m_91152_((Screen)screen);
        screen.OptionList.setScroll(this.scroll);
    }

    private class IconQueue {
        int type;
        Entity en;

        public IconQueue(Entity en, int type) {
            this.type = type;
            this.en = en;
        }
    }
}

