/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.gui.config.WaypointListGui;
import dlovin.advancedcompass.gui.config.widgets.ButtonWidget;
import dlovin.advancedcompass.gui.config.widgets.CheckBox;
import dlovin.advancedcompass.gui.config.widgets.ColorPicker;
import dlovin.advancedcompass.gui.config.widgets.MultiImageWidget;
import dlovin.advancedcompass.gui.config.widgets.NumericTextField;
import dlovin.advancedcompass.gui.config.widgets.TextField;
import dlovin.advancedcompass.gui.config.widgets.TextWidget;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import dlovin.advancedcompass.references.Translation;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.StringUtils;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import dlovin.advancedcompass.utils.waypoints.WaypointIcon;
import dlovin.advancedcompass.utils.waypoints.WaypointJsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;

public class WaypointAddGui
extends Screen {
    private boolean fromList = false;
    Collection<Widget> widgets;
    MultiImageWidget iconWidget;
    ColorPicker pickerWidget;
    TextField nameWidget;
    NumericTextField[] positionWidgets;
    NumericTextField[] distanceWidgets;
    CheckBox enableWidget;
    Waypoint waypoint;
    TextWidget[] resultString;
    boolean force = false;

    public WaypointAddGui(Waypoint waypoint) {
        super((Component)new TextComponent(""));
        this.waypoint = waypoint;
    }

    public WaypointAddGui() {
        this(new Waypoint("Name", Minecraft.m_91087_().f_91074_.m_20182_(), Minecraft.m_91087_().f_91074_.f_108545_.m_46472_().m_135782_().toString(), WaypointIcon.HOME, new Color(1.0f, 1.0f, 1.0f), 0, 0, true));
    }

    public WaypointAddGui(boolean fromlist) {
        this();
        this.fromList = fromlist;
    }

    public void m_7856_() {
        this.force = false;
        this.widgets = new ArrayList<Widget>();
        this.iconWidget = new MultiImageWidget(this.f_96543_ / 2 - 16, this.f_96544_ / 2 - 95, 32, 32, new ResourceLocation("advancedcompass", "textures/waypoints.png"), this.waypoint.getColor(), this.waypoint.getIcon().ordinal());
        this.widgets.add(this.iconWidget);
        this.iconWidget.setupArray(4, 4, 16);
        this.iconWidget.setupImages(128, 128, 32, 32);
        ButtonWidget tmpBtn = new ButtonWidget(this.f_96543_ / 2 - 41, this.f_96544_ / 2 - 87, 16, 16, "<");
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(() -> this.changeIcon(this.iconWidget, -1));
        tmpBtn = new ButtonWidget(this.f_96543_ / 2 + 25, this.f_96544_ / 2 - 87, 16, 16, ">");
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(() -> this.changeIcon(this.iconWidget, 1));
        this.widgets.add(new TextWidget(this.f_96543_ / 2 - 110, this.f_96544_ / 2 - 39, -1, TextWidget.TextAlign.LEFT, Translation.WPNAME.getString(), this.f_96547_));
        this.nameWidget = new TextField(this.f_96547_, this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 49, 140, 20, this.waypoint.getName(), this::onNameChanged);
        this.widgets.add(this.nameWidget);
        this.nameWidget.setMaxStringLength(25);
        this.positionWidgets = new NumericTextField[3];
        this.widgets.add(new TextWidget(this.f_96543_ / 2 - 110, this.f_96544_ / 2 - 13, -1, TextWidget.TextAlign.LEFT, Translation.WPPOS.getString(), this.f_96547_));
        this.positionWidgets[0] = new NumericTextField(this.f_96547_, this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 23, 40, 20, (int)this.waypoint.getPosition().f_82479_, w -> this.onPositionChanged(w, this.positionWidgets[1], this.positionWidgets[2]));
        this.widgets.add(this.positionWidgets[0]);
        this.positionWidgets[1] = new NumericTextField(this.f_96547_, this.f_96543_ / 2 + 10, this.f_96544_ / 2 - 23, 40, 20, (int)this.waypoint.getPosition().f_82480_, w -> this.onPositionChanged(this.positionWidgets[0], w, this.positionWidgets[2]));
        this.widgets.add(this.positionWidgets[1]);
        this.positionWidgets[2] = new NumericTextField(this.f_96547_, this.f_96543_ / 2 + 60, this.f_96544_ / 2 - 23, 40, 20, (int)this.waypoint.getPosition().f_82481_, w -> this.onPositionChanged(this.positionWidgets[0], this.positionWidgets[1], w));
        this.widgets.add(this.positionWidgets[2]);
        this.distanceWidgets = new NumericTextField[2];
        this.widgets.add(new TextWidget(this.f_96543_ / 2 - 110, this.f_96544_ / 2 + 13, -1, TextWidget.TextAlign.LEFT, Translation.WPDISTANCE.getString(), this.f_96547_, (w, m, x, y) -> this.m_96602_(m, Translation.WPDISTANCE_TT, x, y)));
        this.widgets.add(new TextWidget(this.f_96543_ / 2 - 40, this.f_96544_ / 2 + 13, -1, TextWidget.TextAlign.LEFT, Translation.WPDISTANCE_MIN.getString(), this.f_96547_));
        this.widgets.add(new TextWidget(this.f_96543_ / 2 + 35, this.f_96544_ / 2 + 13, -1, TextWidget.TextAlign.LEFT, Translation.WPDISTANCE_MAX.getString(), this.f_96547_));
        this.distanceWidgets[0] = new NumericTextField(this.f_96547_, this.f_96543_ / 2 - 15, this.f_96544_ / 2 + 3, 40, 20, this.waypoint.getMinDistance(), this::onMinDistanceChanged);
        this.widgets.add(this.distanceWidgets[0]);
        this.distanceWidgets[1] = new NumericTextField(this.f_96547_, this.f_96543_ / 2 + 60, this.f_96544_ / 2 + 3, 40, 20, this.waypoint.getMaxDistance(), this::onMaxDistanceChanged);
        this.widgets.add(this.distanceWidgets[1]);
        this.widgets.add(new TextWidget(this.f_96543_ / 2 - 110, this.f_96544_ / 2 + 39, -1, TextWidget.TextAlign.LEFT, Translation.WPCOLOR.getString(), this.f_96547_));
        this.pickerWidget = new ColorPicker(this.f_96543_ / 2 - 40, this.f_96544_ / 2 + 29, 30, 20, this.waypoint.getColor());
        this.pickerWidget.addListener(() -> this.onColorChanged(this.iconWidget, this.pickerWidget.getColor()));
        this.widgets.add(new TextWidget(this.f_96543_ / 2 + 30, this.f_96544_ / 2 + 39, -1, TextWidget.TextAlign.LEFT, Translation.WPENABLED.getString(), this.f_96547_));
        this.enableWidget = new CheckBox(this.f_96543_ / 2 + 80, this.f_96544_ / 2 + 29, 20, 20, this::onEnabledChanged, this.waypoint.isEnabled());
        this.widgets.add(this.enableWidget);
        this.resultString = new TextWidget[2];
        this.resultString[0] = new TextWidget(this.f_96543_ / 2, this.f_96544_ / 2 + 65, 0xFFFFFF, TextWidget.TextAlign.CENTER, "", this.f_96547_);
        this.widgets.add(this.resultString[0]);
        this.resultString[1] = new TextWidget(this.f_96543_ / 2, this.f_96544_ / 2 + 75, 0xFFFFFF, TextWidget.TextAlign.CENTER, "", this.f_96547_);
        this.widgets.add(this.resultString[1]);
        tmpBtn = new ButtonWidget(this.f_96543_ / 2 - 110, this.f_96544_ / 2 + 100, 60, 20, Translation.WPCANCEL.getString());
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(this::onCancel);
        tmpBtn = new ButtonWidget(this.f_96543_ / 2 - 40, this.f_96544_ / 2 + 100, 80, 20, Translation.WPLIST.getString());
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(this::onList);
        tmpBtn = new ButtonWidget(this.f_96543_ / 2 + 50, this.f_96544_ / 2 + 100, 60, 20, Translation.WPSAVE.getString());
        this.widgets.add(tmpBtn);
        tmpBtn.addListener(this::onSave);
        this.m_6702_().addAll(this.widgets);
        this.m_6702_().add(this.pickerWidget);
    }

    private void onList() {
        this.f_96541_.m_91152_((Screen)new WaypointListGui());
    }

    private void onColorChanged(MultiImageWidget tmpImage, Color color) {
        tmpImage.setColor(color);
        this.waypoint.setColor(color);
    }

    private void changeIcon(MultiImageWidget tmpImage, int i) {
        tmpImage.next(i);
        this.waypoint.setIcon(tmpImage.getIndex());
    }

    void onSave() {
        String dir = this.f_96541_.m_91089_() != null ? StringUtils.trimPort(this.f_96541_.m_91089_().f_105363_) : StringUtils.removeIllegal(((ServerLevelData)this.f_96541_.m_91092_().m_129783_().m_6106_()).m_5462_());
        Object[] result = WaypointJsonUtils.addWaypoint(dir, this.waypoint, this.force);
        this.force = false;
        if (((Boolean)result[0]).booleanValue()) {
            AdvancedCompass.getInstance().getCompassGui().addWaypoint(new Waypoint(this.waypoint));
            this.resultString[0].setColor(0xFFFFFF);
            this.resultString[1].setColor(0xFFFFFF);
            this.f_96541_.m_91152_(null);
        } else if (((String)result[1]).equals(Translation.WAYPOINT_EMPTY_NAME.getString())) {
            this.resultString[0].setColor(0xFF0000);
            this.resultString[1].setColor(0xFF0000);
        } else if (((String)result[1]).equals(Translation.WAYPOINT_EXISTS_1.getString())) {
            this.resultString[0].setColor(0xFF8000);
            this.resultString[1].setColor(0xFF8000);
            this.force = true;
        }
        this.resultString[0].setText((String)result[1]);
        this.resultString[1].setText((String)result[2]);
    }

    void onCancel() {
        this.m_7379_();
    }

    public void m_7379_() {
        if (this.fromList) {
            this.f_96541_.m_91152_((Screen)new WaypointListGui());
        } else {
            this.f_96541_.m_91152_(null);
        }
    }

    private void onEnabledChanged(CheckBox checkBox) {
        this.waypoint.setEnabled(checkBox.checked);
    }

    private void onMinDistanceChanged(TextField textField) {
        this.waypoint.setMinDistance(((NumericTextField)textField).getValue());
    }

    private void onMaxDistanceChanged(TextField textField) {
        this.waypoint.setMaxDistance(((NumericTextField)textField).getValue());
    }

    private void onNameChanged(TextField textField) {
        this.force = false;
        this.resultString[0].setText("");
        this.resultString[1].setText("");
        this.waypoint.setName(textField.getText());
    }

    private void onPositionChanged(TextField fieldX, TextField fieldY, TextField fieldZ) {
        this.waypoint.setPosition(new Vec3((double)((NumericTextField)fieldX).getValue(), (double)((NumericTextField)fieldY).getValue(), (double)((NumericTextField)fieldZ).getValue()));
    }

    public void m_6305_(PoseStack mat, int mouseX, int mouseY, float partialTicks) {
        super.m_7333_(mat);
        this.widgets.forEach(w -> w.m_6305_(mat, mouseX, mouseY, partialTicks));
        this.widgets.forEach(w -> w.renderTooltip(mat, mouseX, mouseY));
        this.pickerWidget.m_6305_(mat, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mx, double my, int b) {
        if (this.pickerWidget.m_6375_(mx, my, b)) {
            return true;
        }
        this.widgets.forEach(w -> w.m_6375_(mx, my, b));
        return false;
    }

    public boolean m_5534_(char p_231042_1_, int p_231042_2_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
            w.m_5534_(p_231042_1_, p_231042_2_);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
            w.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
            return true;
        }
        return super.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }
}

