/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.config.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.gui.config.widgets.Widget;
import net.minecraft.client.gui.Font;
import net.minecraft.resources.ResourceLocation;

public class TextWidget
extends Widget {
    private int color;
    private final Font fontRenderer;
    private final boolean withTooltip;
    private final int originalX;
    private final TextAlign align;
    private static final ResourceLocation TT_ICON = new ResourceLocation("advancedcompass", "textures/gui/widgets/tt_icon.png");

    public void setText(String text) {
        this.setMessage(text);
        this.width = this.fontRenderer.m_92895_(text) + 10;
        switch (this.align) {
            case CENTER: {
                this.x = this.originalX - (this.width / 2 - 5);
                break;
            }
            case RIGHT: {
                this.x = this.originalX - (this.width - 10);
            }
        }
    }

    public void setColor(int color) {
        this.color = color;
    }

    public TextWidget(int x, String text, Font fontRenderer, Widget.ITooltip tooltip) {
        this(x, 10, 0xFFFFFF, TextAlign.RIGHT, text, fontRenderer, tooltip);
    }

    public TextWidget(int x, int y, int color, TextAlign align, String text, Font fontRenderer, Widget.ITooltip tooltip) {
        super(x - 5, y - 9, fontRenderer.m_92895_(text) + 10, 18, text, tooltip);
        this.originalX = this.x;
        switch (align) {
            case CENTER: {
                this.x -= this.width / 2 - 5;
                break;
            }
            case RIGHT: {
                this.x -= this.width - 10;
            }
        }
        this.color = color;
        this.fontRenderer = fontRenderer;
        this.withTooltip = true;
        this.align = align;
    }

    public TextWidget(int x, String text, Font fontRenderer) {
        this(x, 10, 0xFFFFFF, TextAlign.RIGHT, text, fontRenderer);
    }

    public TextWidget(int x, int y, int color, TextAlign align, String text, Font fontRenderer) {
        super(x - 5, y - 9, fontRenderer.m_92895_(text) + 10, 18, text);
        this.originalX = this.x;
        switch (align) {
            case CENTER: {
                this.x -= this.width / 2 - 5;
                break;
            }
            case RIGHT: {
                this.x -= this.width - 10;
            }
        }
        this.color = color;
        this.fontRenderer = fontRenderer;
        this.withTooltip = false;
        this.align = align;
    }

    @Override
    public void m_6305_(PoseStack mat, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(mat, mouseX, mouseY, partialTick);
        this.fontRenderer.m_92750_(mat, this.getMessage(), (float)(this.x + 5), (float)(this.y + 5), this.color);
        if (this.withTooltip) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TT_ICON);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            TextWidget.m_93133_((PoseStack)mat, (int)(this.x + this.width - 8), (int)this.y, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8);
            RenderSystem.m_69461_();
        }
    }

    @Override
    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        return false;
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

