/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.advancedcompass.gui.renderers.IRenderer;
import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.NumsUtils;
import dlovin.advancedcompass.utils.SettingsValues;
import dlovin.advancedcompass.utils.TextureCoords;
import dlovin.advancedcompass.utils.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class WaypointRenderer
extends IRenderer {
    Collection<Waypoint> waypoints = new ArrayList<Waypoint>();

    public WaypointRenderer(Minecraft mc, Font fontRenderer, SettingsValues settings) {
        super(mc, fontRenderer, settings);
    }

    private Collection<Waypoint> getSorted(Collection<Waypoint> wpIn) {
        return wpIn.stream().sorted(Comparator.comparing(w -> ((Waypoint)w).distanceTo(this.mc.f_91074_)).reversed()).collect(Collectors.toList());
    }

    public void render(PoseStack mat, float angle, float scale) {
        mat.m_85836_();
        for (Waypoint waypoint : this.getSorted(this.waypoints)) {
            int distance = (int)this.getFlatDistance(waypoint.getPosition(), this.mc.f_91074_.m_20182_());
            if (!waypoint.isEnabled() || waypoint.getMaxDistance() != 0 && distance >= waypoint.getMaxDistance() || waypoint.getMinDistance() >= distance) continue;
            this.drawWaypoint(mat, waypoint.getIcon().ordinal(), this.ToFormat(90.0f + angle + this.getAngle(waypoint.getPosition())), scale, waypoint.getColor(), this.mc.f_91074_.m_20186_() - waypoint.getPosition().f_82480_, this.settings.showDistance ? distance : 0);
        }
        mat.m_85849_();
    }

    private void drawWaypoint(PoseStack mat, int icon, double angle, float scale, Color color, double hDif, int distance) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.WAYPOINTS);
        mat.m_85836_();
        mat.m_85837_(this.getX(angle, scale), (double)((float)(this.settings.compassHeight / 2) * scale), 0.0);
        mat.m_85841_(scale * this.iconScale, scale * this.iconScale, scale * this.iconScale);
        float alpha = 1.25f - Mth.m_14036_((float)((float)Math.abs(angle) / (float)this.settings.getViewAngle()), (float)0.25f, (float)1.0f);
        RenderSystem.m_157429_((float)color.r, (float)color.g, (float)color.b, (float)alpha);
        int xOffset = 16 * (icon % 4);
        int yOffset = 16 * (icon / 4);
        GuiComponent.m_93133_((PoseStack)mat, (int)-8, (int)-8, (float)xOffset, (float)yOffset, (int)16, (int)16, (int)64, (int)64);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (hDif < -3.0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ARROWS);
            GuiComponent.m_93133_((PoseStack)mat, (int)3, (int)0, (float)0.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        } else if (hDif > 3.0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ARROWS);
            GuiComponent.m_93133_((PoseStack)mat, (int)3, (int)0, (float)7.0f, (float)0.0f, (int)7, (int)7, (int)16, (int)16);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (distance > 0) {
            mat.m_85836_();
            mat.m_85837_((double)NumsUtils.getWidth(distance + "m") / 2.0, 5.0, 0.0);
            int width = 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.NUMS);
            TextureCoords c = NumsUtils.nums[10];
            GuiComponent.m_93133_((PoseStack)mat, (int)(-c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
            width += c.width - 1;
            while (distance > 0) {
                c = NumsUtils.nums[distance % 10];
                GuiComponent.m_93133_((PoseStack)mat, (int)(-width - c.width), (int)0, (float)c.xOffset, (float)c.yOffset, (int)c.width, (int)c.height, (int)128, (int)16);
                distance /= 10;
                width += c.width - 1;
            }
            mat.m_85849_();
        }
        mat.m_85849_();
    }

    public void removeWaypointByName(String name) {
        this.waypoints.removeIf(w -> w.getName().equals(name));
    }

    public void addWaypoint(Waypoint waypoint) {
        if (this.waypoints.stream().anyMatch(w -> w.getName().equals(waypoint.getName()))) {
            Waypoint tmp = this.waypoints.stream().filter(w -> w.getName().equals(waypoint.getName())).findFirst().get();
            this.waypoints.remove(tmp);
        }
        this.waypoints.add(waypoint);
    }

    public void setWaypoints(Collection waypoints) {
        this.waypoints = waypoints;
    }

    public void removeWaypoint(Waypoint wIn) {
        this.waypoints.removeIf(w -> w.getName().equals(wIn.getName()) && w.getDimension().equals(wIn.getDimension()));
    }

    public void changeWaypoint(Waypoint w) {
        for (Waypoint wp : this.waypoints) {
            if (!wp.getName().equals(w.getName()) || !wp.getDimension().equals(w.getDimension())) continue;
            wp.setEnabled(w.isEnabled());
            return;
        }
    }
}

