/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.GLRefs;
import dlovin.advancedcompass.utils.GLTools;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.ImageUtils;
import dlovin.advancedcompass.utils.JsonUtils;
import dlovin.advancedcompass.utils.ReflectionUtils;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BatModel;
import net.minecraft.client.model.BeeModel;
import net.minecraft.client.model.BlazeModel;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.DolphinModel;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.PhantomModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.PolarBearModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.RabbitModel;
import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.SilverfishModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.TropicalFishModelA;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraftforge.fml.loading.FMLPaths;

public class IconCreator {
    private static ResourceLocation TryToSaveIcon(BufferedImage mobSkin, Entity en, String namespace) throws RasterFormatException {
        if (mobSkin != null) {
            File directory = new File(FMLPaths.CONFIGDIR.get() + "/AdvancedCompass/mobs/" + namespace);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File outputfile = new File(directory + "/" + en.m_6095_().getRegistryName().m_135815_() + ".png");
            try {
                BufferedImage editedImage = ImageUtils.outlineImage(ImageUtils.rescale(ImageUtils.cropImage(mobSkin), 1));
                ImageIO.write((RenderedImage)editedImage, "png", outputfile);
                return IconCreator.saveJson(en, namespace, editedImage.getWidth(), editedImage.getHeight());
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        AdvancedCompass.logger.info("Can't create icon for: " + en.m_6095_().getRegistryName());
        return null;
    }

    private static ResourceLocation saveJson(Entity en, String namespace, int width, int height) {
        JsonUtils.addMob(namespace + "/mobs.json", en.m_6095_().getRegistryName().m_135815_(), width, height);
        ResourceLocation res = new ResourceLocation("advancedcompass." + namespace, en.m_6095_().getRegistryName().m_135815_());
        HeadUtils.addHead(en.m_6095_(), width, height, res);
        GroupUtils.types.add(en.m_6095_());
        return res;
    }

    public static ResourceLocation fullCycle(Entity en, String namespace, ResourceLocation resourceLocation, float ticks) {
        Minecraft mc = Minecraft.m_91087_();
        BufferedImage mobSkin = IconCreator.createAutoIconImageFromResourceLocations(en, (EntityRenderer<? extends Entity>)mc.m_91290_().m_114382_(en), resourceLocation, ticks);
        try {
            ResourceLocation res = IconCreator.TryToSaveIcon(mobSkin, en, namespace);
            return res;
        }
        catch (RasterFormatException ex) {
            mobSkin = IconCreator.createAutoIconViaEntityRenderer(en);
            try {
                ResourceLocation res = IconCreator.TryToSaveIcon(mobSkin, en, namespace);
                return res;
            }
            catch (RasterFormatException ex1) {
                ResourceLocation res = IconCreator.saveDefault(en, namespace);
                AdvancedCompass.logger.info("Can't create icon for: " + en.m_6095_().getRegistryName());
                return res;
            }
        }
    }

    public static ResourceLocation bodyCycle(Entity en, String namespace) {
        BufferedImage mobSkin = IconCreator.createAutoIconViaEntityRenderer(en);
        try {
            ResourceLocation res = IconCreator.TryToSaveIcon(mobSkin, en, namespace);
            return res;
        }
        catch (RasterFormatException ex1) {
            ResourceLocation res = IconCreator.saveDefault(en, namespace);
            AdvancedCompass.logger.info("Can't create icon for: " + en.m_6095_().getRegistryName());
            return res;
        }
    }

    public static ResourceLocation saveDefault(Entity en, String namespace) {
        ResourceLocation res = en.m_6095_().m_20674_().m_21609_() ? new ResourceLocation("advancedcompass", "textures/neutral.png") : new ResourceLocation("advancedcompass", "textures/hostile.png");
        try {
            InputStream is = Minecraft.m_91087_().m_91098_().m_142591_(res).m_6679_();
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            File directory = new File(FMLPaths.CONFIGDIR.get() + "/AdvancedCompass/mobs/" + namespace);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File outputfile = new File(directory + "/" + en.m_6095_().getRegistryName().m_135815_() + ".png");
            FileOutputStream outStream = new FileOutputStream(outputfile);
            ((OutputStream)outStream).write(buffer);
            ((OutputStream)outStream).close();
            is.close();
            return IconCreator.saveJson(en, namespace, 16, 16);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static BufferedImage createAutoIconViaEntityRenderer(Entity en) {
        BufferedImage headImage = null;
        try {
            boolean success = IconCreator.drawEntity((LivingEntity)en);
            if (success) {
                headImage = ImageUtils.createBufferedImageFromGLID(GLTools.textureID);
            }
        }
        catch (Exception ex) {
            headImage = null;
            ex.printStackTrace();
        }
        return headImage;
    }

    /*
     * Unable to fully structure code
     */
    private static BufferedImage createAutoIconImageFromResourceLocations(Entity en, EntityRenderer<? extends Entity> render, ResourceLocation resourceLocations, float partialTicks) {
        mc = Minecraft.m_91087_();
        headImage = null;
        model = null;
        if (render instanceof LivingEntityRenderer || render == null) {
            try {
                model = ((LivingEntityRenderer)render).m_7200_();
                if (render instanceof TropicalFishRenderer) {
                    fishModel = null;
                    size = ((TropicalFish)en).m_30045_();
                    fishModel = size == 0 ? ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishModelA.class) : ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishModelB.class);
                    if (fishModel != null) {
                        model = (EntityModel)fishModel;
                    }
                }
                submodels = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelPart.class);
                submodelArrays = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelPart[].class);
                headBits = null;
                headPartsWithResourceLocationList = new ArrayList<ModelPartWithResourceLocation>();
                properties = new Properties();
                fullName = en.getClass().getName();
                simpleName = en.getClass().getSimpleName();
                fullPath = ("textures/icons/" + fullName + ".properties").toLowerCase();
                is = null;
                try {
                    is = mc.m_91098_().m_142591_(new ResourceLocation(fullPath)).m_6679_();
                }
                catch (Exception var27) {
                    is = null;
                }
                if (is == null) {
                    fullPath = ("textures/icons/" + simpleName + ".properties").toLowerCase();
                    try {
                        is = mc.m_91098_().m_142591_(new ResourceLocation(fullPath)).m_6679_();
                    }
                    catch (Exception var26) {
                        is = null;
                    }
                }
                if (is != null) {
                    properties.load(is);
                    is.close();
                    subModelNames = properties.getProperty("models", "").toLowerCase();
                    submodelNamesArray = subModelNames.split(",");
                    subModelNamesList = Arrays.asList(submodelNamesArray);
                    subModelNamesSet = new HashSet<String>();
                    subModelNamesSet.addAll(subModelNamesList);
                    headPartsArrayList = new ArrayList<ModelPart>();
                    var20 = submodelArrays.iterator();
                    block8: while (true) {
                        if (!var20.hasNext()) {
                            var20 = submodels.iterator();
                            while (true) {
                                if (!var20.hasNext()) {
                                    if (headPartsArrayList.size() <= 0) break block8;
                                    headBits = headPartsArrayList.toArray(new ModelPart[headPartsArrayList.size()]);
                                    break block8;
                                }
                                submodel = var20.next();
                                name = submodel.getName().toLowerCase();
                                if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || submodel.get(model) == null) continue;
                                headPartsArrayList.add((ModelPart)submodel.get(model));
                            }
                        }
                        submodel = var20.next();
                        name = submodel.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || (submodelArrayValue = (ModelPart[])submodel.get(model)) == null) continue;
                        t = 0;
                        while (true) {
                            if (t < submodelArrayValue.length) ** break;
                            continue block8;
                            headPartsArrayList.add(submodelArrayValue[t]);
                            ++t;
                        }
                        break;
                    }
                }
                if (headBits == null) {
                    if (model instanceof PlayerModel) {
                        showHat = true;
                        if (en instanceof Player) {
                            player = (Player)en;
                            showHat = player.m_36170_(PlayerModelPart.HAT);
                        }
                        headBits = showHat ? new ModelPart[]{((PlayerModel)model).f_102808_, ((PlayerModel)model).f_102809_} : new ModelPart[]{((PlayerModel)model).f_102808_};
                    } else if (model instanceof BatModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelPart.class)};
                    } else if (model instanceof BeeModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelPart.class, 0), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelPart.class, 8), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelPart.class, 9)};
                    } else if (model instanceof HumanoidModel) {
                        headBits = new ModelPart[]{((HumanoidModel)model).f_102808_, ((HumanoidModel)model).f_102809_};
                    } else if (model instanceof BlazeModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, BlazeModel.class, ModelPart.class)};
                    } else if (model instanceof ChickenModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, ChickenModel.class, ModelPart.class)};
                    } else if (model instanceof CowModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelPart.class)};
                    } else if (model instanceof CreeperModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, CreeperModel.class, ModelPart.class)};
                    } else if (model instanceof DolphinModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, DolphinModel.class, ModelPart.class)};
                    } else if (model instanceof EnderDragonRenderer.DragonModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, EnderDragonRenderer.DragonModel.class, ModelPart.class)};
                    } else if (model instanceof GhastModel) {
                        headBits = new ModelPart[]{(ModelPart)((GhastModel)model).m_142109_().m_171331_().iterator().next()};
                    } else if (model instanceof GuardianModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelPart.class, 0), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelPart.class, 1)};
                    } else if (model instanceof HorseModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, HorseModel.class, ModelPart.class)};
                    } else if (model instanceof IllagerModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, IllagerModel.class, ModelPart.class)};
                    } else if (model instanceof IronGolemModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, IronGolemModel.class, ModelPart.class)};
                    } else if (model instanceof LavaSlimeModel) {
                        headBits = (ModelPart[])ReflectionUtils.getPrivateFieldValueByType(model, LavaSlimeModel.class, ModelPart[].class);
                    } else if (model instanceof OcelotModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, OcelotModel.class, ModelPart.class, 6)};
                    } else if (model instanceof PhantomModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, PhantomModel.class, ModelPart.class)};
                    } else if (model instanceof PigModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelPart.class)};
                    } else if (model instanceof PolarBearModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelPart.class)};
                    } else if (model instanceof RabbitModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelPart.class, 7), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelPart.class, 8), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelPart.class, 9), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelPart.class, 10)};
                    } else if (model instanceof RavagerModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, RavagerModel.class, ModelPart.class, 7)};
                    } else if (model instanceof ShulkerModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, ShulkerModel.class, ModelPart.class, 2)};
                    } else if (model instanceof SilverfishModel) {
                        headBits = new ModelPart[]{(ModelPart)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelPart[].class))[0], (ModelPart)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelPart[].class))[1]};
                    } else if (model instanceof SlimeModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelPart.class, 0), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelPart.class, 1), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelPart.class, 2), (ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelPart.class, 3)};
                    } else if (model instanceof SnowGolemModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, SnowGolemModel.class, ModelPart.class, 2)};
                    } else if (model instanceof SpiderModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, SpiderModel.class, ModelPart.class)};
                    } else if (model instanceof SquidModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, SquidModel.class, ModelPart.class)};
                    } else if (model instanceof StriderModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, StriderModel.class, ModelPart.class, 2)};
                    } else if (model instanceof VillagerModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, VillagerModel.class, ModelPart.class)};
                    } else if (model instanceof WolfModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, WolfModel.class, ModelPart.class)};
                    } else if (model instanceof QuadrupedModel) {
                        headBits = new ModelPart[]{(ModelPart)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelPart.class)};
                    } else {
                        headPartsArrayList = new ArrayList<ModelPart>();
                        purge = new ArrayList<E>();
                        var37 = submodelArrays.iterator();
                        while (true) {
                            if (!var37.hasNext()) {
                                for (Field submodel : submodels) {
                                    name = submodel.getName().toLowerCase();
                                    nameS = submodel.getName();
                                    if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (name.contains("rear") == false && name.contains("ear") != false) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | nameS.equals("REar") | nameS.equals("Trout")) || !(nameS.equals("LeftSmallEar") == false & nameS.equals("RightSmallEar") == false & nameS.equals("BHead") == false & nameS.equals("BSnout") == false & nameS.equals("BMouth") == false & nameS.equals("BMouthOpen") == false & nameS.equals("BLEar") == false & nameS.equals("BREar") == false & nameS.equals("CHead") == false & nameS.equals("CSnout") == false & nameS.equals("CMouth") == false & nameS.equals("CMouthOpen") == false & nameS.equals("CLEar") == false & nameS.equals("CREar") == false) || submodel.get(model) == null) continue;
                                    headPartsArrayList.add((ModelPart)submodel.get(model));
                                }
                                if (headPartsArrayList.size() == 0) {
                                    if (submodels.size() > 0) {
                                        if (submodels.get(0).get(model) != null) {
                                            headPartsArrayList.add((ModelPart)submodels.get(0).get(model));
                                        }
                                    } else if (submodelArrays.size() > 0 && submodelArrays.get(0).get(model) != null && (submodelArrayValue = (ModelPart[])submodelArrays.get(0).get(model)).length > 0) {
                                        headPartsArrayList.add(submodelArrayValue[0]);
                                    }
                                }
                                for (ModelPart bit : headPartsArrayList) {
                                    try {
                                        childrenObj = ReflectionUtils.getPrivateFieldValueByType(bit, ModelPart.class, ObjectList.class, 1);
                                        if (childrenObj == null) continue;
                                        children = (List)childrenObj;
                                        purge.addAll(children);
                                    }
                                    catch (Exception var23_34) {}
                                }
                                headPartsArrayList.removeAll(purge);
                                headBits = headPartsArrayList.toArray(new ModelPart[headPartsArrayList.size()]);
                                break;
                            }
                            submodel = var37.next();
                            name = submodel.getName().toLowerCase();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (name.contains("rear") == false && name.contains("ear") != false) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler")) || (submodelArrayValue = (ModelPart[])submodel.get(model)) == null || submodelArrayValue.length < 0) continue;
                            headPartsArrayList.add(submodelArrayValue[0]);
                        }
                    }
                }
                if (en != null && model != null && (headBits != null && headBits.length > 0 || headPartsWithResourceLocationList.size() > 0) && resourceLocations != null) {
                    subModelNames = properties.getProperty("scale", "1");
                    scale = Float.parseFloat(subModelNames);
                    facing = Direction.NORTH;
                    facingString = properties.getProperty("facing", "front");
                    if (facingString.equals("top")) {
                        facing = Direction.UP;
                    } else if (facingString.equals("side")) {
                        facing = Direction.EAST;
                    }
                    if (headBits != null) {
                        for (t = 0; t < headBits.length; ++t) {
                            headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(headBits[t], resourceLocations));
                        }
                    }
                    headImage = (success = IconCreator.drawModel(scale, 1000, (LivingEntity)en, facing, model, headBitsWithLocations = headPartsWithResourceLocationList.toArray(new ModelPartWithResourceLocation[headPartsWithResourceLocationList.size()]))) ? ImageUtils.createBufferedImageFromGLID(GLTools.textureID) : IconCreator.createAutoIconViaEntityRenderer(en);
                } else if (model != null) {
                    headImage = IconCreator.createAutoIconViaEntityRenderer(en);
                }
            }
            catch (Exception var28) {
                headImage = null;
                var28.printStackTrace();
            }
        } else {
            headImage = IconCreator.createAutoIconViaEntityRenderer(en);
        }
        return headImage;
    }

    private static boolean drawEntity(LivingEntity livingEntity) {
        Minecraft mc = Minecraft.m_91087_();
        boolean failed = false;
        float scale = livingEntity.m_20206_() > 2.5f ? 2.5f / livingEntity.m_20206_() : 1.0f;
        Object[] preDraw = IconCreator.preDraw(scale, 1000);
        PoseStack matrixStack = (PoseStack)preDraw[0];
        Vector4f fullbright2 = new Vector4f(new Vector3f(1.0f, 1.0f, 1.0f));
        fullbright2.m_123607_(matrixStack.m_85850_().m_85861_());
        Vector3f fullbright3 = new Vector3f(fullbright2);
        RenderSystem.m_157450_((Vector3f)fullbright3, (Vector3f)fullbright3);
        try {
            float h = (float)Math.atan(0.0);
            float l = (float)Math.atan(0.0);
            Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
            Quaternion quaternion2 = Vector3f.f_122223_.m_122240_(l * 20.0f);
            quaternion.m_80148_(quaternion2);
            matrixStack.m_85845_(quaternion);
            RenderSystem.m_157182_();
            float m = livingEntity.f_20883_;
            float n = livingEntity.m_146908_();
            float o = livingEntity.m_146909_();
            float p = livingEntity.f_20886_;
            float q = livingEntity.f_20885_;
            livingEntity.f_20883_ = 180.0f + h * 20.0f;
            livingEntity.m_146922_(180.0f + h * 40.0f);
            livingEntity.m_146926_(-l * 20.0f);
            livingEntity.f_20885_ = livingEntity.m_146908_();
            livingEntity.f_20886_ = livingEntity.m_146908_();
            EntityRenderDispatcher entityRenderDispatcher = mc.m_91290_();
            quaternion2.m_80157_();
            entityRenderDispatcher.m_114412_(quaternion2);
            entityRenderDispatcher.m_114468_(false);
            PoseStack newMatrix = new PoseStack();
            MultiBufferSource.BufferSource immediate = mc.m_91269_().m_110104_();
            entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, newMatrix, (MultiBufferSource)immediate, 0xF000F0);
            immediate.m_109911_();
            entityRenderDispatcher.m_114468_(true);
            livingEntity.f_20883_ = m;
            livingEntity.m_146922_(n);
            livingEntity.m_146926_(o);
            livingEntity.f_20886_ = p;
            livingEntity.f_20885_ = q;
        }
        catch (Exception var19) {
            System.out.println("Error attempting to render entity:" + livingEntity.getClass().getSimpleName());
            var19.printStackTrace();
            failed = true;
        }
        IconCreator.postDraw(matrixStack, (Matrix4f)preDraw[1]);
        return !failed;
    }

    private static void postDraw(PoseStack matrixStack, Matrix4f minimapProjectionMatrix) {
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
        GLRefs.enableCull();
        GLRefs.disableDepth();
        GLRefs.depthMask(false);
        GLTools.unbindFrameBuffer();
        RenderSystem.m_157425_((Matrix4f)minimapProjectionMatrix);
        GLRefs.setViewport(0, 0, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
    }

    private static Object[] preDraw(float scale, int depth) {
        float size = 64.0f * scale;
        GLTools.setupFrameBuffer();
        GLRefs.bindTexture(GLTools.textureID);
        int width = GLRefs.getTextureWidth();
        int height = GLRefs.getTextureHeight();
        GLRefs.bindTexture(0);
        GLRefs.setViewport(0, 0, width, height);
        Matrix4f minimapProjectionMatrix = RenderSystem.m_157192_();
        Matrix4f matrix4f = Matrix4f.m_162203_((float)0.0f, (float)width, (float)0.0f, (float)height, (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack PoseStack2 = RenderSystem.m_157191_();
        PoseStack2.m_85836_();
        PoseStack2.m_166856_();
        PoseStack2.m_85837_(0.0, 0.0, -3000.0 + (double)depth);
        RenderSystem.m_157182_();
        GLTools.bindFrameBuffer();
        GLRefs.depthMask(true);
        GLRefs.enableDepth();
        GLRefs.enableTexture();
        GLRefs.enableBlend();
        GLRefs.disableCull();
        GLRefs.clearColor(1.0f, 1.0f, 1.0f, 0.0f);
        GLRefs.clearDepth(1.0);
        GLRefs.clear(16640);
        GLRefs.blendFunc(770, 771);
        PoseStack2.m_85836_();
        PoseStack2.m_85837_((double)(width / 2), (double)(height / 2), 0.0);
        PoseStack2.m_85841_(size, size, size);
        PoseStack2.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        PoseStack2.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        return new Object[]{PoseStack2, minimapProjectionMatrix};
    }

    private static boolean drawModel(float scale, int captureDepth, LivingEntity livingEntity, Direction facing, EntityModel model, ModelPartWithResourceLocation[] headBits) {
        boolean failed = false;
        Object[] preDraw = IconCreator.preDraw(scale, captureDepth);
        PoseStack matrixStack = (PoseStack)preDraw[0];
        if (facing == Direction.EAST) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        } else if (facing == Direction.UP) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        }
        RenderSystem.m_157182_();
        Vector4f fullbright2 = new Vector4f(new Vector3f(1.0f, 1.0f, 1.0f));
        fullbright2.m_123607_(matrixStack.m_85850_().m_85861_());
        Vector3f fullbright3 = new Vector3f(fullbright2);
        RenderSystem.m_157450_((Vector3f)fullbright3, (Vector3f)fullbright3);
        try {
            int t;
            PoseStack newMatrixStack = new PoseStack();
            MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
            float offsetByY = model instanceof EndermanModel ? 8.0f : (!(model instanceof HumanoidModel) ? 0.0f : 4.0f);
            float maxY = 0.0f;
            float minY = 0.0f;
            for (t = 0; t < headBits.length; ++t) {
                if (headBits[t].modelPart.f_104204_ < minY) {
                    minY = headBits[t].modelPart.f_104204_;
                }
                if (!(headBits[t].modelPart.f_104204_ > maxY)) continue;
                maxY = headBits[t].modelPart.f_104204_;
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            for (t = 0; t < headBits.length; ++t) {
                VertexConsumer vertexConsumer = immediate.m_6299_(model.m_103119_(headBits[t].resourceLocation));
                if (model instanceof EntityModel) {
                    EntityModel entityModel = model;
                    entityModel.m_6973_((Entity)livingEntity, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f);
                }
                float y = headBits[t].modelPart.f_104201_;
                headBits[t].modelPart.f_104201_ += offsetByY;
                headBits[t].modelPart.m_104301_(newMatrixStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_);
                headBits[t].modelPart.f_104201_ = y;
                immediate.m_109911_();
            }
        }
        catch (Exception var25) {
            System.out.println("Error attempting to render head bits for " + livingEntity.getClass().getSimpleName());
            var25.printStackTrace();
            failed = true;
        }
        IconCreator.postDraw(matrixStack, (Matrix4f)preDraw[1]);
        return !failed;
    }

    private static class ModelPartWithResourceLocation {
        ModelPart modelPart;
        ResourceLocation resourceLocation;

        public ModelPartWithResourceLocation(ModelPart modelPart, ResourceLocation resourceLocation) {
            this.modelPart = modelPart;
            this.resourceLocation = resourceLocation;
        }
    }
}

