/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import dlovin.advancedcompass.utils.GLRefs;
import dlovin.advancedcompass.utils.GLTools;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.Minecraft;

public class ImageUtils {
    private static int getMinY(BufferedImage src) {
        int yLast = -1;
        int y = 0;
        while (y < src.getHeight()) {
            boolean empty = true;
            for (int x = 0; x < src.getWidth(); ++x) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            yLast = y++;
        }
        return yLast;
    }

    private static int getMaxY(BufferedImage src) {
        int yLast = src.getHeight();
        int y = src.getHeight() - 1;
        while (y >= 0) {
            boolean empty = true;
            for (int x = 0; x < src.getWidth(); ++x) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            yLast = y--;
        }
        return yLast;
    }

    private static int getMinX(BufferedImage src) {
        int xLast = -1;
        int x = 0;
        while (x < src.getWidth()) {
            boolean empty = true;
            for (int y = 0; y < src.getHeight(); ++y) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            xLast = x++;
        }
        return xLast;
    }

    private static int getMaxX(BufferedImage src) {
        int xLast = src.getWidth();
        int x = src.getWidth() - 1;
        while (x >= 0) {
            boolean empty = true;
            for (int y = 0; y < src.getHeight(); ++y) {
                if (src.getRGB(x, y) >> 24 == 0) continue;
                empty = false;
                break;
            }
            if (!empty) break;
            xLast = x--;
        }
        return xLast;
    }

    public static BufferedImage cropImage(BufferedImage src) throws RasterFormatException {
        int yMin = ImageUtils.getMinY(src);
        int yMax = ImageUtils.getMaxY(src);
        int xMin = ImageUtils.getMinX(src);
        int xMax = ImageUtils.getMaxX(src);
        BufferedImage dest = src.getSubimage(xMin + 1, yMin + 1, xMax - xMin - 1, yMax - yMin - 1);
        return dest;
    }

    public static BufferedImage outlineImage(BufferedImage src) {
        int y;
        int x;
        BufferedImage cropped = ImageUtils.cropImage(src);
        BufferedImage resized = new BufferedImage(cropped.getWidth() + 4, cropped.getHeight() + 4, 2);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage((Image)cropped, 2, 2, null);
        g2d.dispose();
        BufferedImage oimg = new BufferedImage(resized.getWidth(), resized.getHeight(), 2);
        for (x = 1; x < resized.getWidth() - 1; ++x) {
            for (y = 1; y < resized.getHeight() - 1; ++y) {
                if (resized.getRGB(x, y) != 0 || resized.getRGB(x - 1, y) == 0 && resized.getRGB(x + 1, y) == 0 && resized.getRGB(x, y - 1) == 0 && resized.getRGB(x, y + 1) == 0) continue;
                oimg.setRGB(x, y, -16777216);
            }
        }
        for (x = 1; x < resized.getWidth() - 1; ++x) {
            for (y = 1; y < resized.getHeight() - 1; ++y) {
                if (oimg.getRGB(x, y) != 0) continue;
                if (oimg.getRGB(x - 1, y) == -16777216 && oimg.getRGB(x, y - 1) == -16777216 && oimg.getRGB(x - 1, y - 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x - 1, y) == -16777216 && oimg.getRGB(x, y + 1) == -16777216 && oimg.getRGB(x - 1, y + 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x + 1, y) == -16777216 && oimg.getRGB(x, y - 1) == -16777216 && oimg.getRGB(x + 1, y - 1) != -16777216) {
                    oimg.setRGB(x, y, Integer.MIN_VALUE);
                    continue;
                }
                if (oimg.getRGB(x + 1, y) != -16777216 || oimg.getRGB(x, y + 1) != -16777216 || oimg.getRGB(x + 1, y + 1) == -16777216) continue;
                oimg.setRGB(x, y, Integer.MIN_VALUE);
            }
        }
        g2d = oimg.createGraphics();
        g2d.drawImage((Image)oimg, 0, 0, null);
        g2d.drawImage((Image)resized, 0, 0, null);
        g2d.dispose();
        return oimg;
    }

    public static BufferedImage rescale(BufferedImage src, int hints) {
        int scaledHeight = 0;
        int scaledWidth = 0;
        float scale = 0.0f;
        if ((float)src.getWidth() / (float)src.getHeight() > 1.4f) {
            scale = 16.0f / (float)src.getWidth();
            scaledWidth = 16;
            scaledHeight = (int)((float)src.getHeight() * scale);
        } else if ((float)src.getHeight() / (float)src.getWidth() > 1.4f) {
            scale = 16.0f / (float)src.getHeight();
            scaledHeight = 16;
            scaledWidth = (int)((float)src.getWidth() * scale);
        } else if (src.getHeight() < src.getWidth()) {
            scale = 12.0f / (float)src.getHeight();
            scaledHeight = 12;
            scaledWidth = (int)((float)src.getWidth() * scale);
        } else {
            scale = 12.0f / (float)src.getWidth();
            scaledWidth = 12;
            scaledHeight = (int)((float)src.getHeight() * scale);
        }
        Image tmp = src.getScaledInstance(scaledWidth, scaledHeight, hints);
        BufferedImage dimg = new BufferedImage(scaledWidth, scaledHeight, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public static BufferedImage createBufferedImageFromGLID(int id) {
        GLRefs.bindTexture(id);
        return ImageUtils.createBufferedImageFromCurrentGLImage();
    }

    public static BufferedImage createBufferedImageFromCurrentGLImage() {
        BufferedImage image;
        int imageHeight;
        int imageWidth = GLRefs.getTextureWidth();
        long size = (long)imageWidth * (long)(imageHeight = GLRefs.getTextureHeight()) * 4L;
        if (size < Integer.MAX_VALUE) {
            image = new BufferedImage(imageWidth, imageHeight, 6);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(imageWidth * imageHeight * 4).order(ByteOrder.nativeOrder());
            GLRefs.getTexImage(3553, 0, 6408, 5121, byteBuffer);
            byteBuffer.position(0);
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            for (int x = 0; x < imageWidth; ++x) {
                for (int y = 0; y < imageHeight; ++y) {
                    int index = y * imageWidth * 4 + x * 4;
                    int var8 = 0;
                    int color24 = var8 | (bytes[index + 2] & 0xFF) << 0;
                    color24 |= (bytes[index + 1] & 0xFF) << 8;
                    color24 |= (bytes[index + 0] & 0xFF) << 16;
                    image.setRGB(x, y, color24 |= (bytes[index + 3] & 0xFF) << 24);
                }
            }
        } else {
            while (true) {
                if (size <= Integer.MAX_VALUE) {
                    int glid = GLRefs.getBindedTexture();
                    image = new BufferedImage(imageWidth, imageHeight, 6);
                    int fboWidth = 512;
                    int fboHeight = 512;
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fboWidth * fboHeight * 4).order(ByteOrder.nativeOrder());
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    GLRefs.pushAttribute(4096);
                    RenderSystem.m_157183_();
                    GLRefs.setViewport(0, 0, fboWidth, fboHeight);
                    Matrix4f matrix4f = Matrix4f.m_27636_((float)fboWidth, (float)(-fboHeight), (float)1000.0f, (float)3000.0f);
                    RenderSystem.m_157425_((Matrix4f)matrix4f);
                    PoseStack matrixStack = RenderSystem.m_157191_();
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(0.0, 0.0, -2000.0);
                    GLTools.bindFrameBuffer();
                    int startX = 0;
                    while (startX + fboWidth < imageWidth) {
                        int startY = 0;
                        while (startY + fboWidth < imageHeight) {
                            GLRefs.bindTexture(glid);
                            GLRefs.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
                            GLRefs.clear(16640);
                            GLTools.drawPre();
                            GLTools.verTex(0.0, fboHeight, 1.0, (float)startX / (float)imageWidth, (float)startY / (float)imageHeight);
                            GLTools.verTex(fboWidth, fboHeight, 1.0, ((float)startX + (float)fboWidth) / (float)imageWidth, (float)startY / (float)imageHeight);
                            GLTools.verTex(fboWidth, 0.0, 1.0, ((float)startX + (float)fboWidth) / (float)imageWidth, ((float)startY + (float)fboHeight) / (float)imageHeight);
                            GLTools.verTex(0.0, 0.0, 1.0, (float)startX / (float)imageWidth, ((float)startY + (float)fboHeight) / (float)imageHeight);
                            GLTools.drawPost();
                            GLRefs.bindTexture(GLTools.textureID);
                            byteBuffer.position(0);
                            GLRefs.getTexImage(3553, 0, 6408, 5121, byteBuffer);
                            byteBuffer.position(0);
                            byteBuffer.get(bytes);
                            for (int x = 0; x < fboWidth && startX + x < imageWidth; ++x) {
                                for (int y = 0; y < fboHeight && startY + y < imageHeight; ++y) {
                                    int index = y * fboWidth * 4 + x * 4;
                                    int var8 = 0;
                                    int color24 = var8 | (bytes[index + 2] & 0xFF) << 0;
                                    color24 |= (bytes[index + 1] & 0xFF) << 8;
                                    color24 |= (bytes[index + 0] & 0xFF) << 16;
                                    image.setRGB(startX + x, startY + y, color24 |= (bytes[index + 3] & 0xFF) << 24);
                                }
                            }
                            startY += fboHeight;
                        }
                        startX += fboWidth;
                    }
                    GLTools.unbindFrameBuffer();
                    RenderSystem.m_157424_();
                    GLRefs.popAttribute();
                    GLRefs.setViewport(0, 0, Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_());
                    break;
                }
                size = (long)(imageWidth /= 2) * (long)(imageHeight /= 2) * 4L;
            }
        }
        return image;
    }
}

