/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dlovin.advancedcompass.AdvancedCompass;
import dlovin.advancedcompass.utils.FileUtils;
import dlovin.advancedcompass.utils.GroupUtils;
import dlovin.advancedcompass.utils.HeadUtils;
import dlovin.advancedcompass.utils.TextureCoords;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonUtils {
    private static final String path = FMLPaths.CONFIGDIR.get() + "/AdvancedCompass/";

    public static void initVanilla() {
        File file = new File(path + "mobs/mobs.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            FileUtils.saveFile("mobs/mobs.json", JsonUtils.getDefault());
        }
        JsonParser jsonParser = new JsonParser();
        try (FileReader reader = new FileReader(file);){
            JsonElement obj = jsonParser.parse((Reader)reader);
            JsonObject list = JsonUtils.checkTypes(obj.getAsJsonObject());
            JsonUtils.setTypes(list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addMob(String fileName, String id, int width, int height) {
        File file = new File(path + "mobs/" + fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        JsonParser jsonParser = new JsonParser();
        if (!file.exists()) {
            FileUtils.createEmpty(file);
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject obj;
            JsonElement element = jsonParser.parse((Reader)reader);
            if (!element.isJsonObject()) {
                obj = new JsonObject();
                object = new JsonObject();
                object.addProperty("width", (Number)width);
                object.addProperty("height", (Number)height);
                object.addProperty("show", Boolean.valueOf(true));
                obj.add(id, (JsonElement)object);
            } else {
                obj = element.getAsJsonObject();
                if (obj.get(id) == null) {
                    object = new JsonObject();
                    object.addProperty("width", (Number)width);
                    object.addProperty("height", (Number)height);
                    object.addProperty("show", Boolean.valueOf(true));
                    obj.add(id, (JsonElement)object);
                } else {
                    object = obj.get(id).getAsJsonObject();
                    object.addProperty("width", (Number)width);
                    object.addProperty("height", (Number)height);
                }
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(obj.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject getModJson(String mod) {
        File file = new File(path + mod + "/mobs.json");
        if (!file.exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(file);){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)reader);
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                return jsonObject;
            }
            JsonObject jsonObject = null;
            return jsonObject;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveMobs() {
        HashMap<String, JsonObject> objects = new HashMap<String, JsonObject>();
        JsonObject obj = new JsonObject();
        for (Map.Entry<EntityType, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            if (entry.getKey().getRegistryName().m_135827_().equals("minecraft")) {
                obj.addProperty(entry.getKey().m_20675_(), Boolean.valueOf(GroupUtils.types.contains(entry.getKey())));
                continue;
            }
            JsonObject tmp = JsonUtils.getModJson(entry.getKey().getRegistryName().m_135827_());
            if (tmp == null) continue;
            if (!objects.containsKey(entry.getKey().getRegistryName().m_135827_())) {
                objects.put(entry.getKey().getRegistryName().m_135827_(), tmp);
            }
            ((JsonObject)objects.get(entry.getKey().getRegistryName().m_135827_())).get(entry.getKey().getRegistryName().m_135815_()).getAsJsonObject().addProperty("show", Boolean.valueOf(GroupUtils.types.contains(entry.getKey())));
        }
        FileUtils.saveFile("mobs/mobs.json", obj.toString());
        for (Map.Entry<Object, TextureCoords> entry : objects.entrySet()) {
            FileUtils.saveFile("mobs/" + (String)entry.getKey() + "/mobs.json", ((JsonObject)entry.getValue()).toString());
        }
    }

    private static String getDefault() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<EntityType, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            obj.addProperty(entry.getKey().m_20675_(), Boolean.valueOf(true));
        }
        return obj.toString();
    }

    private static void setTypes(JsonObject obj) {
        GroupUtils.types = new ArrayList<EntityType>();
        for (Map.Entry el : obj.entrySet()) {
            if (!((JsonElement)el.getValue()).getAsBoolean()) continue;
            GroupUtils.types.add(HeadUtils.getType((String)el.getKey()));
        }
    }

    private static JsonObject checkTypes(JsonObject obj) {
        boolean save = false;
        StringBuilder missed = new StringBuilder("Missed entities:");
        for (Map.Entry<EntityType, TextureCoords> entry : HeadUtils.heads.entrySet()) {
            if (obj.get(entry.getKey().m_20675_()) != null) continue;
            obj.addProperty(entry.getKey().m_20675_(), Boolean.valueOf(true));
            missed.append("\n").append(entry.getKey().m_20675_());
            save = true;
        }
        if (save) {
            FileUtils.saveFile("mobs/mobs.json", obj.toString());
            AdvancedCompass.logger.info(String.format(Locale.ROOT, "%s%s", missed.toString(), "\nAll added as 'true'"));
        }
        return obj;
    }
}

