/*
 * Decompiled with CFR 0.152.
 */
package dlovin.advancedcompass.utils.waypoints;

import dlovin.advancedcompass.utils.Color;
import dlovin.advancedcompass.utils.waypoints.WaypointIcon;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;

public class Waypoint {
    String name;
    Vec3 position;
    String dimension;
    WaypointIcon icon;
    Color color;
    int maxDistance;
    int minDistance;
    boolean enabled;

    public Waypoint(Waypoint that) {
        this(that.getName(), new Vec3(that.getPosition().m_7096_(), that.getPosition().m_7098_(), that.getPosition().m_7094_()), that.getDimension(), WaypointIcon.values()[that.getIcon().ordinal()], new Color(that.getColor().getR(), that.getColor().getG(), that.getColor().getB()), that.getMinDistance(), that.getMaxDistance(), that.isEnabled());
    }

    public Waypoint(String name, Vec3 position, String dimension, WaypointIcon icon, Color color, int minDistance, int maxDistance, boolean enabled) {
        this.name = name;
        this.position = position;
        this.dimension = dimension;
        this.icon = icon;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.enabled = enabled;
        this.color = color;
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(int minDistance) {
        this.minDistance = minDistance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public void setPosition(Vec3 pos) {
        this.position = pos;
    }

    public void setIcon(WaypointIcon icon) {
        this.icon = icon;
    }

    public void setIcon(int index) {
        this.icon = WaypointIcon.values()[index];
    }

    public WaypointIcon getIcon() {
        return this.icon;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public String getDimension() {
        return this.dimension;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double distanceTo(LocalPlayer player) {
        return Math.sqrt(player.m_20238_(this.position));
    }
}

