/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.magicalcrops;

import com.InfinityRaider.AgriCraft.api.v1.IFertiliser;
import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.compatibility.magicalcrops.CropPlantMagicalCropsBeta;
import com.InfinityRaider.AgriCraft.compatibility.magicalcrops.CropPlantMagicalCropsV4;
import com.InfinityRaider.AgriCraft.compatibility.magicalcrops.MagicalCropsFertiliser;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import cpw.mods.fml.common.Mod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public final class MagicalCropsHelper
extends ModHelper {
    private boolean newVersion;
    private IFertiliser fertiliser;

    @Override
    protected void onInit() {
        Annotation[] annotations;
        Class<?> magicalCropsClass = null;
        try {
            magicalCropsClass = Class.forName("com.mark719.magicalcrops.MagicalCrops");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        assert (magicalCropsClass != null);
        for (Annotation annotation : annotations = magicalCropsClass.getAnnotations()) {
            if (!(annotation instanceof Mod)) continue;
            String version = ((Mod)annotation).version();
            this.newVersion = !version.contains("ALPHA");
            break;
        }
    }

    @Override
    protected void initPlants() {
        if (this.newVersion) {
            this.initV4Plants();
        } else {
            this.initBetaPlants();
        }
    }

    private void initBetaPlants() {
        Field[] fields;
        Class<?> mc_ItemRegistry = null;
        Class<?> blockMagicalCrops = null;
        try {
            mc_ItemRegistry = Class.forName("com.mark719.magicalcrops.MagicalCrops");
            blockMagicalCrops = Class.forName("com.mark719.magicalcrops.crops.BlockMagicalCrops");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        assert (mc_ItemRegistry != null);
        for (Field field : fields = mc_ItemRegistry.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object obj = field.get(null);
                if (!(obj instanceof ItemSeeds)) continue;
                ItemSeeds seed = (ItemSeeds)obj;
                Block plant = seed.getPlant(null, 0, 0, 0);
                assert (blockMagicalCrops != null);
                boolean highTier = blockMagicalCrops.isInstance(plant);
                CropPlantHandler.registerPlant(new CropPlantMagicalCropsBeta(seed, highTier));
            }
            catch (Exception e) {
                if (!ConfigurationHandler.debug) continue;
                e.printStackTrace();
            }
        }
    }

    private void initV4Plants() {
        Method getDropMethod;
        ArrayList classes;
        block8: {
            classes = new ArrayList();
            getDropMethod = null;
            try {
                Method[] methods;
                classes.add(Class.forName("com.mark719.magicalcrops.handlers.MSeeds"));
                classes.add(Class.forName("com.mark719.magicalcrops.handlers.ModCompat"));
                for (Method method : methods = Class.forName("com.mark719.magicalcrops.blocks.BlockMagicalCrops").getDeclaredMethods()) {
                    if (!method.getName().equalsIgnoreCase("func_149865_P")) continue;
                    getDropMethod = method;
                    getDropMethod.setAccessible(true);
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                if (!ConfigurationHandler.debug) break block8;
                e.printStackTrace();
            }
        }
        for (Class clazz : classes) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    Object obj = field.get(null);
                    if (!(obj instanceof ItemSeeds)) continue;
                    ItemSeeds seed = (ItemSeeds)obj;
                    Block plant = seed.getPlant(null, 0, 0, 0);
                    assert (getDropMethod != null);
                    CropPlantHandler.registerPlant(new CropPlantMagicalCropsV4(seed, (Item)getDropMethod.invoke((Object)plant, new Object[0])));
                }
                catch (Exception e) {
                    if (!ConfigurationHandler.debug || !ConfigurationHandler.debug) continue;
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected boolean useTool(World world, int x, int y, int z, EntityPlayer player, ItemStack stack, BlockCrop block, TileEntityCrop crop) {
        if (this.fertiliser != null) {
            crop.applyFertiliser(this.fertiliser, world.field_73012_v);
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    protected List<Item> getTools() {
        this.fertiliser = new MagicalCropsFertiliser();
        ArrayList<Item> list = new ArrayList<Item>();
        if (this.newVersion) {
            list.add((Item)Item.field_150901_e.func_82594_a("magicalcrops:magicalcrops_MagicalFertilizer"));
        } else {
            list.add((Item)Item.field_150901_e.func_82594_a("magicalcrops:magicalcrops_MagicalCropFertilizer"));
        }
        return list;
    }

    @Override
    protected String modId() {
        return "magicalcrops";
    }
}

