/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.resourcefulcrops;

import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.compatibility.resourcefulcrops.ResourcefulCropsAPIwrapper;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.reference.Constants;
import com.InfinityRaider.AgriCraft.renderers.PlantRenderer;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropPlantResourcefulCrops
extends CropPlant {
    private static ResourcefulCropsAPIwrapper api;
    private final int meta;
    private final ArrayList<ItemStack> fruits;
    private final IGrowthRequirement growthRequirement;
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] overlayIcons;
    private static boolean grabIcons;

    protected CropPlantResourcefulCrops(int meta, IGrowthRequirement requirement) {
        if (api == null) {
            api = ResourcefulCropsAPIwrapper.getInstance();
        }
        this.meta = meta;
        this.fruits = api.getAllFruits(meta);
        this.setTier(api.getTier(meta));
        this.growthRequirement = requirement;
        if (grabIcons) {
            try {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    this.setOverlayIcons();
                }
            }
            catch (Exception e) {
                LogHelper.debug("Failed to grab overlay icons");
                LogHelper.printStackTrace(e);
            }
            grabIcons = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setOverlayIcons() throws Exception {
        Class<?> blockClass = Class.forName("tehnut.resourceful.crops.block.BlockRCrop");
        Field overlayIconsField = blockClass.getDeclaredField("cropOverlay");
        Object overlayIconsObject = overlayIconsField.get(this.getBlock());
        if (overlayIconsObject instanceof IIcon[]) {
            overlayIcons = (IIcon[])overlayIconsObject;
        }
    }

    @Override
    public int tier() {
        int tier;
        if (api == null) {
            api = ResourcefulCropsAPIwrapper.getInstance();
        }
        tier = (tier = api.getTier(this.meta)) <= 0 ? 1 : (tier >= Constants.GROWTH_TIER.length ? Constants.GROWTH_TIER.length - 1 : tier);
        return tier;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack(api.getSeed(), 1, this.meta);
    }

    @Override
    public Block getBlock() {
        return api.getPlantBlock();
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        return new ArrayList<ItemStack>(this.fruits);
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        if (this.fruits.size() == 0) {
            return null;
        }
        return this.fruits.get(rand.nextInt(this.fruits.size())).func_77946_l();
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.fruits.size() > 0) {
            for (int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0); amount > 0; --amount) {
                list.add(this.getRandomFruit(rand));
            }
        }
        return list;
    }

    @Override
    public boolean canBonemeal() {
        return this.getTier() < 4;
    }

    @Override
    protected IGrowthRequirement initGrowthRequirement() {
        return this.growthRequirement;
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage, ICrop crop) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        growthStage = growthStage > 7 ? 7 : (growthStage < 0 ? 0 : growthStage);
        return this.getBlock().func_149691_a(0, growthStage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsFlower() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInformation() {
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPlantInCrop(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int growthStage = world.func_72805_g(x, y, z);
        PlantRenderer.renderPlantLayer(world, x, y, z, this.renderAsFlower() ? 1 : 6, this.getPlantIcon(growthStage), 0);
        if (overlayIcons != null) {
            Color color = api.getColor(this.meta);
            tessellator.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            PlantRenderer.renderPlantLayer(world, x, y, z, this.renderAsFlower() ? 1 : 6, overlayIcons[growthStage], 0, false);
        }
    }

    static {
        grabIcons = true;
    }
}

