/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming;

import com.InfinityRaider.AgriCraft.api.v1.IAgriCraftPlant;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.ItemWithMeta;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantAgriCraft;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantNetherWart;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantOreDict;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantStem;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantVanilla;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import com.InfinityRaider.AgriCraft.utility.exception.DuplicateCropPlantException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class CropPlantHandler {
    private static HashMap<Item, HashMap<Integer, CropPlant>> cropPlants = new HashMap();
    private static ArrayList<CropPlant> plantsToRegister = new ArrayList();
    private static ArrayList<ItemStack> blacklist = new ArrayList();

    public static void registerPlant(IAgriCraftPlant plant) throws DuplicateCropPlantException {
        CropPlantHandler.registerPlant(new CropPlantAgriCraft(plant));
    }

    public static void registerPlant(CropPlant plant) throws DuplicateCropPlantException {
        ItemStack stack = plant.getSeed();
        LogHelper.debug("Registering plant for " + stack.func_77977_a());
        Item seed = stack.func_77973_b();
        int meta = stack.func_77960_j();
        HashMap<Integer, CropPlant> entryForSeed = cropPlants.get(seed);
        if (entryForSeed != null) {
            if (entryForSeed.get(meta) != null) {
                throw new DuplicateCropPlantException();
            }
            entryForSeed.put(meta, plant);
        } else {
            entryForSeed = new HashMap();
            entryForSeed.put(meta, plant);
            cropPlants.put(seed, entryForSeed);
        }
        Iterator<ItemStack> it = blacklist.iterator();
        while (it.hasNext()) {
            ItemStack blackListed = it.next();
            if (blackListed == null || blackListed.func_77973_b() == null) {
                it.remove();
                continue;
            }
            if (blackListed.func_77973_b() != stack.func_77973_b() || blackListed.func_77960_j() != stack.func_77960_j()) continue;
            plant.setBlackListStatus(true);
            it.remove();
            break;
        }
    }

    private static void suppressedRegisterPlant(CropPlant plant) {
        try {
            CropPlantHandler.registerPlant(plant);
            GrowthRequirementHandler.addSoil(plant.getGrowthRequirement().getSoil());
        }
        catch (DuplicateCropPlantException e) {
            LogHelper.debug("Unable to register duplicate plant: " + plant.getSeed().func_77977_a());
            LogHelper.printStackTrace(e);
        }
    }

    public static void addCropToRegister(CropPlant plant) {
        if (plantsToRegister != null) {
            plantsToRegister.add(plant);
        } else {
            CropPlantHandler.suppressedRegisterPlant(plant);
        }
    }

    public static boolean setGrowthRequirement(ItemWithMeta seed, IGrowthRequirement req) {
        if (seed == null || seed.getItem() == null) {
            return false;
        }
        if (!CropPlantHandler.isValidSeed(seed)) {
            for (CropPlant plant : plantsToRegister) {
                ItemStack plantSeed = plant.getSeed();
                if (plantSeed == null || plantSeed.func_77973_b() == null || plantSeed.func_77973_b() != seed.getItem() || plantSeed.func_77960_j() != seed.getMeta()) continue;
                plant.setGrowthRequirement(req);
                return true;
            }
            return false;
        }
        cropPlants.get(seed.getItem()).get(seed.getMeta()).setGrowthRequirement(req);
        return true;
    }

    public static boolean isAnalyzedSeed(ItemStack seedStack) {
        return CropPlantHandler.isValidSeed(seedStack) && seedStack.func_77942_o() && seedStack.field_77990_d.func_74764_b("analyzed") && seedStack.field_77990_d.func_74767_n("analyzed");
    }

    public static boolean isValidSeed(ItemStack seed) {
        return seed != null && seed.func_77973_b() != null && CropPlantHandler.isValidSeed(seed.func_77973_b(), seed.func_77960_j());
    }

    public static boolean isValidSeed(ItemWithMeta seed) {
        return seed != null && CropPlantHandler.isValidSeed(seed.getItem(), seed.getMeta());
    }

    public static boolean isValidSeed(Item seed, int meta) {
        return CropPlantHandler.isRecognizedByAgriCraft(seed, meta) && !cropPlants.get(seed).get(meta).isBlackListed();
    }

    private static boolean isRecognizedByAgriCraft(Item seed, int meta) {
        return seed != null && cropPlants.containsKey(seed) && cropPlants.get(seed).containsKey(meta);
    }

    public static NBTTagCompound writePlantToNBT(CropPlant plant) {
        return plant.getSeed().func_77955_b(new NBTTagCompound());
    }

    public static CropPlant readPlantFromNBT(NBTTagCompound tag) {
        return CropPlantHandler.getPlantFromStack(ItemStack.func_77949_a((NBTTagCompound)tag));
    }

    public static CropPlant getPlantFromStack(ItemStack stack) {
        if (CropPlantHandler.isValidSeed(stack)) {
            return cropPlants.get(stack.func_77973_b()).get(stack.func_77960_j());
        }
        return null;
    }

    public static IGrowthRequirement getGrowthRequirement(Item seed, int meta) {
        CropPlant plant = cropPlants.get(seed).get(meta);
        return plant == null ? GrowthRequirementHandler.NULL : plant.getGrowthRequirement();
    }

    public static IGrowthRequirement getGrowthRequirement(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return GrowthRequirementHandler.NULL;
        }
        return CropPlantHandler.getGrowthRequirement(stack.func_77973_b(), stack.func_77960_j());
    }

    public static ArrayList<CropPlant> getPlants() {
        ArrayList<CropPlant> plants = new ArrayList<CropPlant>();
        for (HashMap<Integer, CropPlant> subMap : cropPlants.values()) {
            for (CropPlant plant : subMap.values()) {
                if (plant.isBlackListed()) continue;
                plants.add(plant);
            }
        }
        return plants;
    }

    public static ArrayList<CropPlant> getPlantsUpToTier(int tier) {
        ArrayList<CropPlant> plants = new ArrayList<CropPlant>();
        for (HashMap<Integer, CropPlant> subMap : cropPlants.values()) {
            for (CropPlant plant : subMap.values()) {
                if (plant.getTier() > tier || plant.isBlackListed()) continue;
                plants.add(plant);
            }
        }
        return plants;
    }

    public static ItemStack getRandomSeed(Random rand, boolean setTag) {
        return CropPlantHandler.getRandomSeed(rand, setTag, 5);
    }

    public static ItemStack getRandomSeed(Random rand, boolean setTag, int maxTier) {
        return CropPlantHandler.getRandomSeed(rand, setTag, CropPlantHandler.getPlantsUpToTier(maxTier));
    }

    public static ItemStack getRandomSeed(Random rand, boolean setTag, List<CropPlant> plants) {
        boolean flag = false;
        ItemStack seed = null;
        while (!flag) {
            CropPlant plant = plants.get(rand.nextInt(plants.size()));
            seed = plant.getSeed().func_77946_l();
            flag = seed.func_77973_b() != null;
        }
        if (setTag) {
            NBTTagCompound tag = new NBTTagCompound();
            CropPlantHandler.setSeedNBT(tag, (short)(rand.nextInt(ConfigurationHandler.cropStatCap) / 2 + 1), (short)(rand.nextInt(ConfigurationHandler.cropStatCap) / 2 + 1), (short)(rand.nextInt(ConfigurationHandler.cropStatCap) / 2 + 1), false);
            seed.field_77990_d = tag;
        }
        return seed;
    }

    public static NBTTagCompound setSeedNBT(NBTTagCompound tag, short growth, short gain, short strength, boolean analyzed) {
        short cap = (short)ConfigurationHandler.cropStatCap;
        tag.func_74777_a("growth", growth == 0 ? (short)1 : (growth > cap ? cap : growth));
        tag.func_74777_a("gain", gain == 0 ? (short)1 : (gain > cap ? cap : gain));
        tag.func_74777_a("strength", strength == 0 ? (short)1 : (strength > cap ? cap : strength));
        tag.func_74757_a("analyzed", analyzed);
        return tag;
    }

    public static boolean isSeedBlackListed(ItemStack seed) {
        if (seed == null || seed.func_77973_b() == null) {
            return true;
        }
        if (CropPlantHandler.isRecognizedByAgriCraft(seed.func_77973_b(), seed.func_77960_j())) {
            return cropPlants.get(seed.func_77973_b()).get(seed.func_77960_j()).isBlackListed();
        }
        for (ItemStack queued : blacklist) {
            if (queued.func_77973_b() != seed.func_77973_b() && queued.func_77960_j() != seed.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static void addSeedToBlackList(ItemStack seed) {
        if (seed == null || seed.func_77973_b() == null) {
            return;
        }
        if (CropPlantHandler.isSeedBlackListed(seed)) {
            return;
        }
        if (!CropPlantHandler.isRecognizedByAgriCraft(seed.func_77973_b(), seed.func_77960_j())) {
            blacklist.add(seed.func_77946_l());
            return;
        }
        cropPlants.get(seed.func_77973_b()).get(seed.func_77960_j()).setBlackListStatus(true);
        LogHelper.debug("Added seed to blacklist: " + Item.field_150901_e.func_148750_c((Object)seed.func_77973_b()) + ":" + seed.func_77960_j());
    }

    public static void addAllToSeedBlacklist(Collection<? extends ItemStack> seeds) {
        for (ItemStack itemStack : seeds) {
            CropPlantHandler.addSeedToBlackList(itemStack);
        }
    }

    public static void removeFromSeedBlackList(ItemStack seed) {
        if (seed == null || seed.func_77973_b() == null) {
            return;
        }
        if (!CropPlantHandler.isSeedBlackListed(seed)) {
            return;
        }
        if (CropPlantHandler.isRecognizedByAgriCraft(seed.func_77973_b(), seed.func_77960_j())) {
            cropPlants.get(seed.func_77973_b()).get(seed.func_77960_j()).setBlackListStatus(false);
        } else {
            CropPlantHandler.removeFromBlackListArray(seed);
        }
        LogHelper.debug("Removed seed from blacklist: " + Item.field_150901_e.func_148750_c((Object)seed.func_77973_b()) + ":" + seed.func_77960_j());
    }

    private static void removeFromBlackListArray(ItemStack seed) {
        Iterator<ItemStack> it = blacklist.iterator();
        while (it.hasNext()) {
            ItemStack queued = it.next();
            if (seed.func_77973_b() != queued.func_77973_b() || seed.func_77960_j() != queued.func_77960_j()) continue;
            it.remove();
        }
    }

    public static void removeAllFromSeedBlacklist(Collection<? extends ItemStack> seeds) {
        for (ItemStack itemStack : seeds) {
            CropPlantHandler.removeFromSeedBlackList(itemStack);
        }
    }

    public static void init() {
        OreDictionary.registerOre((String)"seedMelon", (Item)Items.field_151081_bc);
        OreDictionary.registerOre((String)"cropMelon", (Item)Items.field_151127_ba);
        OreDictionary.registerOre((String)"seedPumpkin", (Item)Items.field_151080_bb);
        OreDictionary.registerOre((String)"cropPumpkin", (Block)Blocks.field_150423_aK);
        CropPlantHandler.suppressedRegisterPlant(new CropPlantVanilla((BlockCrops)Blocks.field_150464_aj, (ItemSeeds)Items.field_151014_N));
        CropPlantHandler.suppressedRegisterPlant(new CropPlantStem((ItemSeeds)Items.field_151081_bc, Blocks.field_150440_ba));
        CropPlantHandler.suppressedRegisterPlant(new CropPlantStem((ItemSeeds)Items.field_151080_bb, Blocks.field_150423_aK));
        CropPlantHandler.suppressedRegisterPlant(new CropPlantNetherWart());
        ModHelper.initModPlants();
        for (CropPlant plant : plantsToRegister) {
            CropPlantHandler.suppressedRegisterPlant(plant);
        }
        plantsToRegister = null;
        ArrayList seeds = OreDictionary.getOres((String)"listAllseed");
        for (ItemStack seed : seeds) {
            ArrayList<ItemStack> fruits;
            if (CropPlantHandler.isValidSeed(seed) || !(seed.func_77973_b() instanceof ItemSeeds) || (fruits = OreDictHelper.getFruitsFromOreDict(seed)) == null || fruits.size() <= 0) continue;
            CropPlantHandler.suppressedRegisterPlant(new CropPlantOreDict((ItemSeeds)seed.func_77973_b()));
        }
        IOHelper.initSeedTiers();
        IOHelper.initSeedBlackList();
        IOHelper.initSpreadChancesOverrides();
        IOHelper.initVannilaPlantingOverrides();
    }
}

