/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.cropplant;

import com.InfinityRaider.AgriCraft.api.v1.IAgriCraftPlant;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CropPlantAgriCraft
extends CropPlant {
    IAgriCraftPlant plant;

    public CropPlantAgriCraft(IAgriCraftPlant plant) {
        this.plant = plant;
        this.setTier(plant.getSeed().tier());
        this.setGrowthRequirement(plant.getGrowthRequirement());
        this.setSpreadChance(100 / this.getTier());
    }

    @Override
    public int tier() {
        return 1;
    }

    @Override
    public ItemStack getSeed() {
        return this.plant.getSeedStack(1);
    }

    @Override
    public Block getBlock() {
        return this.plant.getBlock();
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        return this.plant.getAllFruits();
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        return this.plant.getRandomFruit(rand);
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0);
        return this.plant.getFruit(amount, rand);
    }

    @Override
    public boolean canBonemeal() {
        return this.getTier() < 4;
    }

    @Override
    protected IGrowthRequirement initGrowthRequirement() {
        return null;
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage, ICrop crop) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        return this.plant.getIcon(growthStage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsFlower() {
        return this.plant.renderAsFlower();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInformation() {
        return this.plant.getSeed().getInformation();
    }
}

