/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.gui;

import com.InfinityRaider.AgriCraft.container.ContainerPeripheral;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.TileEntityPeripheral;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.IMethod;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiPeripheral
extends GuiContainer {
    public static final ResourceLocation texture = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/GuiPeripheral.png");
    public static final int WHITE = 0x404040;
    private final TileEntityPeripheral peripheral;
    private final IMethod[] methods;
    private static final int BUTTON_ID_OPEN_GUIDE = 0;
    private static final int BUTTON_ID_SCROLL_DOWN = 1;
    private static final int BUTTON_ID_SCROLL_UP = 2;
    private static final int BUTTON_ID_SCROLL_BOTTOM = 3;
    private static final int BUTTON_ID_SCROLL_TOP = 4;
    private static final int BUTTON_METHOD_OFFSET = 5;
    private static final int BUTTON_AMOUNT = 10;
    private int scrollPosition = 0;
    private boolean guideActive = false;
    private final int guideOffset;

    public GuiPeripheral(InventoryPlayer inventory, TileEntityPeripheral peripheral) {
        super((Container)new ContainerPeripheral(inventory, peripheral));
        this.field_146999_f = 172;
        this.field_147000_g = 176;
        this.peripheral = peripheral;
        this.methods = peripheral.getMethods();
        this.guideOffset = this.field_146999_f - 4;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.loadButtonList();
    }

    public void func_146979_b(int x, int y) {
        String name = StatCollector.func_74838_a((String)"agricraft_gui.peripheral");
        float scale = 0.8f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(name, (int)((float)(9 + this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2) / scale), (int)(6.0f / scale), 0x404040);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 4, this.field_147000_g - 94 + 2, 0x404040);
    }

    protected void func_146976_a(float opacity, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.peripheral.getProgress() > 0) {
            int state = this.peripheral.getProgressScaled(40);
            this.func_73729_b(this.field_147003_i + 65, this.field_147009_r + 78, 0, this.field_147000_g + 71, state, 6);
        }
        if (this.guideActive) {
            this.func_73729_b(this.field_147003_i + this.guideOffset, this.field_147009_r, 172, 0, 83, this.field_147000_g);
            this.drawScrollBar();
            this.drawMethodHelp(this.getActiveMethod());
        }
    }

    protected void drawScrollBar() {
        int total = 160;
        int slotWidth = 16;
        int fullLength = slotWidth * this.methods.length;
        float unit = (float)slotWidth / (float)fullLength * (float)total;
        int offset = (int)((float)this.scrollPosition * unit);
        int length = (int)(10.0f * unit);
        int xOffset = this.field_147003_i + 242;
        int yOffset = this.field_147009_r + 8;
        this.func_73729_b(xOffset, yOffset + offset, 0, 253, 5, 1);
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        int xMax = xOffset + 5;
        int yMin = yOffset + offset + 1;
        int yMax = yOffset + length + offset;
        float uMin = 0.0f * f;
        float uMax = 5.0f * f;
        float vMin = 254.0f * f;
        float vMax = 254.0f * f;
        tessellator.func_78374_a((double)xOffset, (double)yMax, (double)this.field_73735_i, (double)uMin, (double)vMax);
        tessellator.func_78374_a((double)xMax, (double)yMax, (double)this.field_73735_i, (double)uMax, (double)vMax);
        tessellator.func_78374_a((double)xMax, (double)yMin, (double)this.field_73735_i, (double)uMax, (double)vMin);
        tessellator.func_78374_a((double)xOffset, (double)yMin, (double)this.field_73735_i, (double)uMin, (double)vMin);
        tessellator.func_78381_a();
        this.func_73729_b(xOffset, yOffset + offset + length, 0, 255, 5, 1);
    }

    private void drawMethodHelp(IMethod method) {
        if (method != null) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + this.field_147000_g - 4, 0, this.field_147000_g, 252, 70);
            int height = this.field_146289_q.field_78288_b;
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"agricraft_description.peripheralHelp") + ": " + method.signature(), this.field_147003_i + 7, this.field_147009_r + 175, 0x404040);
            float scale = 0.9f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            String[] write = IOHelper.getLinesArrayFromData(IOHelper.splitInLines(this.field_146289_q, method.getDescription(), 230.0f, scale));
            int x = 4 + this.field_147003_i + 7;
            int y = this.field_147009_r + 175 + height;
            for (int i = 0; i < write.length; ++i) {
                String line = write[i];
                int yOffset = i * height;
                this.field_146289_q.func_78276_b(line, (int)((float)x / scale), (int)((float)y / scale) + yOffset, 0x404040);
            }
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        }
    }

    private void loadButtonList() {
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 154, this.field_147009_r + 7, 12, 12, "?"));
        this.field_146292_n.add(new GuiButton(4, this.field_147003_i + 154, this.field_147009_r + 20, 10, 10, "\u219f"));
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 154, this.field_147009_r + 31, 10, 10, "\u2191"));
        this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 154, this.field_147009_r + 42, 10, 10, "\u2193"));
        this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 154, this.field_147009_r + 53, 10, 10, "\u21a1"));
        for (int i = 0; i < this.methods.length; ++i) {
            this.field_146292_n.add(new GuiButtonMethod(5 + i, this.field_147003_i + this.guideOffset + 3, this.field_147009_r + 8 + 16 * i, 68, 16, this.methods[i].getName()));
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k > 4) {
            if (button instanceof GuiButtonMethod) {
                ((GuiButtonMethod)button).onMouseClicked();
            }
        } else {
            switch (button.field_146127_k) {
                case 0: {
                    this.guideActive = !this.guideActive;
                    this.updateButtons();
                    break;
                }
                case 1: {
                    this.scroll(1);
                    break;
                }
                case 2: {
                    this.scroll(-1);
                    break;
                }
                case 3: {
                    this.scroll(this.maxScrollPosition());
                    break;
                }
                case 4: {
                    this.scroll(-this.scrollPosition);
                }
            }
        }
    }

    private void scroll(int amount) {
        int newPosition = this.scrollPosition + amount;
        int max = this.maxScrollPosition();
        this.scrollPosition = newPosition < 0 ? 0 : (newPosition > max ? max : newPosition);
        this.updateButtons();
    }

    private void updateButtons() {
        for (int i = 1; i < this.field_146292_n.size(); ++i) {
            Object obj = this.field_146292_n.get(i);
            if (obj == null || !(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button instanceof GuiButtonMethod) {
                if (!this.guideActive) {
                    ((GuiButtonMethod)button).disable();
                    continue;
                }
                int index = i - 4 - 1;
                if (index >= this.scrollPosition && index < this.scrollPosition + 10) {
                    ((GuiButtonMethod)button).enable(this.field_147009_r + 8 + 16 * (index - this.scrollPosition));
                    continue;
                }
                ((GuiButtonMethod)button).disable();
                continue;
            }
            button.field_146125_m = this.guideActive;
        }
    }

    private int maxScrollPosition() {
        return this.methods.length - 10;
    }

    private IMethod getActiveMethod() {
        GuiButtonMethod button = GuiButtonMethod.activeButton;
        if (button == null) {
            return null;
        }
        return this.methods[button.field_146127_k - 5];
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        GuiButtonMethod.activeButton = null;
        super.func_146281_b();
    }

    private static class GuiButtonMethod
    extends GuiButton {
        private static GuiButtonMethod activeButton;

        public GuiButtonMethod(int id, int x, int y, int xSize, int ySize, String display) {
            super(id, x, y, xSize, ySize, display);
        }

        public void onMouseClicked() {
            activeButton = activeButton == this ? null : this;
        }

        public boolean isActive() {
            return this == activeButton;
        }

        public void enable(int posY) {
            this.field_146129_i = posY;
            this.field_146125_m = true;
        }

        public void disable() {
            this.field_146125_m = false;
        }

        public void func_146112_a(Minecraft minecraft, int x, int y) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = minecraft.field_71466_p;
                minecraft.func_110434_K().func_110577_a(field_146122_a);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glBlendFunc((int)770, (int)771);
                int vOffset = this.isActive() ? 86 : 46 + k * 20;
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, vOffset, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, vOffset, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(minecraft, x, y);
                int l = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    l = 0xFFFFA0;
                }
                float scale = 0.6f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                this.func_73732_a(fontrenderer, this.field_146126_j, (int)((float)(this.field_146128_h + this.field_146120_f / 2) / scale), (int)((float)(this.field_146129_i + (this.field_146121_g - 4) / 2) / scale), l);
                GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            }
        }
    }
}

