/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.blocks.irrigation.AbstractBlockWaterChannel;
import com.infinityraider.agricraft.items.blocks.ItemBlockCustomWood;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderChannelValve;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannelValve;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWaterChannelValve
extends AbstractBlockWaterChannel<TileEntityChannelValve> {
    protected static final float MIN = 0.25f;
    protected static final float MAX = 0.75f;
    protected static final double EXPANSION = 0.015625;
    public static final AxisAlignedBB CENTER_BOX = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.3125).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.6875, 0.25, 0.25, 1.0, 0.75, 0.75).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.25, 0.25, 0.6875, 0.75, 0.75, 1.0).func_72321_a(0.015625, 0.015625, 0.015625);
    public static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.0, 0.25, 0.25, 0.3125, 0.75, 0.75).func_72321_a(0.015625, 0.015625, 0.015625);
    private final ItemBlockValve itemBlock = new ItemBlockValve((Block)this);

    public BlockWaterChannelValve() {
        super("valve");
    }

    public TileEntityChannelValve createNewTileEntity(World world, int meta) {
        return new TileEntityChannelValve();
    }

    public Optional<ItemBlockCustomWood> getItemBlock() {
        return Optional.of(this.itemBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, @Nullable Entity entity, boolean isActualState) {
        BlockWaterChannelValve.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)CENTER_BOX);
        TileEntityChannelValve tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannelValve.class).orElse(null);
        if (tile == null) {
            return;
        }
        if (tile.getConnections().get(EnumFacing.NORTH) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)NORTH_BOX);
        }
        if (tile.getConnections().get(EnumFacing.EAST) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)EAST_BOX);
        }
        if (tile.getConnections().get(EnumFacing.SOUTH) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)SOUTH_BOX);
        }
        if (tile.getConnections().get(EnumFacing.WEST) > 0) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)WEST_BOX);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityChannelValve tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannelValve.class).orElse(null);
        AxisAlignedBB selection = CENTER_BOX;
        if (tile != null) {
            if (tile.getConnections().get(EnumFacing.NORTH) > 0) {
                selection = selection.func_111270_a(NORTH_BOX);
            }
            if (tile.getConnections().get(EnumFacing.EAST) > 0) {
                selection = selection.func_111270_a(EAST_BOX);
            }
            if (tile.getConnections().get(EnumFacing.SOUTH) > 0) {
                selection = selection.func_111270_a(SOUTH_BOX);
            }
            if (tile.getConnections().get(EnumFacing.WEST) > 0) {
                selection = selection.func_111270_a(WEST_BOX);
            }
        }
        return selection;
    }

    @Override
    protected InfinityProperty[] getPropertyArray() {
        InfinityProperty[] properties = Arrays.copyOf(super.getPropertyArray(), super.getPropertyArray().length + 1);
        properties[properties.length - 1] = AgriProperties.POWERED;
        return properties;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)worldIn, (BlockPos)pos, TileEntityChannelValve.class);
        return AgriProperties.POWERED.applyToBlockState(super.func_176221_a(state, worldIn, pos), (Comparable)Boolean.valueOf(tile.isPresent() && ((TileEntityChannelValve)tile.get()).isPowered()));
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
        super.observedNeighborChange(observerState, world, pos, changedBlock, changedBlockPos);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityChannelValve) {
            TileEntityChannelValve valve = (TileEntityChannelValve)te;
            valve.updatePowerStatus();
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityChannelValve) {
            ((TileEntityChannelValve)te).updatePowerStatus();
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderChannelValve getRenderer() {
        return new RenderChannelValve(this);
    }

    public static class ItemBlockValve
    extends ItemBlockCustomWood {
        public ItemBlockValve(Block block) {
            super(block);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(stack, world, list, flag);
            list.add(AgriCore.getTranslator().translate("agricraft_tooltip.valve"));
        }
    }
}

