/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.compat.actuallyadditions;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import com.infinityraider.agricraft.compat.actuallyadditions.ActuallyAdditionsPlugin;
import com.infinityraider.infinitylib.utility.WorldHelper;
import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AgriCraftFarmerBehavior
implements IFarmerBehavior {
    public FarmerResult tryPlantSeed(ItemStack seed, World world, BlockPos pos, IFarmer farmer) {
        Optional<AgriSeed> agriSeed = AgriApi.getSeedRegistry().valueOf(seed);
        Optional agriCrop = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, IAgriCrop.class);
        if (agriSeed.isPresent() && agriCrop.isPresent()) {
            if (farmer.getEnergy() < ActuallyAdditionsPlugin.ENERGY_COST) {
                return FarmerResult.STOP_PROCESSING;
            }
            MethodResult result = ((IAgriCrop)agriCrop.get()).onApplySeeds(agriSeed.get(), null);
            if (result == MethodResult.SUCCESS) {
                farmer.extractEnergy(250);
                return FarmerResult.SUCCESS;
            }
        }
        return FarmerResult.FAIL;
    }

    public FarmerResult tryHarvestPlant(World world, BlockPos pos, IFarmer farmer) {
        Optional agriCrop = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, IAgriCrop.class);
        if (agriCrop.isPresent()) {
            if (farmer.getEnergy() < ActuallyAdditionsPlugin.ENERGY_COST) {
                return FarmerResult.STOP_PROCESSING;
            }
            ArrayList products = new ArrayList();
            MethodResult result = ((IAgriCrop)agriCrop.get()).onHarvest(products::add, null);
            if (result == MethodResult.SUCCESS) {
                farmer.extractEnergy(ActuallyAdditionsPlugin.ENERGY_COST);
                farmer.addToOutput(products);
                return FarmerResult.SUCCESS;
            }
        }
        return FarmerResult.FAIL;
    }

    public int getPriority() {
        return 10;
    }
}

