/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.v1.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.utility.StackHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.text.MessageFormat;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class ItemToolTipHandler {
    private static final ItemToolTipHandler INSTANCE = new ItemToolTipHandler();

    public static ItemToolTipHandler getInstance() {
        return INSTANCE;
    }

    private ItemToolTipHandler() {
    }

    @SubscribeEvent
    public void addSeedStatsTooltip(ItemTooltipEvent event) {
        AgriSeed seed;
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && (seed = (AgriSeed)AgriApi.getSeedRegistry().valueOf(stack).orElse(null)) != null) {
            if (seed.getStat().isAnalyzed()) {
                seed.getStat().addStats(event.getToolTip()::add);
            } else {
                event.getToolTip().add(" " + AgriCore.getTranslator().translate("agricraft_tooltip.unidentified"));
            }
        }
    }

    private static void addFormatted(ItemTooltipEvent event, String format, Object ... objects) {
        event.getToolTip().add(ChatFormatting.DARK_AQUA + MessageFormat.format(format, objects));
    }

    private static void addCategory(ItemTooltipEvent event, String category) {
        event.getToolTip().add(ChatFormatting.DARK_AQUA + category + ":");
    }

    private static void addParameter(ItemTooltipEvent event, String key, Object value) {
        event.getToolTip().add(ChatFormatting.DARK_AQUA + " - " + key + ": " + Objects.toString(value));
    }

    @SubscribeEvent
    public void addRegistryInfo(ItemTooltipEvent event) {
        if (AgriCraftConfig.enableRegistryTooltips) {
            Item item = event.getItemStack().func_77973_b();
            ItemToolTipHandler.addCategory(event, "Registry");
            ItemToolTipHandler.addParameter(event, "id", item.getRegistryName());
        }
    }

    @SubscribeEvent
    public void addNbtInfo(ItemTooltipEvent event) {
        if (AgriCraftConfig.enableNBTTooltips) {
            ItemToolTipHandler.addCategory(event, "NBT");
            if (StackHelper.hasTag(event.getItemStack())) {
                NBTTagCompound tag = StackHelper.getTag(event.getItemStack());
                for (String key : tag.func_150296_c()) {
                    ItemToolTipHandler.addParameter(event, key, tag.func_74781_a(key));
                }
            } else {
                ItemToolTipHandler.addFormatted(event, " - No NBT Tags", new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public void addOreDictInfo(ItemTooltipEvent event) {
        if (AgriCraftConfig.enableOreDictTooltips && !event.getItemStack().func_190926_b()) {
            int[] ids;
            ItemToolTipHandler.addCategory(event, "OreDict");
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)event.getItemStack())) {
                ItemToolTipHandler.addFormatted(event, " - {1} ({0})", id, OreDictionary.getOreName((int)id));
            }
            if (ids.length == 0) {
                ItemToolTipHandler.addFormatted(event, " - No OreDict Entries", new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public void addTrowelTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IAgriTrowelItem) {
            AgriSeed seed = AgriApi.getSeedRegistry().valueOf(event.getItemStack()).orElse(null);
            if (seed != null) {
                event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.seed") + ": " + seed.getPlant().getSeedName());
            } else {
                event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.trowel"));
            }
        }
    }

    @SubscribeEvent
    public void addClipperTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (StackHelper.isValid(stack, IAgriClipperItem.class)) {
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper1"));
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper2"));
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper3"));
        }
    }
}

