/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJournal
extends ItemBase
implements IAgriJournalItem,
IItemWithModel {
    public ItemJournal() {
        super("journal");
        this.func_77625_d(1);
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT);
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack);
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack);
        return stack.func_77946_l();
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            player.openGui((Object)AgriCraft.instance, 2, world, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        Preconditions.checkNotNull((Object)stack);
        tooltip.add(AgriCore.getTranslator().translate("agricraft_tooltip.discoveredSeeds") + ": " + this.getDiscoveredSeedIds(stack).count());
    }

    @Nonnull
    private Stream<String> getDiscoveredSeedIds(@Nonnull ItemStack journal) {
        Preconditions.checkNotNull((Object)journal);
        return Optional.of(journal).map(ItemStack::func_77978_p).map(tag -> tag.func_74779_i("agri_discovered")).map(ids -> ids.split(";")).map(Arrays::stream).orElseGet(Stream::empty);
    }

    @Override
    public void addEntry(@Nonnull ItemStack journal, @Nullable IAgriPlant plant) {
        Preconditions.checkNotNull((Object)journal);
        if (plant != null && !this.isSeedDiscovered(journal, plant)) {
            NBTTagCompound tag = StackHelper.getTag(journal);
            String old = tag.func_74779_i("agri_discovered");
            tag.func_74778_a("agri_discovered", old + plant.getId() + ";");
            journal.func_77982_d(tag);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSeedDiscovered(@Nonnull ItemStack journal, @Nullable IAgriPlant plant) {
        Preconditions.checkNotNull((Object)journal);
        if (plant == null) return false;
        if (!this.getDiscoveredSeedIds(journal).anyMatch(plant.getId()::equals)) return false;
        return true;
    }

    @Override
    public List<IAgriPlant> getDiscoveredSeeds(@Nullable ItemStack journal) {
        return Optional.ofNullable(journal).map(this::getDiscoveredSeedIds).orElseGet(Stream::empty).map(AgriApi.getPlantRegistry()::get).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

