/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.misc.IAgriConnectable;
import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.api.v1.misc.IAgriFluidComponent;
import com.infinityraider.agricraft.api.v1.util.AgriSideMetaMatrix;
import com.infinityraider.agricraft.blocks.irrigation.BlockWaterChannel;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.renderers.particles.LiquidSprayFX;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySprinkler
extends TileEntityBase
implements ITickable,
IAgriFluidComponent,
IAgriDisplayable {
    private int counter = 0;
    private float angle = 0.0f;
    private static final int BUFFER_CAP = 100;
    private static final int TICKS_PER_SECOND = 20;
    private static final int COVERAGE_HEIGHT = 5;
    private static final int COVERAGE_RADIUS = 3;
    private static final int COVERAGE_DIAMETER = 7;
    private static final int COVERAGE_AREA = 49;
    private boolean active = false;
    private int buffer = 0;
    private int columnCounter = 0;
    private int waterUsageRemainingMb = Integer.MAX_VALUE;
    private int waterUsageRemainingTicks = 0;

    public void writeTileNBT(NBTTagCompound tag) {
        if (this.counter > 0) {
            tag.func_74768_a("agri_level", this.counter);
        }
        if (this.active) {
            tag.func_74757_a("agri_sprinkled", this.active);
        }
        if (this.buffer > 0) {
            tag.func_74768_a("agri_buffer", this.buffer);
        }
        if (this.columnCounter > 0) {
            tag.func_74768_a("agri_column_counter", this.columnCounter);
        }
        if (this.waterUsageRemainingMb < Integer.MAX_VALUE) {
            tag.func_74768_a("agri_water_usage_remaining_mb", this.waterUsageRemainingMb);
        }
        if (this.waterUsageRemainingTicks > 0) {
            tag.func_74768_a("agri_water_usage_remaining_ticks", this.waterUsageRemainingTicks);
        }
    }

    public void readTileNBT(NBTTagCompound tag) {
        this.counter = tag.func_74762_e("agri_level");
        this.active = tag.func_74767_n("agri_sprinkled");
        this.buffer = tag.func_74762_e("agri_buffer");
        this.columnCounter = tag.func_74762_e("agri_column_counter");
        this.waterUsageRemainingMb = tag.func_74764_b("agri_water_usage_remaining_mb") ? tag.func_74762_e("agri_water_usage_remaining_mb") : Integer.MAX_VALUE;
        this.waterUsageRemainingTicks = tag.func_74762_e("agri_water_usage_remaining_ticks");
    }

    public boolean isConnected() {
        return WorldHelper.getBlock((IBlockAccess)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177984_a(), BlockWaterChannel.class).isPresent();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            boolean currentActiveness;
            if (this.waterUsageRemainingTicks <= 0 || this.waterUsageRemainingMb < 0) {
                this.waterUsageRemainingMb = Math.abs(AgriCraftConfig.sprinklerRatePerSecond);
                this.waterUsageRemainingTicks = 20;
            }
            int waterUsageThisTick = this.waterUsageRemainingMb / this.waterUsageRemainingTicks;
            this.waterUsageRemainingMb -= waterUsageThisTick;
            --this.waterUsageRemainingTicks;
            boolean bl = currentActiveness = this.buffer >= waterUsageThisTick && this.buffer > 0;
            if (currentActiveness != this.active) {
                this.active = currentActiveness;
                this.markForUpdate();
            }
            if (!this.active) {
                return;
            }
            this.buffer -= waterUsageThisTick;
            if (this.columnCounter >= 0 && this.columnCounter < 49) {
                this.irrigateCurrentColumn();
            }
            ++this.columnCounter;
            if (this.columnCounter >= 49 && this.columnCounter >= AgriCraftConfig.sprinklerGrowthIntervalTicks || this.columnCounter < 0) {
                this.columnCounter = 0;
            }
        } else if (this.active) {
            this.renderLiquidSpray();
        }
    }

    private void irrigateCurrentColumn() {
        int targetX = this.field_174879_c.func_177958_n() - 3 + this.columnCounter % 7;
        int targetZ = this.field_174879_c.func_177952_p() - 3 + this.columnCounter / 7;
        int startY = this.field_174879_c.func_177956_o() - 1;
        int stopY = Math.max(this.field_174879_c.func_177956_o() - 5, 0);
        this.irrigateColumn(targetX, targetZ, startY, stopY);
    }

    private void irrigateColumn(int targetX, int targetZ, int highestY, int lowestY) {
        for (int targetY = highestY; targetY >= lowestY; --targetY) {
            BlockPos target = new BlockPos(targetX, targetY, targetZ);
            IBlockState state = this.func_145831_w().func_180495_p(target);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)this.func_145831_w(), target)) continue;
            if ((block instanceof IPlantable || block instanceof IGrowable) && targetY != lowestY) {
                if (this.getRandom().nextInt(100) >= AgriCraftConfig.sprinklerGrowthChance) continue;
                block.func_180650_b(this.func_145831_w(), target, state, this.getRandom());
                continue;
            }
            if (!(block instanceof BlockFarmland) || (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) >= 7) break;
            this.func_145831_w().func_180501_a(target, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            break;
        }
    }

    @Override
    public boolean canConnectTo(EnumFacing side, IAgriConnectable component) {
        return side.equals((Object)EnumFacing.UP) && component instanceof IAgriFluidComponent;
    }

    @Override
    public AgriSideMetaMatrix getConnections() {
        AgriSideMetaMatrix connections = new AgriSideMetaMatrix();
        connections.set(EnumFacing.UP, (byte)1);
        return connections;
    }

    @Override
    public int acceptFluid(int inputHeight, int inputAmount, boolean partial, boolean simulate) {
        int totalFluid = this.buffer + inputAmount;
        int remainingFluid = Math.max(totalFluid - 100, 0);
        int consumedFluid = inputAmount - remainingFluid;
        if (remainingFluid != 0 && !partial) {
            return inputAmount;
        }
        if (remainingFluid != inputAmount && !simulate) {
            this.buffer += consumedFluid;
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
        return remainingFluid;
    }

    @Override
    public int getFluidAmount() {
        return this.buffer;
    }

    @Override
    public int getFluidCapacity() {
        return 100;
    }

    @Override
    public int getFluidHeight() {
        return 0;
    }

    @Override
    public int getMinFluidHeight() {
        return 0;
    }

    @Override
    public int getMaxFluidHeight() {
        return 1000;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getChannelIcon() {
        return WorldHelper.getTile((IBlockAccess)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177984_a(), TileEntityChannel.class).map(c -> c.getIcon()).orElse(BaseIcons.OAK_PLANKS.getIcon());
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getHeadIcon() {
        return BaseIcons.IRON_BLOCK.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderLiquidSpray() {
        if (AgriCraftConfig.disableParticles) {
            return;
        }
        this.angle = (this.angle + 5.0f) % 360.0f;
        int particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        this.counter = (this.counter + 1) % (particleSetting + 1);
        if (this.counter == 0) {
            for (int i = 0; i < 4; ++i) {
                float alpha = -(this.angle + (float)(90 * i)) * (float)Math.PI / 180.0f;
                double xOffset = 0.25 * Math.cos(alpha);
                double zOffset = 0.25 * Math.sin(alpha);
                float radius = 0.3f;
                for (int j = 0; j <= 4; ++j) {
                    float beta = (float)(-j) * (float)Math.PI / 8.0f;
                    Vec3d vector = new Vec3d((double)radius * Math.cos(alpha), (double)radius * Math.sin(beta), (double)radius * Math.sin(alpha));
                    this.spawnLiquidSpray(xOffset * (double)(4 - j) / 4.0, zOffset * (double)(4 - j) / 4.0, vector);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLiquidSpray(double xOffset, double zOffset, Vec3d vector) {
        double sx = (double)((float)this.xCoord() + 0.5f) + xOffset;
        double sy = (float)this.yCoord() + 0.5f;
        double sz = (double)((float)this.zCoord() + 0.5f) + zOffset;
        LiquidSprayFX spray = new LiquidSprayFX(this.func_145831_w(), FluidRegistry.WATER, sx, sy, sz, 0.3f, 0.7f, vector);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)spray);
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<String> information) {
        Preconditions.checkNotNull(information);
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.waterLevel") + ": " + this.buffer + "/" + 100);
    }

    public float getAngle() {
        return this.angle;
    }
}

