/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriRenderType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AgriTexture {
    private AgriRenderType render_type = AgriRenderType.HASH;
    private final String[] plant_models = new String[0];
    private final String[][] plant_textures = new String[][]{{"minecraft:block/wheat_stage0"}, {"minecraft:block/wheat_stage1"}, {"minecraft:block/wheat_stage2"}, {"minecraft:block/wheat_stage3"}, {"minecraft:block/wheat_stage4"}, {"minecraft:block/wheat_stage5"}, {"minecraft:block/wheat_stage6"}, {"minecraft:block/wheat_stage7"}};

    public AgriTexture() {
    }

    public AgriTexture(AgriRenderType render_type, String[][] plant_textures) {
        this.render_type = render_type;
        System.arraycopy(plant_textures, 0, this.plant_textures, 0, Math.min(plant_textures.length, this.plant_textures.length));
        String[] last = new String[]{"NO TEXTURE!"};
        for (int i = 0; i < this.plant_textures.length; ++i) {
            if (this.plant_textures[i] == null) {
                this.plant_textures[i] = last;
                continue;
            }
            last = this.plant_textures[i];
        }
    }

    public AgriRenderType getRenderType() {
        return this.render_type;
    }

    public int getGrowthStages() {
        return this.plant_textures.length;
    }

    public List<String> getAllTextures() {
        return Arrays.stream(this.plant_textures).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
    }

    public String[][] getPlantTextures() {
        return (String[][])Arrays.copyOf(this.plant_textures, this.plant_textures.length);
    }

    public String[] getPlantTextures(int stage) {
        return this.plant_textures[stage % this.plant_textures.length];
    }

    public boolean useModels() {
        return this.plant_models.length > 0;
    }

    public String getPlantModel(int index) {
        return this.plant_models[index % this.plant_models.length];
    }

    public boolean validate() {
        String[][] stringArray = this.plant_textures;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            for (String texture : stringArray2 = stringArray[i]) {
                if (AgriCore.getValidator().isValidResource(texture)) continue;
                AgriCore.getCoreLogger().info("Invalid AgriTexture! Invalid Plant Texture: \"{0}\"!", texture);
                return false;
            }
        }
        if (this.useModels()) {
            for (String[] stringArray3 : this.plant_models) {
                if (AgriCore.getValidator().isValidResource((String)stringArray3)) continue;
                AgriCore.getCoreLogger().info("Invalid AgriTexture! Invalid Plant Model: \"{0}\"!", new Object[]{stringArray3});
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("Icon Set:\n");
        sb.append("\t- Render Type: ").append((Object)this.render_type).append("\n");
        sb.append("\t- Supported Number of Growth Stages:").append(this.plant_textures.length).append("\n");
        sb.append("\t- Plant Textures:\n");
        for (int i = 0; i < this.plant_textures.length; ++i) {
            sb.append("\t\t- ").append(i).append(" : ").append(this.plant_textures[i]).append("\n");
        }
        return sb.toString();
    }
}

