/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.client;

import com.infinityraider.agricraft.api.v1.AgriApi;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;

@OnlyIn(value=Dist.CLIENT)
public enum AgriPlantRenderType implements IExtensibleEnum
{
    HASH((sprite, yOffset) -> AgriApi.getPlantQuadGenerator().bakeQuadsForHashPattern(sprite, yOffset)),
    CROSS((sprite, yOffset) -> AgriApi.getPlantQuadGenerator().bakeQuadsForCrossPattern(sprite, yOffset)),
    PLUS((sprite, yOffset) -> AgriApi.getPlantQuadGenerator().bakeQuadsForPlusPattern(sprite, yOffset)),
    RHOMBUS((sprite, yOffset) -> AgriApi.getPlantQuadGenerator().bakeQuadsForRhombusPattern(sprite, yOffset)),
    GOURD((sprite, yOffset) -> AgriApi.getPlantQuadGenerator().bakeQuadsForGourdPattern(sprite, yOffset));

    private final IQuadGenerator generator;

    private AgriPlantRenderType(IQuadGenerator generator) {
        this.generator = generator;
    }

    @Nonnull
    public List<BakedQuad> bakedQuads(@Nullable Direction direction, @Nonnull TextureAtlasSprite sprite, int yOffset) {
        return this.generator.bakeQuads(sprite, yOffset);
    }

    public static AgriPlantRenderType create(String name, IQuadGenerator generator) {
        throw new IllegalStateException("Enum not extended");
    }

    @FunctionalInterface
    public static interface IQuadGenerator {
        @Nonnull
        public List<BakedQuad> bakeQuads(@Nonnull TextureAtlasSprite var1, int var2);
    }
}

