/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.infinityraider.agricraft.api.v1.client.AgriPlantRenderType;
import com.infinityraider.agricraft.api.v1.client.IAgriPlantQuadGenerator;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriRenderable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class PlantQuadBakeEvent
extends Event {
    private final IAgriPlantQuadGenerator quadGenerator;
    private final IAgriRenderable plant;
    private final IAgriGrowthStage stage;
    private final Direction direction;
    private final ResourceLocation texture;
    private final TextureAtlasSprite sprite;
    private final AgriPlantRenderType renderType;
    private final int yOffset;
    private final ImmutableList<BakedQuad> originalQuads;
    private final List<BakedQuad> quads;

    public PlantQuadBakeEvent(IAgriPlantQuadGenerator quadGenerator, IAgriRenderable plant, IAgriGrowthStage stage, @Nullable Direction direction, ResourceLocation texture, TextureAtlasSprite sprite, AgriPlantRenderType renderType, int yOffset, List<BakedQuad> quads) {
        this.quadGenerator = quadGenerator;
        this.plant = plant;
        this.stage = stage;
        this.direction = direction;
        this.texture = texture;
        this.sprite = sprite;
        this.renderType = renderType;
        this.yOffset = yOffset;
        this.originalQuads = ImmutableList.copyOf(quads);
        this.quads = Lists.newArrayList(quads);
    }

    public IAgriPlantQuadGenerator getQuadGenerator() {
        return this.quadGenerator;
    }

    public IAgriRenderable getPlant() {
        return this.plant;
    }

    public IAgriGrowthStage getGrowthStage() {
        return this.stage;
    }

    @Nullable
    public Direction getCullFace() {
        return this.direction;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public AgriPlantRenderType getRenderType() {
        return this.renderType;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public ImmutableList<BakedQuad> getOriginalQuads() {
        return this.originalQuads;
    }

    public List<BakedQuad> getOutputQuads() {
        return this.quads;
    }

    public PlantQuadBakeEvent injectQuads(BakedQuad ... quads) {
        return this.injectQuads(Arrays.asList(quads));
    }

    public PlantQuadBakeEvent injectQuads(Collection<BakedQuad> quads) {
        this.getOutputQuads().addAll(quads);
        return this;
    }

    public PlantQuadBakeEvent removeQuads(BakedQuad ... quads) {
        return this.removeQuads(Arrays.asList(quads));
    }

    public PlantQuadBakeEvent removeQuads(Collection<BakedQuad> quads) {
        this.getOutputQuads().removeAll(quads);
        return this;
    }

    public PlantQuadBakeEvent clearQuads() {
        this.getOutputQuads().clear();
        return this;
    }
}

