/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.crop;

import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.crop.IAgriHarvestable;
import com.infinityraider.agricraft.api.v1.crop.IAgriRakeable;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizable;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenomeAcceptor;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenomeProvider;
import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlantProvider;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeedSpawnable;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IAgriCrop
extends IAgriPlantProvider,
IAgriGenomeProvider,
IAgriGenomeAcceptor,
IAgriStatProvider,
IAgriFertilizable,
IAgriHarvestable,
IAgriWeedSpawnable,
IAgriRakeable,
IAgriDisplayable {
    public boolean isValid();

    @Nonnull
    public BlockPos getPosition();

    @Nonnull
    public BlockState getBlockState();

    @Nonnull
    public FluidState getFluidState();

    @Nonnull
    public IAgriGrowthStage getGrowthStage();

    public boolean setGrowthStage(@Nonnull IAgriGrowthStage var1);

    public boolean hasCropSticks();

    public boolean isCrossCrop();

    public boolean setCrossCrop(boolean var1);

    default public boolean isFertile() {
        return this.getFertilityResponse().isFertile();
    }

    public IAgriGrowthResponse getFertilityResponse();

    public boolean isMature();

    public boolean isFullyGrown();

    @Nonnull
    public Optional<IAgriSoil> getSoil();

    public void breakCrop(@Nullable LivingEntity var1);

    @Nonnull
    public Stream<IAgriCrop> streamNeighbours();

    @Nonnull
    default public Stream<IAgriCrop> streamNeighbours(Predicate<IAgriCrop> filter) {
        return this.streamNeighbours().filter(filter);
    }

    @Nonnull
    default public List<IAgriCrop> getNeighbours() {
        return this.streamNeighbours().collect(Collectors.toList());
    }

    @Nonnull
    default public List<IAgriCrop> getNeighbours(Predicate<IAgriCrop> filter) {
        return this.streamNeighbours(filter).collect(Collectors.toList());
    }

    @Nullable
    default public World world() {
        return this.asTile().func_145831_w();
    }

    default public TileEntity asTile() {
        return (TileEntity)this;
    }

    public void dropItem(ItemStack var1);
}

