/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.event;

import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class AgriCropEvent
extends Event {
    private final IAgriCrop crop;

    protected AgriCropEvent(@Nonnull IAgriCrop crop) {
        this.crop = Objects.requireNonNull(crop);
    }

    @Nonnull
    public IAgriCrop getCrop() {
        return this.crop;
    }

    public static abstract class Trowel
    extends AgriCropEvent {
        private final ItemStack trowel;
        private final LivingEntity entity;

        protected Trowel(@Nonnull IAgriCrop crop, @Nonnull ItemStack trowel, @Nullable LivingEntity entity) {
            super(crop);
            this.trowel = trowel;
            this.entity = entity;
        }

        public ItemStack getTrowel() {
            return this.trowel;
        }

        @Nullable
        public LivingEntity getEntity() {
            return this.entity;
        }

        public static final class Post
        extends Trowel {
            public Post(@Nonnull IAgriCrop crop, @Nonnull ItemStack trowel, @Nullable LivingEntity entity) {
                super(crop, trowel, entity);
            }
        }

        @Cancelable
        public static final class Pre
        extends Trowel {
            public Pre(@Nonnull IAgriCrop crop, @Nonnull ItemStack trowel, @Nullable LivingEntity entity) {
                super(crop, trowel, entity);
            }
        }
    }

    public static abstract class Clip
    extends AgriCropEvent {
        private final ItemStack clippers;
        private final LivingEntity entity;

        protected Clip(@Nonnull IAgriCrop crop, @Nonnull ItemStack clippers, @Nullable LivingEntity entity) {
            super(crop);
            this.clippers = clippers;
            this.entity = entity;
        }

        public ItemStack getClippers() {
            return this.clippers;
        }

        @Nullable
        public LivingEntity getEntity() {
            return this.entity;
        }

        public static final class Post
        extends Clip {
            private final List<ItemStack> drops;

            public Post(@Nonnull IAgriCrop crop, @Nonnull ItemStack clipper, @Nonnull List<ItemStack> drops, @Nullable LivingEntity entity) {
                super(crop, clipper, entity);
                this.drops = drops;
            }

            public List<ItemStack> getDrops() {
                return this.drops;
            }
        }

        @Cancelable
        public static final class Pre
        extends Clip {
            public Pre(@Nonnull IAgriCrop crop, @Nonnull ItemStack clipper, @Nullable LivingEntity entity) {
                super(crop, clipper, entity);
            }
        }
    }

    public static abstract class Rake
    extends AgriCropEvent {
        private final ItemStack rake;
        private final LivingEntity entity;

        protected Rake(@Nonnull IAgriCrop crop, @Nonnull ItemStack rake, @Nullable LivingEntity entity) {
            super(crop);
            this.rake = rake;
            this.entity = entity;
        }

        public ItemStack getRake() {
            return this.rake;
        }

        @Nullable
        public LivingEntity getEntity() {
            return this.entity;
        }

        public static final class Post
        extends Rake {
            private final List<ItemStack> drops;

            public Post(@Nonnull IAgriCrop crop, @Nonnull ItemStack rake, @Nonnull List<ItemStack> drops, @Nullable LivingEntity entity) {
                super(crop, rake, entity);
                this.drops = drops;
            }

            @Nonnull
            public List<ItemStack> getDrops() {
                return this.drops;
            }
        }

        @Cancelable
        public static final class Pre
        extends Rake {
            public Pre(@Nonnull IAgriCrop crop, @Nonnull ItemStack rake, @Nullable LivingEntity entity) {
                super(crop, rake, entity);
            }
        }
    }

    public static abstract class Break
    extends AgriCropEvent {
        private final LivingEntity entity;

        protected Break(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
            super(crop);
            this.entity = entity;
        }

        @Nullable
        public LivingEntity getEntity() {
            return this.entity;
        }

        public static final class Post
        extends Break {
            public Post(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
                super(crop, entity);
            }
        }

        @Cancelable
        public static final class Pre
        extends Break {
            public Pre(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
                super(crop, entity);
            }
        }
    }

    public static abstract class Spawn
    extends AgriCropEvent {
        private final Type type;

        protected Spawn(@Nonnull IAgriCrop crop, @Nonnull Type type) {
            super(crop);
            this.type = type;
        }

        @Nonnull
        public Type getType() {
            return this.type;
        }

        public static enum Type {
            PLANT,
            WEEDS;

        }

        public static abstract class Weed
        extends Spawn {
            private final IAgriWeed weed;

            protected Weed(@Nonnull IAgriCrop crop, @Nonnull IAgriWeed plant) {
                super(crop, Type.WEEDS);
                this.weed = plant;
            }

            public IAgriWeed getWeed() {
                return this.weed;
            }

            public static final class Post
            extends Weed {
                public Post(@Nonnull IAgriCrop crop, @Nonnull IAgriWeed weed) {
                    super(crop, weed);
                }
            }

            @Cancelable
            public static final class Pre
            extends Weed {
                public Pre(@Nonnull IAgriCrop crop, @Nonnull IAgriWeed weed) {
                    super(crop, weed);
                }
            }
        }

        public static abstract class Plant
        extends Spawn {
            private final IAgriGenome genome;

            protected Plant(@Nonnull IAgriCrop crop, @Nonnull IAgriGenome genome) {
                super(crop, Type.PLANT);
                this.genome = genome;
            }

            public IAgriGenome getGenome() {
                return this.genome;
            }

            public IAgriPlant getPlant() {
                return this.getGenome().getPlant();
            }

            public static final class Post
            extends Plant {
                public Post(@Nonnull IAgriCrop crop, @Nonnull IAgriGenome genome) {
                    super(crop, genome);
                }
            }

            @Cancelable
            public static final class Pre
            extends Plant {
                public Pre(@Nonnull IAgriCrop crop, @Nonnull IAgriGenome genome) {
                    super(crop, genome);
                }
            }
        }
    }

    public static abstract class Plant
    extends AgriCropEvent {
        private final IAgriGenome seed;
        private final LivingEntity entity;

        protected Plant(@Nonnull IAgriCrop crop, @Nonnull IAgriGenome seed, @Nullable LivingEntity entity) {
            super(crop);
            this.seed = Objects.requireNonNull(seed);
            this.entity = entity;
        }

        @Nonnull
        public IAgriGenome getSeed() {
            return this.seed;
        }

        @Nullable
        public LivingEntity getEntity() {
            return this.entity;
        }

        public static final class Post
        extends Plant {
            public Post(@Nonnull IAgriCrop crop, @Nonnull IAgriGenome seed, @Nullable LivingEntity entity) {
                super(crop, seed, entity);
            }
        }

        @Cancelable
        public static final class Pre
        extends Plant {
            public Pre(@Nonnull IAgriCrop crop, @Nonnull IAgriGenome seed, @Nullable LivingEntity entity) {
                super(crop, seed, entity);
            }
        }
    }

    public static abstract class Grow
    extends AgriCropEvent {
        private final Type type;

        protected Grow(@Nonnull IAgriCrop crop, @Nonnull Type type) {
            super(crop);
            this.type = type;
        }

        @Nonnull
        public Type getType() {
            return this.type;
        }

        public static enum Type {
            GENERAL,
            PLANT,
            WEEDS,
            CROSS;

        }

        public static abstract class Cross
        extends Grow {
            protected Cross(@Nonnull IAgriCrop crop) {
                super(crop, Type.CROSS);
            }

            public static final class Post
            extends Cross {
                public Post(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }

            @Cancelable
            public static final class Pre
            extends Cross {
                public Pre(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }
        }

        public static abstract class Weeds
        extends Grow {
            protected Weeds(@Nonnull IAgriCrop crop) {
                super(crop, Type.WEEDS);
            }

            public static final class Post
            extends Weeds {
                public Post(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }

            @Cancelable
            public static final class Pre
            extends Weeds {
                public Pre(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }
        }

        public static abstract class Plant
        extends Grow {
            protected Plant(@Nonnull IAgriCrop crop) {
                super(crop, Type.PLANT);
            }

            public static final class Post
            extends Plant {
                public Post(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }

            @Cancelable
            public static final class Pre
            extends Plant {
                public Pre(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }
        }

        public static abstract class General
        extends Grow {
            protected General(@Nonnull IAgriCrop crop) {
                super(crop, Type.GENERAL);
            }

            public static final class Post
            extends General {
                public Post(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }

            @Cancelable
            public static final class Pre
            extends General {
                public Pre(@Nonnull IAgriCrop crop) {
                    super(crop);
                }
            }
        }
    }

    public static abstract class Harvest
    extends AgriCropEvent {
        private final LivingEntity entity;

        protected Harvest(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
            super(crop);
            this.entity = entity;
        }

        @Nullable
        public LivingEntity getEntity() {
            return this.entity;
        }

        public static final class Post
        extends Harvest {
            public Post(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
                super(crop, entity);
            }
        }

        @Cancelable
        public static final class Pre
        extends Harvest {
            public Pre(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
                super(crop, entity);
            }
        }
    }
}

