/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.genetics;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlantProvider;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IAgriGenome
extends IAgriPlantProvider,
IAgriStatProvider,
IAgriDisplayable {
    @Override
    default public boolean hasPlant() {
        return this.getPlant().isPlant();
    }

    @Override
    default public IAgriPlant getPlant() {
        return this.getGenePair(AgriApi.getGeneRegistry().getPlantGene()).getTrait();
    }

    default public <T> Optional<IAgriGenePair<T>> getGenePair(String geneId) {
        return AgriApi.getGeneRegistry().get(geneId).map(gene -> this.getGenePair((IAgriGene)gene));
    }

    public <T> IAgriGenePair<T> getGenePair(IAgriGene<T> var1);

    default public <T> T getTrait(IAgriGene<T> gene) {
        return this.getGenePair(gene).getTrait();
    }

    default public ItemStack toSeedStack() {
        return this.toSeedStack(1);
    }

    public ItemStack toSeedStack(int var1);

    public IAgriGenome clone();

    public boolean writeToNBT(@Nonnull CompoundNBT var1);

    public boolean readFromNBT(@Nonnull CompoundNBT var1);

    default public boolean equalGenome(IAgriGenome other) {
        if (this == other) {
            return true;
        }
        for (IAgriGene gene : AgriApi.getGeneRegistry().all()) {
            if (this.getGenePair(gene).equals((Object)other.getGenePair(gene))) continue;
            return false;
        }
        return true;
    }

    default public List<IAgriGenePair<?>> getGeneList() {
        return this.getGeneList(false);
    }

    default public List<IAgriGenePair<?>> getGeneList(boolean hidden) {
        return AgriApi.getGeneRegistry().stream().filter(gene -> hidden || !gene.isHidden()).map(this::getGenePair).collect(Collectors.toList());
    }

    public static interface Builder {
        public IAgriGenome build();

        public <T> Builder put(IAgriGenePair<T> var1);

        default public Builder put(IAgriGenePair<?> ... pairs) {
            return this.put(Arrays.asList(pairs));
        }

        default public Builder put(Collection<IAgriGenePair<?>> pairs) {
            return this.consumeStream(pairs.stream());
        }

        default public Builder populate(Function<IAgriGene<?>, IAgriGenePair<?>> mapper) {
            return this.consumeStream(AgriApi.getGeneRegistry().stream().map(mapper));
        }

        default public Builder consumeStream(Stream<IAgriGenePair<?>> stream) {
            stream.forEach(this::put);
            return this;
        }

        default public Builder cloneFrom(IAgriGenome genome) {
            return this.populate(gene -> genome.getGenePair(gene).clone());
        }

        default public Builder randomStats(Random random) {
            return this.randomStats(IAgriStat::getMax, random);
        }

        default public Builder randomStats(ToIntFunction<IAgriStat> maxFunc, Random random) {
            return this.randomStats((IAgriStat stat) -> random.nextInt(maxFunc.applyAsInt((IAgriStat)stat)) + 1);
        }

        default public Builder randomStats(ToIntFunction<IAgriStat> randomizer) {
            return this.consumeStream(AgriApi.getStatRegistry().stream().map(stat -> AgriApi.getGeneRegistry().get((IAgriStat)stat).map(gene -> {
                IAllele<Integer> first = gene.getAllele(randomizer.applyAsInt((IAgriStat)stat));
                IAllele<Integer> second = gene.getAllele(randomizer.applyAsInt((IAgriStat)stat));
                return gene.generateGenePair(first, second);
            })).filter(Optional::isPresent).map(Optional::get));
        }
    }
}

