/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.genetics;

import com.infinityraider.agricraft.api.v1.misc.IAgriRegisterable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAgriMutation
extends IAgriRegisterable<IAgriMutation> {
    public double getChance();

    @Nonnull
    public IAgriPlant getChild();

    @Nonnull
    public List<IAgriPlant> getParents();

    default public boolean hasChild(@Nullable IAgriPlant plant) {
        return this.getChild().equals(plant);
    }

    default public boolean hasParent(@Nullable IAgriPlant plant) {
        return this.getParents().contains(plant);
    }

    default public boolean hasParent(IAgriPlant ... plants) {
        return this.getParents().containsAll(Arrays.asList(plants));
    }

    default public boolean hasParent(@Nullable Collection<IAgriPlant> plants) {
        return this.getParents().containsAll(plants);
    }

    default public boolean areParentsIn(IAgriPlant ... plants) {
        return Arrays.asList(plants).containsAll(this.getParents());
    }

    default public boolean areParentsIn(@Nullable Collection<IAgriPlant> plants) {
        return plants != null && plants.containsAll(this.getParents());
    }
}

