/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.text.TranslationTextComponent;

public enum AgriSeason {
    SPRING("spring"),
    SUMMER("summer"),
    AUTUMN("autumn", "fall"),
    WINTER("winter"),
    ANY("any", "all");

    private final List<String> keys;

    private AgriSeason(String ... keys) {
        this.keys = Arrays.asList(keys);
    }

    public boolean matches(AgriSeason other) {
        return other == this || other == ANY || this == ANY;
    }

    public boolean isSeason() {
        return this != ANY;
    }

    public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent("agricraft.season." + this.name().toLowerCase());
    }

    public static Optional<AgriSeason> fromString(String string) {
        return Arrays.stream(AgriSeason.values()).filter(season -> season.keys.stream().anyMatch(string::equalsIgnoreCase)).findAny();
    }

    public static Stream<AgriSeason> stream() {
        return Arrays.stream(AgriSeason.values()).filter(season -> season != ANY);
    }
}

