/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.mutable.MutableObject;

public interface IAgriGrowthResponse {
    public static final IAgriGrowthResponse FERTILE = new IAgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return true;
        }

        @Override
        public boolean isLethal() {
            return false;
        }
    };
    public static final IAgriGrowthResponse INFERTILE = new IAgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return false;
        }
    };
    public static final IAgriGrowthResponse LETHAL = new IAgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return true;
        }
    };
    public static final IAgriGrowthResponse KILL_IT_WITH_FIRE = new IAgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return true;
        }

        @Override
        public boolean killInstantly() {
            return true;
        }

        @Override
        public void onPlantKilled(IAgriCrop crop) {
            World world = crop.world();
            if (world instanceof ServerWorld) {
                double x = (double)crop.getPosition().func_177958_n() + 0.5;
                double y = (double)crop.getPosition().func_177956_o() + 0.5;
                double z = (double)crop.getPosition().func_177952_p() + 0.5;
                for (int i = 0; i < 3; ++i) {
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, x + 0.25 * world.func_201674_k().nextDouble(), y, z + 0.25 * world.func_201674_k().nextDouble(), 1, 0.0, 1.0, 0.0, 0.05);
                }
                world.func_184148_a(null, x, y, z, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.2f + world.func_201674_k().nextFloat() * 0.2f, 0.9f + world.func_201674_k().nextFloat() * 0.15f);
            }
        }
    };
    public static final Collector<IAgriGrowthResponse, MutableObject<IAgriGrowthResponse>, IAgriGrowthResponse> COLLECTOR = new Collector<IAgriGrowthResponse, MutableObject<IAgriGrowthResponse>, IAgriGrowthResponse>(){

        @Override
        public Supplier<MutableObject<IAgriGrowthResponse>> supplier() {
            return Collection.SUPPLIER;
        }

        @Override
        public BiConsumer<MutableObject<IAgriGrowthResponse>, IAgriGrowthResponse> accumulator() {
            return Collection.ACCUMULATOR;
        }

        @Override
        public BinaryOperator<MutableObject<IAgriGrowthResponse>> combiner() {
            return Collection.COMBINER;
        }

        @Override
        public Function<MutableObject<IAgriGrowthResponse>, IAgriGrowthResponse> finisher() {
            return Collection.FINISHER;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    };

    public boolean isFertile();

    public boolean isLethal();

    default public boolean killInstantly() {
        return false;
    }

    default public void onPlantKilled(IAgriCrop crop) {
    }

    public static final class Collection {
        public static final Supplier<MutableObject<IAgriGrowthResponse>> SUPPLIER = () -> new MutableObject((Object)FERTILE);
        public static final BiConsumer<MutableObject<IAgriGrowthResponse>, IAgriGrowthResponse> ACCUMULATOR = (champion, contestant) -> {
            if (((IAgriGrowthResponse)champion.getValue()).killInstantly()) {
                return;
            }
            if (contestant.killInstantly()) {
                champion.setValue(contestant);
                return;
            }
            if (((IAgriGrowthResponse)champion.getValue()).isLethal()) {
                return;
            }
            if (contestant.isLethal()) {
                champion.setValue(contestant);
                return;
            }
            if (!((IAgriGrowthResponse)champion.getValue()).isFertile()) {
                return;
            }
            if (!contestant.isFertile()) {
                champion.setValue(contestant);
            }
        };
        public static final BinaryOperator<MutableObject<IAgriGrowthResponse>> COMBINER = (a, b) -> {
            if (((IAgriGrowthResponse)a.getValue()).killInstantly()) {
                return a;
            }
            if (((IAgriGrowthResponse)b.getValue()).killInstantly()) {
                return b;
            }
            if (((IAgriGrowthResponse)a.getValue()).isLethal()) {
                return a;
            }
            if (((IAgriGrowthResponse)b.getValue()).isLethal()) {
                return b;
            }
            if (!((IAgriGrowthResponse)a.getValue()).isFertile()) {
                return a;
            }
            if (!((IAgriGrowthResponse)b.getValue()).isFertile()) {
                return b;
            }
            return a;
        };
        public static final Function<MutableObject<IAgriGrowthResponse>, IAgriGrowthResponse> FINISHER = MutableObject::getValue;

        private Collection() {
        }
    }
}

