/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.api.v1.misc.IAgriRegisterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public interface IAgriSoil
extends IAgriRegisterable<IAgriSoil>,
IAgriDisplayable {
    @Override
    @Nonnull
    public String getId();

    @Nonnull
    public ITextComponent getName();

    @Nonnull
    public Collection<BlockState> getVariants();

    @Nonnull
    public Humidity getHumidity();

    @Nonnull
    public Acidity getAcidity();

    @Nonnull
    public Nutrients getNutrients();

    public double getGrowthModifier();

    public boolean isSoil();

    default public boolean isVariant(@Nonnull BlockState state) {
        return this.getVariants().contains(state);
    }

    @Override
    default public void addDisplayInfo(@Nonnull Consumer<ITextComponent> consumer) {
        consumer.accept(Tooltips.SOIL);
        consumer.accept(Tooltips.tooltipHumidity(this));
        consumer.accept(Tooltips.tooltipAcidity(this));
        consumer.accept(Tooltips.tooltipNutrients(this));
    }

    public static final class Tooltips {
        public static final ITextComponent SOIL = new TranslationTextComponent("agricraft.tooltip.soil").func_240699_a_(TextFormatting.DARK_GRAY);
        public static final ITextComponent HUMIDITY = new TranslationTextComponent("agricraft.tooltip.humidity").func_240699_a_(TextFormatting.DARK_GRAY);
        public static final ITextComponent ACIDITY = new TranslationTextComponent("agricraft.tooltip.acidity").func_240699_a_(TextFormatting.DARK_GRAY);
        public static final ITextComponent NUTRIENTS = new TranslationTextComponent("agricraft.tooltip.nutrients").func_240699_a_(TextFormatting.DARK_GRAY);

        private Tooltips() {
        }

        private static ITextComponent tooltipHumidity(IAgriSoil soil) {
            return new StringTextComponent(" - ").func_230529_a_(HUMIDITY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(soil.getHumidity().getDescription()).func_240699_a_(TextFormatting.DARK_GRAY);
        }

        private static ITextComponent tooltipAcidity(IAgriSoil soil) {
            return new StringTextComponent(" - ").func_230529_a_(ACIDITY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(soil.getAcidity().getDescription()).func_240699_a_(TextFormatting.DARK_GRAY);
        }

        private static ITextComponent tooltipNutrients(IAgriSoil soil) {
            return new StringTextComponent(" - ").func_230529_a_(NUTRIENTS).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(soil.getNutrients().getDescription()).func_240699_a_(TextFormatting.DARK_GRAY);
        }
    }

    public static interface SoilProperty {
        public ITextComponent getDescription();

        public List<String> getSynonyms();

        public boolean isValid();

        default public boolean isSynonym(String string) {
            return this.getSynonyms().stream().anyMatch(string::equalsIgnoreCase);
        }

        public String name();

        public int ordinal();
    }

    public static enum Nutrients implements SoilProperty
    {
        NONE("zero", "empty"),
        VERY_LOW("scarce", "poor"),
        LOW(new String[0]),
        MEDIUM("normal", "average"),
        HIGH("standard", "default"),
        VERY_HIGH("rich"),
        INVALID(new String[0]);

        private final ITextComponent textComponent = new TranslationTextComponent("agricraft.tooltip.nutrients." + this.name().toLowerCase());
        private final List<String> synonyms;

        private Nutrients(String ... synonyms) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.name());
            builder.add((Object[])synonyms);
            this.synonyms = builder.build();
        }

        @Override
        public ITextComponent getDescription() {
            return this.textComponent;
        }

        @Override
        public boolean isValid() {
            return this != INVALID;
        }

        @Override
        public List<String> getSynonyms() {
            return this.synonyms;
        }

        public static Optional<Nutrients> fromString(String string) {
            return Arrays.stream(Nutrients.values()).filter(value -> value.isSynonym(string)).findAny();
        }
    }

    public static enum Acidity implements SoilProperty
    {
        HIGHLY_ACIDIC("0", "1", "2", "highly-acidic", "highly acidic", "very-acidic", "very acidic", "very_acidic"),
        ACIDIC("3", "4", "5"),
        SLIGHTLY_ACIDIC("6", "slightly-acidic", "slightly acidic", "standard", "default"),
        NEUTRAL("7"),
        SLIGHTLY_ALKALINE("8", "slightly-alkaline", "slightly alkaline"),
        ALKALINE("9", "10", "11"),
        HIGHLY_ALKALINE("12", "13", "14", "highly-alkaline", "highly alkaline", "very-alkaline", "very alkaline", "very_alkaline"),
        INVALID(new String[0]);

        private final ITextComponent textComponent = new TranslationTextComponent("agricraft.tooltip.acidity." + this.name().toLowerCase());
        private final List<String> synonyms;

        private Acidity(String ... synonyms) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.name());
            builder.add((Object[])synonyms);
            this.synonyms = builder.build();
        }

        @Override
        public ITextComponent getDescription() {
            return this.textComponent;
        }

        @Override
        public boolean isValid() {
            return this != INVALID;
        }

        @Override
        public List<String> getSynonyms() {
            return this.synonyms;
        }

        public static Optional<Acidity> fromString(String string) {
            return Arrays.stream(Acidity.values()).filter(value -> value.isSynonym(string)).findAny();
        }
    }

    public static enum Humidity implements SoilProperty
    {
        ARID(new String[0]),
        DRY(new String[0]),
        DAMP("moist"),
        WET("standard", "default"),
        WATERY(new String[0]),
        FLOODED(new String[0]),
        INVALID(new String[0]);

        private final ITextComponent textComponent = new TranslationTextComponent("agricraft.tooltip.humidity." + this.name().toLowerCase());
        private final List<String> synonyms;

        private Humidity(String ... synonyms) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.name());
            builder.add((Object[])synonyms);
            this.synonyms = builder.build();
        }

        @Override
        public ITextComponent getDescription() {
            return this.textComponent;
        }

        @Override
        public boolean isValid() {
            return this != INVALID;
        }

        @Override
        public List<String> getSynonyms() {
            return this.synonyms;
        }

        public static Optional<Humidity> fromString(String string) {
            return Arrays.stream(Humidity.values()).filter(value -> value.isSynonym(string)).findAny();
        }
    }
}

