/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.stat;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public interface IAgriStatsMap {
    public int getValue(IAgriStat var1);

    default public int getGain() {
        return this.getValue(AgriApi.getStatRegistry().gainStat());
    }

    default public int getGrowth() {
        return this.getValue(AgriApi.getStatRegistry().growthStat());
    }

    default public int getStrength() {
        return this.getValue(AgriApi.getStatRegistry().strengthStat());
    }

    default public int getFertility() {
        return this.getValue(AgriApi.getStatRegistry().fertilityStat());
    }

    default public int getResistance() {
        return this.getValue(AgriApi.getStatRegistry().resistanceStat());
    }

    default public int getMutativity() {
        return this.getValue(AgriApi.getStatRegistry().mutativityStat());
    }

    default public int getSum() {
        int sum = 0;
        for (IAgriStat stat : AgriApi.getStatRegistry().all()) {
            sum += this.getValue(stat);
        }
        return sum;
    }

    default public double getAverage() {
        return ((double)this.getSum() + 0.0) / (double)AgriApi.getStatRegistry().count();
    }

    public boolean writeToNBT(@Nonnull CompoundNBT var1);

    public boolean readFromNBT(@Nonnull CompoundNBT var1);

    default public boolean equalStats(IAgriStatsMap other) {
        if (this == other) {
            return true;
        }
        for (IAgriStat stat : AgriApi.getStatRegistry().all()) {
            if (this.getValue(stat) == other.getValue(stat)) continue;
            return false;
        }
        return true;
    }

    default public void addTooltips(@Nonnull Consumer<ITextComponent> consumer) {
        AgriApi.getStatRegistry().stream().forEach(stat -> stat.addTooltip(consumer, this.getValue((IAgriStat)stat)));
    }
}

