/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.capability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.core.ItemDynamicAgriSeed;
import com.infinityraider.agricraft.content.tools.ItemSeedBag;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.infinitylib.capability.IInfSerializableCapabilityImplementation;
import com.infinityraider.infinitylib.utility.ISerializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class CapabilitySeedBagContents
implements IInfSerializableCapabilityImplementation<ItemStack, Impl> {
    private static final CapabilitySeedBagContents INSTANCE = new CapabilitySeedBagContents();
    public static ResourceLocation KEY = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "agri_seed_bag");
    @CapabilityInject(value=Impl.class)
    public static final Capability<Impl> CAPABILITY = null;

    public static CapabilitySeedBagContents getInstance() {
        return INSTANCE;
    }

    private CapabilitySeedBagContents() {
    }

    public Class<Impl> getCapabilityClass() {
        return Impl.class;
    }

    public Capability<Impl> getCapability() {
        return CAPABILITY;
    }

    public boolean shouldApplyCapability(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemSeedBag;
    }

    public Impl createNewValue(ItemStack stack) {
        return new Impl();
    }

    public ResourceLocation getCapabilityKey() {
        return KEY;
    }

    public Class<ItemStack> getCarrierClass() {
        return ItemStack.class;
    }

    public static class Impl
    implements ItemSeedBag.IContents,
    ISerializable {
        private IAgriPlant plant = NoPlant.getInstance();
        private final List<Entry> contents = Lists.newArrayList();
        private int count = 0;
        private final Map<Integer, Comparator<Entry>> sorters = Maps.newHashMap();
        private int sorterIndex;
        private Comparator<Entry> subSorter;
        private ItemStack firstStack;
        private ItemStack lastStack;

        private Impl() {
            this.setSorterIndex(0);
            this.firstStack = ItemStack.field_190927_a;
            this.lastStack = ItemStack.field_190927_a;
        }

        @Override
        public IAgriPlant getPlant() {
            return this.plant;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public boolean isFull() {
            return this.getCount() >= this.getCapacity();
        }

        @Override
        public ItemSeedBag.ISorter getSorter() {
            return ItemSeedBag.getSorter(this.getSorterIndex());
        }

        @Override
        public int getSorterIndex() {
            return this.sorterIndex;
        }

        @Override
        public void setSorterIndex(int index) {
            this.sorterIndex = index;
            this.subSorter = this.sorters.computeIfAbsent(index, value -> (a, b) -> this.getSorter().compare(a.getGenome(), b.getGenome()));
            this.sort();
        }

        protected void sort() {
            if (this.contents.size() > 0) {
                this.contents.sort(this.subSorter);
                this.firstStack = this.contents.get(0).initializeStack();
                this.firstStack = this.contents.get(this.contents.size() - 1).initializeStack();
            }
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return this.firstStack;
            }
            if (slot == 1) {
                return this.lastStack;
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isFull()) {
                return stack;
            }
            if (this.isItemValid(slot, stack)) {
                return ((ItemDynamicAgriSeed)stack.func_77973_b()).getGenome(stack).map(genome -> {
                    boolean flag = true;
                    int amount = Math.min(this.getCapacity() - this.getCount(), stack.func_190916_E());
                    if (amount <= 0) {
                        return stack;
                    }
                    for (Entry entry : this.contents) {
                        if (!entry.matches((IAgriGenome)genome)) continue;
                        flag = false;
                        if (simulate) break;
                        entry.add(amount);
                        this.count += amount;
                        break;
                    }
                    if (flag && !simulate) {
                        if (!this.plant.isPlant()) {
                            this.plant = ((ItemDynamicAgriSeed)stack.func_77973_b()).getPlant(stack);
                        }
                        this.contents.add(new Entry((IAgriGenome)genome, amount));
                        this.count += amount;
                        this.sort();
                    }
                    if (amount >= stack.func_190916_E()) {
                        return ItemStack.field_190927_a;
                    }
                    ItemStack result = stack.func_77946_l();
                    result.func_190920_e(result.func_190916_E() - amount);
                    return result;
                }).orElse(stack);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.contents.size() >= 1) {
                if (slot == 0) {
                    return this.extractFirstSeed(amount, simulate);
                }
                if (slot == 1) {
                    return this.extractLastSeed(amount, simulate);
                }
            }
            return ItemStack.field_190927_a;
        }

        @Override
        @Nonnull
        public ItemStack extractFirstSeed(int amount, boolean simulate) {
            if (this.firstStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack out = this.firstStack.func_77946_l();
            if (amount >= this.contents.get(0).getAmount()) {
                Entry entry = simulate ? this.contents.get(0) : this.contents.remove(0);
                out.func_190920_e(entry.getAmount());
                if (!simulate) {
                    this.count -= out.func_190916_E();
                    if (this.contents.size() > 0) {
                        this.firstStack = this.contents.get(0).initializeStack();
                    } else {
                        this.firstStack = ItemStack.field_190927_a;
                        this.lastStack = ItemStack.field_190927_a;
                        this.plant = NoPlant.getInstance();
                    }
                }
            } else {
                out.func_190920_e(amount);
                if (!simulate) {
                    this.contents.get(0).extract(amount);
                    this.count -= out.func_190916_E();
                }
            }
            return out;
        }

        @Override
        @Nonnull
        public ItemStack extractLastSeed(int amount, boolean simulate) {
            if (this.lastStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack out = this.lastStack.func_77946_l();
            if (amount >= this.contents.get(this.contents.size() - 1).getAmount()) {
                Entry entry = simulate ? this.contents.get(this.contents.size() - 1) : this.contents.remove(this.contents.size() - 1);
                out.func_190920_e(entry.getAmount());
                if (!simulate) {
                    this.count -= out.func_190916_E();
                    if (this.contents.size() > 0) {
                        this.lastStack = this.contents.get(this.contents.size() - 1).initializeStack();
                    } else {
                        this.firstStack = ItemStack.field_190927_a;
                        this.lastStack = ItemStack.field_190927_a;
                        this.plant = NoPlant.getInstance();
                    }
                }
            } else {
                out.func_190920_e(amount);
                if (!simulate) {
                    this.contents.get(this.contents.size() - 1).extract(amount);
                    this.count -= out.func_190916_E();
                }
            }
            return out;
        }

        @Override
        public int getCapacity() {
            return ((Config)AgriCraft.instance.getConfig()).seedBagCapacity();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            ItemDynamicAgriSeed seed;
            IAgriPlant stackPlant;
            if (stack.func_77973_b() instanceof ItemDynamicAgriSeed && (stackPlant = (seed = (ItemDynamicAgriSeed)stack.func_77973_b()).getPlant(stack)).isPlant()) {
                return !this.getPlant().isPlant() || this.getPlant() == stackPlant;
            }
            return false;
        }

        public void readFromNBT(CompoundNBT tag) {
            this.contents.clear();
            this.count = 0;
            this.firstStack = ItemStack.field_190927_a;
            this.lastStack = ItemStack.field_190927_a;
            IAgriPlant iAgriPlant = this.plant = tag.func_74764_b("agri_plant") ? AgriApi.getPlantRegistry().get(tag.func_74779_i("agri_plant")).orElse(NoPlant.getInstance()) : NoPlant.getInstance();
            if (this.getPlant().isPlant()) {
                if (tag.func_74764_b("agri_entries")) {
                    ListNBT entryTags = tag.func_150295_c("agri_entries", 10);
                    entryTags.stream().filter(entryTag -> entryTag instanceof CompoundNBT).map(entryTag -> (CompoundNBT)entryTag).forEach(entryTag -> Entry.readFromTag(entryTag).ifPresent(entry -> {
                        this.contents.add((Entry)entry);
                        this.count += entry.getAmount();
                    }));
                    if (this.count > 0) {
                        this.firstStack = this.contents.get(0).initializeStack();
                        this.lastStack = this.contents.get(this.contents.size() - 1).initializeStack();
                    }
                } else {
                    this.plant = NoPlant.getInstance();
                }
            }
            this.setSorterIndex(tag.func_74764_b("agri_key") ? tag.func_74762_e("agri_key") : 0);
        }

        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("agri_plant", this.getPlant().getId());
            ListNBT entryTags = new ListNBT();
            this.contents.forEach(entry -> entryTags.add((Object)entry.writeToTag()));
            tag.func_218657_a("agri_entries", (INBT)entryTags);
            tag.func_74768_a("agri_key", this.getSorterIndex());
            return tag;
        }

        private static class Entry {
            private final IAgriGenome genome;
            private int amount;

            protected Entry(IAgriGenome genome, int amount) {
                this.genome = genome;
                this.amount = amount;
            }

            public int getAmount() {
                return this.amount;
            }

            public IAgriGenome getGenome() {
                return this.genome;
            }

            public ItemStack initializeStack() {
                return this.genome.toSeedStack();
            }

            public void add(int amount) {
                this.amount += amount;
            }

            public void extract(int amount) {
                this.amount -= amount;
                this.amount = Math.max(this.amount, 0);
            }

            public boolean matches(IAgriGenome genome) {
                return this.getGenome().equals(genome);
            }

            public CompoundNBT writeToTag() {
                CompoundNBT tag = new CompoundNBT();
                CompoundNBT genomeTag = new CompoundNBT();
                this.getGenome().writeToNBT(genomeTag);
                tag.func_218657_a("agri_genome", (INBT)genomeTag);
                tag.func_74768_a("agri_entries", this.getAmount());
                return tag;
            }

            public static Optional<Entry> readFromTag(CompoundNBT tag) {
                if (!tag.func_74764_b("agri_genome") || !tag.func_74764_b("agri_entries")) {
                    return Optional.empty();
                }
                IAgriGenome genome = AgriApi.getAgriGenomeBuilder(NoPlant.getInstance()).build();
                if (!genome.readFromNBT(tag.func_74775_l("agri_genome"))) {
                    return Optional.empty();
                }
                int count = tag.func_74762_e("agri_entries");
                return Optional.of(new Entry(genome, count));
            }
        }
    }
}

