/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizable;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.content.core.TileEntityCropBase;
import com.infinityraider.infinitylib.block.BlockBaseTile;
import com.infinityraider.infinitylib.block.IFluidLoggable;
import com.infinityraider.infinitylib.block.property.InfProperty;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class BlockCropBase<T extends TileEntityCropBase>
extends BlockBaseTile<T>
implements IFluidLoggable,
IGrowable,
IPlantable {
    public static final InfProperty<Boolean> PLANT = InfProperty.Creators.create((String)"plant", (boolean)false);
    public static final InfProperty<Integer> LIGHT = InfProperty.Creators.create((String)"light", (int)0, (int)0, (int)16);
    private static final ItemStack BONE_MEAL = new ItemStack((IItemProvider)Items.field_196106_bc);

    public BlockCropBase(String name, AbstractBlock.Properties properties) {
        super(name, properties);
    }

    public Optional<IAgriCrop> getCrop(IBlockReader world, BlockPos pos) {
        return AgriApi.getCrop(world, pos);
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220071_b(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_230322_a_(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (fromPos.func_177984_a().equals((Object)pos) && !state.func_196955_c((IWorldReader)world, pos)) {
            this.breakBlock(state, world, pos, true);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    @Deprecated
    public void func_196243_a(BlockState oldState, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        Fluid newFluid;
        Fluid oldFluid;
        if (oldState.func_177230_c() == newState.func_177230_c() && (oldFluid = this.func_204507_t(oldState).func_206886_c()) != (newFluid = this.func_204507_t(newState).func_206886_c()) && this.onFluidChanged(world, pos, newState, oldFluid, newFluid)) {
            return;
        }
        super.func_196243_a(oldState, world, pos, newState, isMoving);
    }

    protected abstract boolean onFluidChanged(World var1, BlockPos var2, BlockState var3, Fluid var4, Fluid var5);

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState current = world.func_180495_p(pos);
        return current.func_185904_a().func_76222_j() && AgriApi.getSoil((IBlockReader)world, pos.func_177977_b()).isPresent();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement(context.func_195991_k(), context.func_195995_a());
    }

    @Nullable
    public BlockState getStateForPlacement(World world, BlockPos pos) {
        BlockState state = this.func_176223_P();
        if (state.func_196955_c((IWorldReader)world, pos)) {
            return this.fluidlog(state, world, pos);
        }
        return null;
    }

    public void breakBlock(BlockState state, World world, BlockPos pos, boolean doDrops) {
        if (!world.func_201670_d()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            if (doDrops) {
                BlockCropBase.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
            }
        }
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.getCrop((IBlockReader)world, pos).ifPresent(IAgriFertilizable::applyGrowthTick);
    }

    @Deprecated
    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        this.getCrop((IBlockReader)world, pos).ifPresent(crop -> crop.breakCrop((LivingEntity)player));
    }

    @Deprecated
    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        this.getCrop((IBlockReader)world, pos).ifPresent(crop -> crop.getPlant().onEntityCollision((IAgriCrop)crop, entity));
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return (Boolean)PLANT.fetch(state);
    }

    @Deprecated
    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.func_176211_b(state, world, pos, side);
    }

    @Deprecated
    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return (Boolean)PLANT.fetch(state) != false ? this.getCrop(world, pos).map(crop -> crop.getPlant().getRedstonePower((IAgriCrop)crop)).orElse(0) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderType getRenderType() {
        return RenderType.func_228643_e_();
    }

    public void spawnItem(IAgriCrop crop, ItemStack stack) {
        World world = crop.world();
        if (world != null) {
            this.spawnItem(world, crop.getPosition(), stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        this.getCrop((IBlockReader)world, pos).ifPresent(crop -> {
            if (crop.hasPlant()) {
                crop.getPlant().spawnParticles((IAgriCrop)crop, rand);
            }
        });
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.getCrop(world, pos).map(crop -> crop.isFertile() && !crop.isFullyGrown()).orElse(true);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return AgriApi.getFertilizerAdapterizer().valueOf(BONE_MEAL).flatMap(fertilizer -> this.getCrop((IBlockReader)world, pos).map(crop -> !crop.isFullyGrown() && crop.acceptsFertilizer((IAgriFertilizer)fertilizer))).orElse(false);
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        AgriApi.getFertilizerAdapterizer().valueOf(BONE_MEAL).ifPresent(fertilizer -> this.getCrop((IBlockReader)world, pos).ifPresent(crop -> fertilizer.applyFertilizer((World)world, pos, (IAgriFertilizable)crop, BONE_MEAL, rand, null)));
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (world instanceof World) {
            return this.getCrop(world, pos).flatMap(crop -> crop.getPlant().asBlockState(crop.getGrowthStage())).orElse(state);
        }
        return state;
    }
}

