/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.content.core.BlockCropBase;
import com.infinityraider.agricraft.content.core.BlockCropSticks;
import com.infinityraider.agricraft.content.core.CropStickVariant;
import com.infinityraider.agricraft.content.core.TileEntityCropPlant;
import com.infinityraider.agricraft.content.core.TileEntityCropSticks;
import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.item.BlockItemBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemCropSticks
extends BlockItemBase {
    private final CropStickVariant variant;

    public ItemCropSticks(CropStickVariant variant) {
        super((IInfinityBlock)variant.getBlock(), new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT));
        this.variant = variant;
    }

    public CropStickVariant getVariant() {
        return this.variant;
    }

    public void func_219972_a(@Nonnull World world, @Nonnull LivingEntity entity, @Nonnull ItemStack stack, int count) {
        super.func_219972_a(world, entity, stack, count);
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        BlockState state = world.func_180495_p(pos);
        if (tile instanceof TileEntityCropPlant) {
            return this.placeCropSticksOnPlant(world, pos, context.func_195999_j(), context.func_221531_n(), (TileEntityCropPlant)tile, state);
        }
        if (tile instanceof TileEntityCropSticks) {
            return this.tryMakeCrossCrop(world, pos, context.func_195999_j(), context.func_221531_n(), (TileEntityCropSticks)tile);
        }
        pos = pos.func_177972_a(context.func_196000_l());
        tile = world.func_175625_s(pos);
        state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos) || state.func_204520_s().func_206886_c() == Fluids.field_204546_a) {
            return this.placeCropSticksOnSoil(world, pos, new BlockItemUseContext(context));
        }
        if (tile instanceof TileEntityCropPlant) {
            return this.placeCropSticksOnPlant(world, pos, context.func_195999_j(), context.func_221531_n(), (TileEntityCropPlant)tile, state);
        }
        if (tile instanceof TileEntityCropSticks) {
            return this.tryMakeCrossCrop(world, pos, context.func_195999_j(), context.func_221531_n(), (TileEntityCropSticks)tile);
        }
        return ActionResultType.FAIL;
    }

    protected ActionResultType placeCropSticksOnSoil(World world, BlockPos pos, BlockItemUseContext context) {
        BlockState newState = this.getVariant().getBlock().func_196258_a(context);
        if (newState == null) {
            return ActionResultType.FAIL;
        }
        boolean success = world.func_175656_a(pos, newState);
        if (!success) {
            AgriCore.getCoreLogger().debug("ItemCrop#onItemUse failed to create the BlockCrop!", new Object[0]);
            return ActionResultType.FAIL;
        }
        this.consumeItem(context.func_195999_j(), context.func_221531_n());
        this.playPlacementSound(world, pos);
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType placeCropSticksOnPlant(World world, BlockPos pos, @Nullable PlayerEntity player, Hand hand, TileEntityCropPlant plant, BlockState state) {
        BlockState newState = this.getVariant().getBlock().func_176223_P();
        newState = BlockCropBase.PLANT.mimic(state, newState);
        newState = BlockCropBase.LIGHT.mimic(state, newState);
        newState = InfProperty.Defaults.waterlogged().mimic(state, newState);
        world.func_175656_a(pos, newState);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityCropSticks)) {
            world.func_175656_a(pos, state);
            return ActionResultType.FAIL;
        }
        ((TileEntityCropSticks)tile).mimicFrom(plant);
        this.consumeItem(player, hand);
        this.playPlacementSound(world, pos);
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType tryMakeCrossCrop(World world, BlockPos pos, @Nullable PlayerEntity player, Hand hand, TileEntityCropSticks crop) {
        if (!crop.hasPlant() && !crop.hasWeeds() & !crop.isCrossCrop() && ((BlockCropSticks)crop.func_195044_w().func_177230_c()).isVariant(this)) {
            crop.setCrossCrop(true);
            this.consumeItem(player, hand);
            this.playPlacementSound(world, pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected void consumeItem(@Nullable PlayerEntity player, Hand hand) {
        if (player != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
    }

    protected void playPlacementSound(World world, BlockPos pos) {
        SoundType type = this.getVariant().getSound();
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), type.func_185841_e(), SoundCategory.PLAYERS, (type.func_185843_a() + 1.0f) / 4.0f, type.func_185847_b() * 0.8f);
    }
}

