/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.render.items.JournalRenderer;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.render.item.InfItemRenderer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemJournal
extends ItemBase
implements IAgriJournalItem {
    public ItemJournal() {
        super("agri_journal", new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT).func_200917_a(1));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (world.func_201670_d() && ((IProxy)AgriCraft.instance.proxy()).toggleJournalObserving(stack, hand)) {
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @Override
    public boolean isPlantDiscovered(@Nonnull ItemStack journal, @Nullable IAgriPlant plant) {
        return plant != null && this.getTag(journal).func_150295_c("agri_entries", 10).stream().filter(tag -> tag instanceof CompoundNBT).map(tag -> (CompoundNBT)tag).map(tag -> AgriApi.getPlantRegistry().get(tag.func_74779_i("agri_plant"))).filter(Optional::isPresent).map(Optional::get).anyMatch(entry -> entry.equals(plant));
    }

    @Override
    public void addEntry(@Nonnull ItemStack journal, @Nullable IAgriPlant plant) {
        if (plant == null) {
            return;
        }
        if (!this.isPlantDiscovered(journal, plant)) {
            CompoundNBT tag = this.getTag(journal);
            ListNBT listTag = tag.func_150295_c("agri_entries", 10);
            CompoundNBT plantTag = new CompoundNBT();
            plantTag.func_74778_a("agri_plant", plant.getId());
            listTag.add((Object)plantTag);
            tag.func_218657_a("agri_entries", (INBT)listTag);
        }
    }

    @Override
    @Nonnull
    public List<IAgriPlant> getDiscoveredSeeds(@Nonnull ItemStack journal) {
        return this.getTag(journal).func_150295_c("agri_entries", 10).stream().filter(tag -> tag instanceof CompoundNBT).map(tag -> (CompoundNBT)tag).map(tag -> AgriApi.getPlantRegistry().get(tag.func_74779_i("agri_plant"))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Nonnull
    protected CompoundNBT getTag(ItemStack journal) {
        CompoundNBT tag = journal.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            journal.func_77982_d(tag);
        }
        if (!tag.func_74764_b("agri_entries")) {
            tag.func_218657_a("agri_entries", (INBT)new ListNBT());
        }
        return tag;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfItemRenderer getItemRenderer() {
        return JournalRenderer.getInstance();
    }
}

