/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.decoration;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.items.IAgriClipperItem;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.decoration.ItemGrate;
import com.infinityraider.agricraft.content.decoration.TileEntityGrate;
import com.infinityraider.infinitylib.block.BlockDynamicTexture;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockGrate
extends BlockDynamicTexture<TileEntityGrate> {
    public static final InfProperty<Direction.Axis> AXIS = InfProperty.Creators.create((String)"direction", (Direction.Axis)Direction.Axis.X);
    public static final InfProperty<Offset> OFFSET = InfProperty.Creators.create((String)"offset", Offset.class, (Enum)Offset.MID);
    public static final InfProperty<Vines> VINES = InfProperty.Creators.create((String)"vines", Vines.class, (Enum)Vines.NONE);
    private static final InfPropertyConfiguration PROPERTIES = InfPropertyConfiguration.builder().add(AXIS).add(OFFSET).add(VINES).waterloggable().build();
    private static final BiFunction<BlockState, IBlockReader, TileEntityGrate> TILE_FACTORY = (s, w) -> new TileEntityGrate();
    public static final VoxelShape X_DEFAULT = Stream.of(Block.func_208617_a((double)7.0, (double)1.0, (double)0.0, (double)9.0, (double)3.0, (double)16.0), Block.func_208617_a((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)16.0), Block.func_208617_a((double)7.0, (double)9.0, (double)0.0, (double)9.0, (double)11.0, (double)16.0), Block.func_208617_a((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)16.0), Block.func_208617_a((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)16.0, (double)3.0), Block.func_208617_a((double)7.0, (double)0.0, (double)5.0, (double)9.0, (double)16.0, (double)7.0), Block.func_208617_a((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0, (double)11.0), Block.func_208617_a((double)7.0, (double)0.0, (double)13.0, (double)9.0, (double)16.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape X_NEAR = X_DEFAULT.func_197751_a(Offset.NEAR.getOffset(), 0.0, 0.0);
    public static final VoxelShape X_FAR = X_DEFAULT.func_197751_a(Offset.FAR.getOffset(), 0.0, 0.0);
    public static final VoxelShape[] X_SHAPES = new VoxelShape[]{X_NEAR, X_DEFAULT, X_FAR};
    public static final VoxelShape Y_DEFAULT = Stream.of(Block.func_208617_a((double)1.0, (double)7.0, (double)0.0, (double)3.0, (double)9.0, (double)16.0), Block.func_208617_a((double)5.0, (double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0), Block.func_208617_a((double)9.0, (double)7.0, (double)0.0, (double)11.0, (double)9.0, (double)16.0), Block.func_208617_a((double)13.0, (double)7.0, (double)0.0, (double)15.0, (double)9.0, (double)16.0), Block.func_208617_a((double)0.0, (double)7.0, (double)1.0, (double)16.0, (double)9.0, (double)3.0), Block.func_208617_a((double)0.0, (double)7.0, (double)5.0, (double)16.0, (double)9.0, (double)7.0), Block.func_208617_a((double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0, (double)11.0), Block.func_208617_a((double)0.0, (double)7.0, (double)13.0, (double)16.0, (double)9.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape Y_NEAR = Y_DEFAULT.func_197751_a(0.0, Offset.NEAR.getOffset(), 0.0);
    public static final VoxelShape Y_FAR = Y_DEFAULT.func_197751_a(0.0, Offset.FAR.getOffset(), 0.0);
    public static final VoxelShape[] Y_SHAPES = new VoxelShape[]{Y_NEAR, Y_DEFAULT, Y_FAR};
    public static final VoxelShape Z_DEFAULT = Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)7.0, (double)3.0, (double)16.0, (double)9.0), Block.func_208617_a((double)5.0, (double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0), Block.func_208617_a((double)9.0, (double)0.0, (double)7.0, (double)11.0, (double)16.0, (double)9.0), Block.func_208617_a((double)13.0, (double)0.0, (double)7.0, (double)15.0, (double)16.0, (double)9.0), Block.func_208617_a((double)0.0, (double)1.0, (double)7.0, (double)16.0, (double)3.0, (double)9.0), Block.func_208617_a((double)0.0, (double)5.0, (double)7.0, (double)16.0, (double)7.0, (double)9.0), Block.func_208617_a((double)0.0, (double)9.0, (double)7.0, (double)16.0, (double)11.0, (double)9.0), Block.func_208617_a((double)0.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape Z_NEAR = Z_DEFAULT.func_197751_a(0.0, 0.0, Offset.NEAR.getOffset());
    public static final VoxelShape Z_FAR = Z_DEFAULT.func_197751_a(0.0, 0.0, Offset.FAR.getOffset());
    public static final VoxelShape[] Z_SHAPES = new VoxelShape[]{Z_NEAR, Z_DEFAULT, Z_FAR};

    protected static VoxelShape getShape(Direction.Axis axis, Offset offset) {
        switch (axis) {
            case X: {
                return BlockGrate.getShape(X_SHAPES, offset);
            }
            case Y: {
                return BlockGrate.getShape(Y_SHAPES, offset);
            }
            case Z: {
                return BlockGrate.getShape(Z_SHAPES, offset);
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public BlockGrate() {
        super("grate", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_());
    }

    protected InfPropertyConfiguration getPropertyConfiguration() {
        return PROPERTIES;
    }

    public BiFunction<BlockState, IBlockReader, TileEntityGrate> getTileEntityFactory() {
        return TILE_FACTORY;
    }

    @Nonnull
    public ItemGrate asItem() {
        return AgriCraft.instance.getModItemRegistry().grate;
    }

    public void onBlockPlacedBy(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack, @Nullable TileEntity tile) {
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState current = world.func_180495_p(pos);
        return current.func_185904_a().func_76222_j();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        if (state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
            double offset;
            BlockPos clicked = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
            BlockState target = context.func_195991_k().func_180495_p(clicked);
            if (target.func_177230_c() instanceof BlockGrate && context.func_196000_l().func_176740_k() != AXIS.fetch(target)) {
                return AXIS.apply(OFFSET.apply(this.fluidlog(state, context.func_195991_k(), context.func_195995_a()), OFFSET.fetch(target)), AXIS.fetch(target));
            }
            Vector3d hit = context.func_221532_j();
            if (context.func_196000_l().func_176740_k() == Direction.Axis.Y) {
                if (context.func_195992_f().func_176740_k() == Direction.Axis.X) {
                    state = AXIS.apply(state, (Comparable)Direction.Axis.X);
                    offset = hit.func_82615_a() - (double)((int)hit.func_82615_a());
                } else {
                    state = AXIS.apply(state, (Comparable)Direction.Axis.Z);
                    offset = hit.func_82616_c() - (double)((int)hit.func_82616_c());
                }
            } else {
                state = AXIS.apply(state, (Comparable)Direction.Axis.Y);
                offset = hit.func_82617_b() - (double)((int)hit.func_82617_b());
            }
            offset += offset < 0.0 ? 1.0 : 0.0;
            if (offset >= 0.6875) {
                return OFFSET.apply(this.fluidlog(state, context.func_195991_k(), context.func_195995_a()), (Comparable)((Object)Offset.FAR));
            }
            if (offset <= 0.3125) {
                return OFFSET.apply(this.fluidlog(state, context.func_195991_k(), context.func_195995_a()), (Comparable)((Object)Offset.NEAR));
            }
            return OFFSET.apply(this.fluidlog(state, context.func_195991_k(), context.func_195995_a()), (Comparable)((Object)Offset.MID));
        }
        return null;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack item;
        if (!world.func_201670_d() && !(item = player.func_184586_b(hand)).func_190926_b()) {
            Vines vines;
            if (item.func_77973_b() == Items.field_221796_dh) {
                Vines vines2 = (Vines)((Object)VINES.fetch(state));
                if (!vines2.hasVines(hit)) {
                    world.func_175656_a(pos, VINES.apply(state, (Comparable)((Object)vines2.addVines(hit))));
                    if (!player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                }
            } else if (item.func_77973_b() instanceof IAgriClipperItem && (vines = (Vines)((Object)VINES.fetch(state))).hasVines(hit)) {
                world.func_175656_a(pos, VINES.apply(state, (Comparable)((Object)vines.removeVines(hit))));
                if (!player.func_184812_l_()) {
                    this.addToInventoryOrDrop(new ItemStack((IItemProvider)Items.field_221796_dh, 1), world, pos, player);
                }
            }
        }
        return ActionResultType.PASS;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return ((Config)AgriCraft.instance.getConfig()).areGratesClimbable() && AXIS.fetch(state) != Direction.Axis.Y;
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220071_b(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_230322_a_(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BlockGrate.getShape((Direction.Axis)AXIS.fetch(state), (Offset)((Object)OFFSET.fetch(state)));
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    protected static VoxelShape getShape(VoxelShape[] shapes, Offset offset) {
        return shapes[offset.ordinal()];
    }

    public void addDrops(Consumer<ItemStack> dropAcceptor, BlockState state, TileEntityGrate tile, LootContext.Builder context) {
        int vineCount = ((Vines)((Object)VINES.fetch(state))).getVineCount();
        if (vineCount > 0) {
            dropAcceptor.accept(new ItemStack((IItemProvider)Items.field_221796_dh, vineCount));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderType getRenderType() {
        return RenderType.func_228643_e_();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getColor() {
        return (state, reader, pos, color) -> {
            if (color == 0) {
                return 0xFFFFFF;
            }
            return reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c();
        };
    }

    public static enum Vines implements IStringSerializable
    {
        NONE(0),
        FRONT(1),
        BACK(1),
        BOTH(2);

        private final int vineCount;

        private Vines(int vineCount) {
            this.vineCount = vineCount;
        }

        public int getVineCount() {
            return this.vineCount;
        }

        public boolean hasVines(BlockRayTraceResult hit) {
            return this.hasVines(hit.func_216354_b().func_176734_d());
        }

        public boolean hasVines(Direction direction) {
            return this.hasVines(direction.func_176743_c());
        }

        public boolean hasVines(Direction.AxisDirection direction) {
            switch (this) {
                case FRONT: {
                    return direction == Direction.AxisDirection.POSITIVE;
                }
                case BACK: {
                    return direction == Direction.AxisDirection.NEGATIVE;
                }
                case BOTH: {
                    return true;
                }
            }
            return false;
        }

        public Vines addVines(BlockRayTraceResult hit) {
            return this.addVines(hit.func_216354_b().func_176734_d());
        }

        public Vines addVines(Direction direction) {
            return this.addVines(direction.func_176743_c());
        }

        public Vines addVines(Direction.AxisDirection direction) {
            switch (this) {
                case NONE: {
                    return direction == Direction.AxisDirection.POSITIVE ? FRONT : BACK;
                }
                case FRONT: {
                    return direction == Direction.AxisDirection.POSITIVE ? FRONT : BOTH;
                }
                case BACK: {
                    return direction == Direction.AxisDirection.POSITIVE ? BOTH : BACK;
                }
            }
            return BOTH;
        }

        public Vines removeVines(BlockRayTraceResult hit) {
            return this.removeVines(hit.func_216354_b().func_176734_d());
        }

        public Vines removeVines(Direction direction) {
            return this.removeVines(direction.func_176743_c());
        }

        public Vines removeVines(Direction.AxisDirection direction) {
            switch (this) {
                case FRONT: {
                    return direction == Direction.AxisDirection.POSITIVE ? NONE : FRONT;
                }
                case BACK: {
                    return direction == Direction.AxisDirection.POSITIVE ? BACK : NONE;
                }
                case BOTH: {
                    return direction == Direction.AxisDirection.POSITIVE ? BACK : FRONT;
                }
            }
            return NONE;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static enum Offset implements IStringSerializable
    {
        NEAR(-0.436875),
        MID(0.0),
        FAR(0.436875);

        private final double offset;

        private Offset(double offset) {
            this.offset = offset;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public double getOffset() {
            return this.offset;
        }
    }
}

