/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.tools;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.network.MessageMagnifyingGlassObserving;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.reference.AgriToolTips;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMagnifyingGlass
extends ItemBase {
    private static final Map<UUID, Boolean> observers = Maps.newIdentityHashMap();

    public static boolean isObserving(PlayerEntity player) {
        return player != null && observers.computeIfAbsent(player.func_110124_au(), uuid -> false) != false;
    }

    public static void setObserving(PlayerEntity player, boolean status) {
        if (player != null) {
            observers.put(player.func_110124_au(), status);
            if (!player.func_130014_f_().func_201670_d()) {
                MessageMagnifyingGlassObserving.sendToClient(player, status);
            }
        }
    }

    public ItemMagnifyingGlass() {
        super("agri_magnifying_glass", new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT).func_200917_a(1));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().func_201670_d()) {
            ((IProxy)AgriCraft.instance.proxy()).toggleMagnifyingGlassObserving(context.func_221531_n());
        }
        return ActionResultType.FAIL;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (world.func_201670_d()) {
            ((IProxy)AgriCraft.instance.proxy()).toggleMagnifyingGlassObserving(hand);
        }
        return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        tooltip.add(AgriToolTips.MAGNIFYING_GLASS);
    }
}

