/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.tools;

import com.google.common.collect.Lists;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.event.AgriCropEvent;
import com.infinityraider.agricraft.api.v1.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemRake
extends ItemBase
implements IAgriRakeItem {
    public static RakeLogic WOOD_LOGIC = new RakeLogic("agri_rake_wood"){

        @Override
        public boolean doRakeAction(IAgriCrop crop, ItemStack stack, @Nullable PlayerEntity player) {
            IAgriGrowthStage previous;
            if (crop.world() == null || crop.world().func_201670_d()) {
                return false;
            }
            if (!crop.hasWeeds()) {
                return false;
            }
            IAgriWeed weeds = crop.getWeeds();
            IAgriGrowthStage current = crop.getWeedGrowthStage();
            if (current.equals(previous = current.getPreviousStage(crop, crop.world().func_201674_k()))) {
                return crop.removeWeed();
            }
            return crop.setWeed(weeds, previous);
        }
    };
    public static RakeLogic IRON_LOGIC = new RakeLogic("agri_rake_iron"){

        @Override
        public boolean doRakeAction(IAgriCrop crop, ItemStack stack, @Nullable PlayerEntity player) {
            if (crop.world() == null || crop.world().func_201670_d()) {
                return false;
            }
            if (!crop.hasWeeds()) {
                return false;
            }
            return crop.removeWeed();
        }
    };
    private final RakeLogic logic;

    public ItemRake(RakeLogic logic) {
        super(logic.getName(), new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT).func_200917_a(1));
        this.logic = logic;
    }

    protected RakeLogic getRakeLogic() {
        return this.logic;
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        return AgriApi.getCrop((IBlockReader)context.func_195991_k(), context.func_195995_a()).map(crop -> this.getRakeLogic().applyLogic((IAgriCrop)crop, context.func_195996_i(), context.func_195999_j())).orElse(ActionResultType.FAIL);
    }

    public static abstract class RakeLogic {
        private final String name;

        public RakeLogic(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public final ActionResultType applyLogic(IAgriCrop crop, ItemStack stack, @Nullable PlayerEntity player) {
            if (crop.world() == null || crop.world().func_201670_d()) {
                return ActionResultType.PASS;
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Rake.Pre(crop, stack, (LivingEntity)player))) {
                IAgriWeed weeds = crop.getWeeds();
                IAgriGrowthStage stage = crop.getWeedGrowthStage();
                if (this.doRakeAction(crop, stack, player)) {
                    ArrayList drops = Lists.newArrayList();
                    weeds.onRake(stage, drops::add, crop.world().func_201674_k(), (LivingEntity)player);
                    AgriCropEvent.Rake.Post event = new AgriCropEvent.Rake.Post(crop, stack, drops, (LivingEntity)player);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    event.getDrops().forEach(crop::dropItem);
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.FAIL;
        }

        protected abstract boolean doRakeAction(IAgriCrop var1, ItemStack var2, @Nullable PlayerEntity var3);
    }
}

