/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.tools;

import com.google.common.collect.Lists;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.capability.CapabilitySeedBagContents;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.content.core.ItemDynamicAgriSeed;
import com.infinityraider.agricraft.content.core.TileEntityCropSticks;
import com.infinityraider.agricraft.content.tools.EnchantmentSeedBag;
import com.infinityraider.agricraft.impl.v1.genetics.AgriGeneRegistry;
import com.infinityraider.agricraft.impl.v1.genetics.GeneSpecies;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.reference.AgriToolTips;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class ItemSeedBag
extends ItemBase {
    private static final ITextComponent NAME_DEACTIVATED = new TranslationTextComponent("item.agricraft.agri_seed_bag_inactive");
    private static final List<ISorter> sorters = Lists.newArrayList();
    public static final ISorter DEFAULT_SORTER = new ISorter(){

        @Override
        public ITextComponent getName() {
            return AgriToolTips.SEED_BAG_SORTER_DEFAULT;
        }

        @Override
        public int compare(IAgriGenome o1, IAgriGenome o2) {
            int s2;
            int s1 = o1.getStats().getSum();
            if (s1 != (s2 = o2.getStats().getSum())) {
                return s1 - s2;
            }
            return AgriGeneRegistry.getInstance().stream().filter(gene -> !(gene instanceof GeneSpecies)).mapToInt(gene -> {
                int w = gene.getComparatorWeight();
                int d1 = o1.getGenePair(gene).getDominant().comparatorValue();
                int r1 = o1.getGenePair(gene).getRecessive().comparatorValue();
                int d2 = o2.getGenePair(gene).getDominant().comparatorValue();
                int r2 = o2.getGenePair(gene).getRecessive().comparatorValue();
                return w * (d1 + r1 - (d2 + r2));
            }).sum();
        }
    };
    private static final IContents EMPTY = new IContents(){

        @Override
        public IAgriPlant getPlant() {
            return NoPlant.getInstance();
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public ISorter getSorter() {
            return DEFAULT_SORTER;
        }

        @Override
        public int getSorterIndex() {
            return 0;
        }

        @Override
        public void setSorterIndex(int index) {
        }

        @Override
        public ItemStack extractFirstSeed(int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack extractLastSeed(int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Override
        public int getCapacity() {
            return 0;
        }

        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    };

    public static ISorter getSorter(int index) {
        return sorters.get(index % sorters.size());
    }

    public static int addSorter(ISorter sorter) {
        if (sorters.contains(sorter)) {
            return sorters.indexOf(sorter);
        }
        sorters.add(sorter);
        return sorters.size() - 1;
    }

    public static int addSorter(IAgriStat stat) {
        return ItemSeedBag.addSorter(new StatSorter(stat));
    }

    public ItemSeedBag() {
        super("agri_seed_bag", new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT).func_200917_a(1));
    }

    public IContents getContents(ItemStack stack) {
        return CapabilitySeedBagContents.getInstance().getCapability((ICapabilityProvider)stack).map(impl -> impl).orElse(EMPTY);
    }

    public boolean isActivated(ItemStack stack) {
        return EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey((Object)AgriCraft.instance.getModEnchantmentRegistry().seed_bag);
    }

    public boolean incrementSorter(ItemStack stack, int delta) {
        if (this.isActivated(stack)) {
            IContents contents = this.getContents(stack);
            int newPos = contents.getSorterIndex() + delta;
            newPos = newPos < 0 ? newPos + sorters.size() : newPos % sorters.size();
            contents.setSorterIndex(newPos);
            return true;
        }
        return false;
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        IContents contents = this.getContents(context.func_195996_i());
        if (this.isActivated(context.func_195996_i())) {
            Hand hand = context.func_221531_n();
            PlayerEntity player = context.func_195999_j();
            if (hand == Hand.OFF_HAND ? player != null && this.attemptExtractOrInsertSeed(player, contents) : this.attemptPlantSeed(context.func_195991_k(), context.func_195995_a(), contents, player)) {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (hand == Hand.OFF_HAND) {
            ItemStack stack = player.func_184586_b(hand);
            IContents contents = this.getContents(stack);
            if (this.isActivated(stack) && this.attemptExtractOrInsertSeed(player, contents)) {
                return ActionResult.func_226248_a_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    protected boolean attemptPlantSeed(World world, BlockPos pos, IContents contents, @Nullable PlayerEntity player) {
        if (contents.getCount() > 0) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityCropSticks) {
                if (this.attemptPlantOnCrops((TileEntityCropSticks)tile, contents.extractFirstSeed(1, true), player)) {
                    contents.extractFirstSeed(1, false);
                    return true;
                }
            } else {
                BlockPos up = pos.func_177984_a();
                tile = world.func_175625_s(up);
                if (tile instanceof TileEntityCropSticks) {
                    if (this.attemptPlantOnCrops((TileEntityCropSticks)tile, contents.extractFirstSeed(1, true), player)) {
                        contents.extractFirstSeed(1, false);
                        return true;
                    }
                } else if (tile == null && ((Config)AgriCraft.instance.getConfig()).allowPlantingOutsideCropSticks() && this.attemptPlantOnSoil(world, pos, contents.extractFirstSeed(1, true), player)) {
                    contents.extractFirstSeed(1, false);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean attemptPlantOnCrops(IAgriCrop crop, ItemStack seedStack, @Nullable PlayerEntity player) {
        return AgriApi.getGenomeAdapterizer().valueOf(seedStack).map(seed -> crop.plantGenome((IAgriGenome)seed, (LivingEntity)player)).orElse(false);
    }

    protected boolean attemptPlantOnSoil(World world, BlockPos pos, ItemStack seedStack, @Nullable PlayerEntity player) {
        BlockPos up = pos.func_177984_a();
        return AgriApi.getSoil((IBlockReader)world, pos).map(soil -> {
            BlockState newState = AgriCraft.instance.getModBlockRegistry().crop_plant.getStateForPlacement(world, up);
            if (newState != null && world.func_180501_a(up, newState, 11)) {
                boolean success = AgriApi.getCrop((IBlockReader)world, up).map(crop -> this.attemptPlantOnCrops((IAgriCrop)crop, seedStack, player)).orElse(false);
                if (success) {
                    return true;
                }
                world.func_175656_a(up, Blocks.field_150350_a.func_176223_P());
            }
            return false;
        }).orElse(false);
    }

    protected boolean attemptExtractOrInsertSeed(PlayerEntity player, IContents contents) {
        ItemStack remaining;
        ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
        if (held.func_190926_b()) {
            boolean last = player.func_225608_bj_();
            if (last) {
                ItemStack out = contents.extractLastSeed(1, true);
                if (!out.func_190926_b()) {
                    player.func_184611_a(Hand.MAIN_HAND, contents.extractLastSeed(1, false));
                    return true;
                }
            } else {
                ItemStack out = contents.extractFirstSeed(1, true);
                if (!out.func_190926_b()) {
                    player.func_184611_a(Hand.MAIN_HAND, contents.extractFirstSeed(1, false));
                    return true;
                }
            }
        } else if (held.func_77973_b() instanceof ItemDynamicAgriSeed && ((remaining = contents.insertSeed(held, true)).func_190926_b() || remaining.func_190916_E() != held.func_190916_E())) {
            player.func_184611_a(Hand.MAIN_HAND, contents.insertSeed(held, false));
            return true;
        }
        return false;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return !this.isActivated(stack);
    }

    public int func_77619_b() {
        return 1;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.isActivated(stack) ? 0 : 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment instanceof EnchantmentSeedBag;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return this.isActivated(stack) ? super.func_200295_i(stack) : NAME_DEACTIVATED;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
    }

    static {
        ItemSeedBag.addSorter(DEFAULT_SORTER);
    }

    public static class StatSorter
    implements ISorter {
        private final IAgriStat stat;

        protected StatSorter(IAgriStat stat) {
            this.stat = stat;
        }

        public IAgriStat getStat() {
            return this.stat;
        }

        @Override
        public ITextComponent getName() {
            return this.getStat().getDescription();
        }

        @Override
        public int compare(IAgriGenome o1, IAgriGenome o2) {
            int s2;
            int s1 = o1.getStats().getValue(this.getStat());
            if (s1 == (s2 = o2.getStats().getValue(this.getStat()))) {
                return DEFAULT_SORTER.compare(o1, o2);
            }
            return s1 - s2;
        }
    }

    public static interface ISorter
    extends Comparator<IAgriGenome> {
        public ITextComponent getName();
    }

    public static interface IContents
    extends IItemHandler {
        public IAgriPlant getPlant();

        public int getCount();

        public boolean isFull();

        public ISorter getSorter();

        public int getSorterIndex();

        public void setSorterIndex(int var1);

        default public ItemStack insertSeed(ItemStack stack, boolean simulate) {
            return this.insertItem(0, stack, simulate);
        }

        public ItemStack extractFirstSeed(int var1, boolean var2);

        public ItemStack extractLastSeed(int var1, boolean var2);

        public int getCapacity();
    }
}

