/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.capability.CapabilityResearchedPlants;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.network.MessagePlantResearched;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.util.PlayerAngleLocker;
import com.infinityraider.infinitylib.modules.dynamiccamera.IDynamicCameraController;
import com.infinityraider.infinitylib.modules.dynamiccamera.ModuleDynamicCamera;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class JournalViewPointHandler
implements IDynamicCameraController {
    private static final JournalViewPointHandler INSTANCE = new JournalViewPointHandler();
    public static final int TRANSITION_DURATION = 10;
    private static final int OPENING_DURATION = 20;
    private static final int FLIPPING_DURATION = 20;
    public static final double DX = 0.35;
    public static final double DY = -0.95;
    public static final double DZ = 0.425;
    public static final float PITCH = 80.0f;
    public static final float YAW = 0.0f;
    private boolean offHandActive;
    private boolean mainHandActive;
    private boolean observed;
    private Vector3d observerStart;
    private Vector3d cameraPosition;
    private Vector2f cameraOrientation;
    private float yawOffset;
    private JournalData journal;
    private int openingCounter;
    private int openingCounterPrev;

    public static JournalViewPointHandler getInstance() {
        return INSTANCE;
    }

    private JournalViewPointHandler() {
    }

    public boolean toggle(ItemStack journal, Hand hand) {
        if (this.isActive(hand)) {
            this.setActive(hand, false);
            if (((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, false)) {
                this.journal = null;
                return true;
            }
            this.setActive(hand, true);
            this.journal = new JournalData(journal);
        } else {
            Hand other;
            Hand hand2 = other = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
            if (!this.isActive(other)) {
                this.setActive(hand, true);
                if (((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, true)) {
                    this.journal = new JournalData(journal);
                    return true;
                }
                this.setActive(hand, false);
                this.journal = null;
            }
        }
        return false;
    }

    public void setActive(Hand hand, boolean status) {
        if (hand == Hand.MAIN_HAND) {
            this.setMainHandActive(status);
        } else {
            this.setOffHandActive(status);
        }
    }

    public void setOffHandActive(boolean status) {
        this.offHandActive = status;
        this.mainHandActive = status;
        if (status) {
            PlayerAngleLocker.storePlayerAngles();
        }
    }

    public void setMainHandActive(boolean status) {
        this.mainHandActive = status;
        if (status) {
            PlayerAngleLocker.storePlayerAngles();
        }
    }

    public boolean isActive() {
        return this.isMainHandActive() || this.isOffHandActive();
    }

    public boolean isActive(Hand hand) {
        return hand == Hand.MAIN_HAND ? this.isMainHandActive() : this.isOffHandActive();
    }

    public boolean isActive(HandSide hand) {
        HandSide main = Minecraft.func_71410_x().field_71474_y.field_186715_A;
        if (main == hand) {
            return this.isMainHandActive();
        }
        return this.isOffHandActive();
    }

    public boolean isMainHandActive() {
        return this.mainHandActive;
    }

    public boolean isOffHandActive() {
        return this.offHandActive;
    }

    public boolean isObserved() {
        return this.observed;
    }

    protected PlayerEntity getObserver() {
        return AgriCraft.instance.getClientPlayer();
    }

    @Nullable
    public JournalData getJournalData() {
        return this.journal;
    }

    @Nullable
    public ItemStack getJournal() {
        return this.getJournalData() == null ? null : this.getJournalData().getJournal();
    }

    public float getOpeningProgress(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.openingCounterPrev, (float)this.openingCounter) / 20.0f;
    }

    public float getFlippingProgress(float partialTicks) {
        return this.getJournalData() == null ? 0.0f : this.getJournalData().getFlippingProgress(partialTicks);
    }

    public void renderViewedPageLeft(IPageRenderer renderer, MatrixStack transforms) {
        if (this.getJournalData() != null) {
            this.getJournalData().getCurrentPage().drawLeftSheet(renderer, transforms);
        }
    }

    public void renderViewedPageRight(IPageRenderer renderer, MatrixStack transforms) {
        if (this.getJournalData() != null) {
            this.getJournalData().getCurrentPage().drawRightSheet(renderer, transforms);
        }
    }

    public void renderFlippedPageLeft(IPageRenderer renderer, MatrixStack transforms) {
        if (this.getJournalData() != null) {
            this.getJournalData().getFlippedPage().drawLeftSheet(renderer, transforms);
        }
    }

    public void renderFlippedPageRight(IPageRenderer renderer, MatrixStack transforms) {
        if (this.getJournalData() != null) {
            this.getJournalData().getFlippedPage().drawRightSheet(renderer, transforms);
        }
    }

    public int getTransitionDuration() {
        return 10;
    }

    public void onCameraActivated() {
        this.observerStart = this.getObserver().func_213303_ch();
    }

    public void onObservationStart() {
        this.observed = true;
    }

    public void onObservationEnd() {
        this.observed = false;
    }

    public void onCameraDeactivated() {
        this.setMainHandActive(false);
        this.setOffHandActive(false);
        this.observerStart = null;
        this.cameraPosition = null;
        this.cameraOrientation = null;
        this.journal = null;
    }

    public boolean shouldContinueObserving() {
        return this.observerStart != null && this.observerStart.equals((Object)this.getObserver().func_213303_ch());
    }

    public Vector3d getObserverPosition() {
        if (this.cameraPosition == null || this.yawOffset != this.getObserver().field_70761_aq) {
            this.cameraPosition = this.calculateObserverPosition(((IProxy)AgriCraft.instance.proxy()).getFieldOfView());
        }
        return this.cameraPosition;
    }

    protected Vector3d calculateObserverPosition(double fov) {
        double dz;
        double dx;
        double d = 0.75 * (0.5 / Math.tan(Math.PI * fov / 360.0));
        double dy = -0.95 + d * (double)MathHelper.func_76126_a((float)1.3962635f);
        double dHor = d * (double)MathHelper.func_76134_b((float)1.3962635f);
        float yaw = this.getObserverOrientation().field_189983_j;
        double cosYaw = MathHelper.func_76134_b((float)((float)Math.PI * yaw / 180.0f));
        double sinYaw = MathHelper.func_76126_a((float)((float)Math.PI * yaw / 180.0f));
        if (this.isActive(HandSide.RIGHT)) {
            dx = dHor * cosYaw - 0.35 * cosYaw - 0.425 * sinYaw;
            dz = dHor * sinYaw - 0.35 * sinYaw + 0.425 * cosYaw;
        } else {
            dx = dHor * cosYaw + 0.35 * cosYaw - 0.425 * sinYaw;
            dz = dHor * sinYaw + 0.35 * sinYaw + 0.425 * cosYaw;
        }
        return this.getObserver().func_213303_ch().func_72441_c(dx, dy + (double)this.getObserver().func_70047_e(), dz);
    }

    public Vector2f getObserverOrientation() {
        if (this.cameraOrientation == null || this.yawOffset != this.getObserver().field_70761_aq) {
            this.cameraOrientation = this.calculateObserverOrientation();
        }
        return this.cameraOrientation;
    }

    protected Vector2f calculateObserverOrientation() {
        float yaw = this.yawOffset = this.getObserver().field_70761_aq;
        if (this.isActive(HandSide.RIGHT)) {
            yaw += 0.0f;
        } else if (this.isActive(HandSide.LEFT)) {
            yaw -= 0.0f;
        }
        return new Vector2f(80.0f, yaw);
    }

    public void onFieldOfViewChanged(float fov) {
        this.cameraPosition = this.calculateObserverPosition(fov);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (this.isActive()) {
            if (this.isOffHandActive()) {
                if (!(this.getObserver().func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof IAgriJournalItem)) {
                    ((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, false);
                    this.setOffHandActive(false);
                    this.journal = null;
                    return;
                }
            } else if (this.isMainHandActive() && !(this.getObserver().func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof IAgriJournalItem)) {
                ((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, false);
                this.setMainHandActive(false);
                this.journal = null;
                return;
            }
            boolean up = Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d();
            boolean down = Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d();
            boolean left = Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d();
            boolean right = Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
            if (up || down || left || right) {
                ModuleDynamicCamera.getInstance().stopObserving();
            }
            PlayerAngleLocker.forcePlayerAngles();
        }
        this.openingCounterPrev = this.openingCounter;
        if (this.isObserved()) {
            this.openingCounter = this.openingCounter < 20 ? this.openingCounter + 1 : 20;
        } else {
            int n = this.openingCounter = this.openingCounter > 0 ? this.openingCounter - 1 : 0;
        }
        if (this.getJournalData() != null) {
            this.getJournalData().tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        if (this.isActive()) {
            if (this.getJournalData() != null) {
                if (event.getScrollDelta() < 0.0) {
                    this.getJournalData().incrementPage();
                } else if (event.getScrollDelta() > 0.0) {
                    this.getJournalData().decrementPage();
                }
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseClick(InputEvent.ClickInputEvent event) {
        if (this.isActive() && !event.isUseItem()) {
            event.setSwingHand(false);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMovement(InputUpdateEvent event) {
        if (this.isActive()) {
            event.getMovementInput().field_228350_h_ = false;
            event.getMovementInput().field_78901_c = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGuiOpened(GuiOpenEvent event) {
        if (this.isActive() && event.getGui() != null) {
            if (event.getGui() instanceof ChatScreen) {
                return;
            }
            ModuleDynamicCamera.getInstance().stopObserving();
            if (event.getGui() instanceof IngameMenuScreen) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    public static interface IPageRenderer {
        public int getPageWidth();

        public int getPageHeight();

        default public void drawFullPageTexture(MatrixStack transforms, ResourceLocation texture, float c) {
            this.drawTexture(transforms, texture, 0.0f, 0.0f, (float)this.getPageWidth(), (float)this.getPageHeight(), c);
        }

        default public void drawTexture(MatrixStack transforms, ResourceLocation texture, float x, float y, float w, float h, float c) {
            this.drawTexture(transforms, texture, x, y, w, h, 0.0f, 0.0f, 1.0f, 1.0f, c);
        }

        public void drawTexture(MatrixStack var1, ResourceLocation var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

        public void drawTexture(MatrixStack var1, TextureAtlasSprite var2, float var3, float var4, float var5, float var6, float var7);

        default public float drawText(MatrixStack transforms, ITextComponent text, float x, float y) {
            return this.drawText(transforms, text, x, y, 1.0f);
        }

        public float drawText(MatrixStack var1, ITextComponent var2, float var3, float var4, float var5);

        public void drawItem(MatrixStack var1, ItemStack var2, float var3, float var4);
    }

    public static class JournalData {
        private final ItemStack journal;
        private final List<Page> pages;
        private int page;
        private int target;
        private int animationCounter;
        private int prevAnimationCounter;
        public static final Page FRONT_PAGE = new Page(){
            private final ResourceLocation BACKGROUND_FRONT_RIGHT = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/front_page.png");

            @Override
            public void drawLeftSheet(IPageRenderer renderer, MatrixStack transforms) {
            }

            @Override
            public void drawRightSheet(IPageRenderer renderer, MatrixStack transforms) {
                renderer.drawFullPageTexture(transforms, this.BACKGROUND_FRONT_RIGHT, 1.0f);
            }
        };
        public static final Page INTRODUCTION_PAGE = new Page(){
            private final ITextComponent INTRODUCTION = new TranslationTextComponent("agricraft.journal.introduction");
            private final ITextComponent PARAGRAPH_1 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_1");
            private final ITextComponent PARAGRAPH_2 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_2");
            private final ITextComponent PARAGRAPH_3 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_3");

            @Override
            public void drawLeftSheet(IPageRenderer renderer, MatrixStack transforms) {
            }

            @Override
            public void drawRightSheet(IPageRenderer renderer, MatrixStack transforms) {
                float dy = 10.0f;
                float dx = 6.0f;
                float spacing = 4.0f;
                dy += renderer.drawText(transforms, this.INTRODUCTION, dx, dy);
                dy += spacing;
                dy += renderer.drawText(transforms, this.PARAGRAPH_1, dx, dy, 0.7f);
                dy += spacing;
                dy += renderer.drawText(transforms, this.PARAGRAPH_2, dx, dy, 0.7f);
                renderer.drawText(transforms, this.PARAGRAPH_3, dx, dy += spacing, 0.7f);
            }
        };

        protected JournalData(ItemStack journalStack) {
            this.journal = journalStack;
            this.pages = JournalData.initializePages(journalStack);
        }

        public ItemStack getJournal() {
            return this.journal;
        }

        public Page getCurrentPage() {
            if (this.target >= this.page) {
                return this.pages.get(this.page);
            }
            return this.pages.get(this.page - 1);
        }

        public Page getFlippedPage() {
            if (this.target > this.page) {
                return this.pages.get(this.page + 1);
            }
            return this.pages.get(this.page);
        }

        public void incrementPage() {
            this.target = Math.min(this.pages.size() - 1, this.target + 1);
        }

        public void decrementPage() {
            this.target = Math.max(0, this.target - 1);
        }

        public void tick() {
            this.prevAnimationCounter = this.animationCounter;
            if (this.target > this.page) {
                if (this.animationCounter == 0) {
                    this.prevAnimationCounter = this.animationCounter = 20;
                }
                --this.animationCounter;
                if (this.animationCounter <= 0) {
                    this.animationCounter = 0;
                    ++this.page;
                    this.pages.get(this.page).onPageOpened();
                }
            } else if (this.target < this.page) {
                if (this.animationCounter == 0) {
                    this.prevAnimationCounter = this.animationCounter = -20;
                }
                ++this.animationCounter;
                if (this.animationCounter >= 0) {
                    this.animationCounter = 0;
                    --this.page;
                    this.pages.get(this.page).onPageOpened();
                }
            }
        }

        public float getFlippingProgress(float partialTicks) {
            return MathHelper.func_219799_g((float)partialTicks, (float)this.prevAnimationCounter, (float)this.animationCounter) / 20.0f;
        }

        public static List<Page> initializePages(ItemStack journal) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            builder.add((Object)FRONT_PAGE);
            builder.add((Object)INTRODUCTION_PAGE);
            if (journal.func_77973_b() instanceof IAgriJournalItem) {
                IAgriJournalItem journalItem = (IAgriJournalItem)journal.func_77973_b();
                builder.addAll(JournalData.getPlantPages(journalItem.getDiscoveredSeeds(journal).stream().sorted(Comparator.comparing(plant -> plant.getPlantName().getString())).collect(Collectors.toList())));
            }
            return builder.build();
        }

        public static List<Page> getPlantPages(List<IAgriPlant> plants) {
            ImmutableList.Builder pages = ImmutableList.builder();
            plants.forEach(plant -> {
                PlantPage page = new PlantPage((IAgriPlant)plant, plants);
                pages.add((Object)page);
                List<List<TextureAtlasSprite>> mutations = page.getOffPageMutations();
                int size = mutations.size();
                if (size > 0) {
                    int remaining = size;
                    int from = 0;
                    int to = Math.min(remaining, 18);
                    while (remaining > 0) {
                        pages.add((Object)new MutationPage(mutations.subList(from, to)));
                        from = to;
                        to = from + Math.min(remaining -= to - from, 18);
                    }
                }
            });
            return pages.build();
        }

        public static final class Textures {
            public static final ResourceLocation TITLE = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_title.png");
            public static final ResourceLocation GROWTH_STAGE = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_growth_stage.png");
            public static final ResourceLocation BRIGHTNESS_BAR = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_brightness_bar.png");
            public static final ResourceLocation BRIGHTNESS_HIGHLIGHT = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_brightness_highlight.png");
            public static final ResourceLocation HUMIDITY_EMPTY = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_humidity_empty.png");
            public static final ResourceLocation HUMIDITY_FILLED = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_humidity_filled.png");
            public static final ResourceLocation ACIDITY_EMPTY = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_acidity_empty.png");
            public static final ResourceLocation ACIDITY_FILLED = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_acidity_filled.png");
            public static final ResourceLocation NUTRIENTS_FILLED = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_nutrients_filled.png");
            public static final ResourceLocation NUTRIENTS_EMPTY = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_nutrients_empty.png");
            public static final ResourceLocation SEASONS_FILLED = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_seasons_filled.png");
            public static final ResourceLocation SEASONS_EMPTY = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_seasons_empty.png");
            public static final ResourceLocation MUTATION = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/template_mutation.png");
            public static final int[] HUMIDITY_OFFSETS = new int[]{0, 8, 16, 26, 36, 46, 53};
            public static final int[] ACIDITY_OFFSETS = new int[]{0, 7, 15, 22, 30, 38, 46, 53};
            public static final int[] NUTRIENTS_OFFSETS = new int[]{0, 6, 14, 23, 32, 43, 53};

            private Textures() {
            }
        }

        private static abstract class BasePage
        extends Page {
            private BasePage() {
            }

            protected void drawMutation(IPageRenderer renderer, MatrixStack transforms, int posX, int posY, List<TextureAtlasSprite> sprites, float c) {
                renderer.drawTexture(transforms, Textures.MUTATION, (float)posX, (float)posY, 86.0f, 18.0f, c);
                transforms.func_227860_a_();
                transforms.func_227861_a_(0.0, 0.0, (double)-0.001f);
                renderer.drawTexture(transforms, sprites.get(0), (float)(posX + 1), (float)(posY + 1), 16.0f, 16.0f, c);
                renderer.drawTexture(transforms, sprites.get(1), (float)(posX + 35), (float)(posY + 1), 16.0f, 16.0f, c);
                renderer.drawTexture(transforms, sprites.get(2), (float)(posX + 69), (float)(posY + 1), 16.0f, 16.0f, c);
                transforms.func_227865_b_();
            }
        }

        private static final class MutationPage
        extends BasePage {
            public static final int LIMIT = 18;
            private final List<List<TextureAtlasSprite>> mutationsLeft;
            private final List<List<TextureAtlasSprite>> mutationsRight;

            public MutationPage(List<List<TextureAtlasSprite>> mutations) {
                int count = mutations.size();
                if (count <= 9) {
                    this.mutationsLeft = mutations;
                    this.mutationsRight = ImmutableList.of();
                } else {
                    this.mutationsLeft = mutations.subList(0, 8);
                    this.mutationsRight = mutations.subList(9, count - 1);
                }
            }

            @Override
            public void drawLeftSheet(IPageRenderer renderer, MatrixStack transforms) {
                int posX = 10;
                int posY = 6;
                int dy = 20;
                for (List<TextureAtlasSprite> sprites : this.mutationsLeft) {
                    this.drawMutation(renderer, transforms, posX, posY, sprites, 0.7f);
                    posY += dy;
                }
            }

            @Override
            public void drawRightSheet(IPageRenderer renderer, MatrixStack transforms) {
                int posX = 10;
                int posY = 6;
                int dy = 20;
                for (List<TextureAtlasSprite> sprites : this.mutationsRight) {
                    this.drawMutation(renderer, transforms, posX, posY, sprites, 1.0f);
                    posY += dy;
                }
            }
        }

        private static final class PlantPage
        extends BasePage
        implements IRenderUtilities {
            private static final ITextComponent GROWTH_STAGES = new TranslationTextComponent("agricraft.tooltip.growth_stages");
            private static final ITextComponent GROWTH_REQUIREMENTS = new TranslationTextComponent("agricraft.tooltip.growth_requirements");
            private static final ITextComponent PRODUCTS = new TranslationTextComponent("agricraft.tooltip.products");
            private static final ITextComponent MUTATIONS = new TranslationTextComponent("agricraft.tooltip.mutations");
            private final IAgriPlant plant;
            private final List<IAgriPlant> all;
            private final TextureAtlasSprite seed;
            private final List<TextureAtlasSprite> stages;
            private final boolean[] brightnessMask;
            private final boolean[] humidityMask;
            private final boolean[] acidityMask;
            private final boolean[] nutrientsMask;
            private final boolean[] seasonMask;
            private final List<ItemStack> drops;
            private final List<List<TextureAtlasSprite>> mutationsOnPage;
            private final List<List<TextureAtlasSprite>> mutationsOffPage;

            public PlantPage(IAgriPlant plant, List<IAgriPlant> all) {
                this.plant = plant;
                this.all = all;
                this.seed = this.getSprite(plant.getSeedTexture());
                this.stages = plant.getGrowthStages().stream().sorted((a, b) -> (int)(100.0 * (a.growthPercentage() - b.growthPercentage()))).map(plant::getTexturesFor).filter(textures -> textures.size() > 0).map(textures -> (ResourceLocation)textures.get(0)).map(arg_0 -> ((PlantPage)this).getSprite(arg_0)).collect(Collectors.toList());
                this.brightnessMask = new boolean[16];
                IAgriGrowthRequirement req = this.plant.getGrowthRequirement(this.plant.getInitialGrowthStage());
                for (int light = 0; light < this.brightnessMask.length; ++light) {
                    this.brightnessMask[light] = req.getLightLevelResponse(light, 1).isFertile();
                }
                this.humidityMask = new boolean[IAgriSoil.Humidity.values().length - 1];
                for (int humidity = 0; humidity < this.humidityMask.length; ++humidity) {
                    this.humidityMask[humidity] = req.getSoilHumidityResponse(IAgriSoil.Humidity.values()[humidity], 1).isFertile();
                }
                this.acidityMask = new boolean[IAgriSoil.Acidity.values().length - 1];
                for (int acidity = 0; acidity < this.acidityMask.length; ++acidity) {
                    this.acidityMask[acidity] = req.getSoilAcidityResponse(IAgriSoil.Acidity.values()[acidity], 1).isFertile();
                }
                this.nutrientsMask = new boolean[IAgriSoil.Nutrients.values().length - 1];
                for (int nutrients = 0; nutrients < this.nutrientsMask.length; ++nutrients) {
                    this.nutrientsMask[nutrients] = req.getSoilNutrientsResponse(IAgriSoil.Nutrients.values()[nutrients], 1).isFertile();
                }
                this.seasonMask = new boolean[AgriSeason.values().length - 1];
                for (int season = 0; season < this.seasonMask.length; ++season) {
                    this.seasonMask[season] = req.getSeasonResponse(AgriSeason.values()[season], 1).isFertile();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                this.plant.getAllPossibleProducts(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.drops = builder.build();
                List mutations = Stream.concat(this.gatherMutationSprites(mutation -> mutation.hasParent(this.plant)), this.gatherMutationSprites(mutation -> mutation.hasChild(this.plant))).collect(Collectors.toList());
                int count = mutations.size();
                if (count <= 6) {
                    this.mutationsOnPage = mutations.subList(0, count);
                    this.mutationsOffPage = ImmutableList.of();
                } else {
                    this.mutationsOnPage = mutations.subList(0, 6);
                    this.mutationsOffPage = mutations.subList(6, count);
                }
            }

            protected Stream<List<TextureAtlasSprite>> gatherMutationSprites(Predicate<IAgriMutation> filter) {
                return AgriApi.getMutationRegistry().stream().filter(filter).map(mutation -> Stream.of(mutation.getParents().get(0), mutation.getParents().get(1), mutation.getChild()).map(plant -> {
                    if (this.isPlantKnown((IAgriPlant)plant)) {
                        return plant.getSeedTexture();
                    }
                    return NoPlant.getInstance().getSeedTexture();
                }).map(arg_0 -> ((PlantPage)this).getSprite(arg_0)).collect(Collectors.toList()));
            }

            protected boolean isPlantKnown(IAgriPlant plant) {
                if (((Config)AgriCraft.instance.getConfig()).progressiveJEI()) {
                    return this.all.contains(plant) || CapabilityResearchedPlants.getInstance().isPlantResearched(AgriCraft.instance.getClientPlayer(), plant);
                }
                return true;
            }

            @Override
            public void onPageOpened() {
                if (!CapabilityResearchedPlants.getInstance().isPlantResearched(AgriCraft.instance.getClientPlayer(), this.plant)) {
                    new MessagePlantResearched(this.plant).sendToServer();
                }
            }

            public List<List<TextureAtlasSprite>> getOffPageMutations() {
                return this.mutationsOffPage;
            }

            @Override
            public void drawLeftSheet(IPageRenderer renderer, MatrixStack transforms) {
                renderer.drawTexture(transforms, Textures.TITLE, 0.0f, 2.0f, 128.0f, 20.0f, 0.7f);
                renderer.drawText(transforms, (ITextComponent)this.plant.getSeedName(), 30.0f, 10.0f);
                float offset = renderer.drawText(transforms, (ITextComponent)this.plant.getInformation(), 10.0f, 30.0f, 0.7f);
                this.drawGrowthRequirements(renderer, transforms, 35.0f + offset);
                renderer.drawTexture(transforms, this.seed, 4.0f, 5.0f, 16.0f, 16.0f, 0.7f);
                this.drawGrowthStages(renderer, transforms);
            }

            @Override
            public void drawRightSheet(IPageRenderer renderer, MatrixStack transforms) {
                this.drawProducts(renderer, transforms);
                this.drawMutations(renderer, transforms);
            }

            protected void drawGrowthRequirements(IPageRenderer renderer, MatrixStack transforms, float offset) {
                int w;
                int dx;
                int i;
                float dy = Math.max(offset, 60.0f);
                dy += renderer.drawText(transforms, GROWTH_REQUIREMENTS, 10.0f, dy, 0.8f) + 1.0f;
                renderer.drawTexture(transforms, Textures.BRIGHTNESS_BAR, 6.0f, dy, 66.0f, 8.0f, 0.7f);
                transforms.func_227860_a_();
                transforms.func_227861_a_(0.0, 0.0, (double)-0.001f);
                for (i = 0; i < this.brightnessMask.length; ++i) {
                    boolean current = this.brightnessMask[i];
                    if (!current) continue;
                    boolean prev = i > 0 && this.brightnessMask[i - 1];
                    boolean next = i < this.brightnessMask.length - 1 && this.brightnessMask[i + 1];
                    renderer.drawTexture(transforms, Textures.BRIGHTNESS_HIGHLIGHT, 6 + 4 * i + 1, dy, 4.0f, 8.0f, 0.25f, 0.0f, 0.75f, 1.0f, 0.7f);
                    if (!prev) {
                        renderer.drawTexture(transforms, Textures.BRIGHTNESS_HIGHLIGHT, 6 + 4 * i, dy, 1.0f, 8.0f, 0.0f, 0.0f, 0.25f, 1.0f, 0.7f);
                    }
                    if (next) continue;
                    renderer.drawTexture(transforms, Textures.BRIGHTNESS_HIGHLIGHT, 6 + 4 * i + 5, dy, 1.0f, 8.0f, 0.75f, 0.0f, 1.0f, 1.0f, 0.7f);
                }
                dy += 9.0f;
                transforms.func_227865_b_();
                if (AgriApi.getSeasonLogic().isActive()) {
                    for (i = 0; i < this.seasonMask.length; ++i) {
                        dx = 70;
                        w = 10;
                        int h = 12;
                        int x = i % 2 * (w + 2) + 5;
                        int y = i / 2 * (h + 2) + 6;
                        float v1 = (0.0f + (float)(i * h)) / 48.0f;
                        float v2 = (0.0f + (float)((i + 1) * h)) / 48.0f;
                        if (this.seasonMask[i]) {
                            renderer.drawTexture(transforms, Textures.SEASONS_FILLED, x + dx, (float)y + dy, w, h, 0.0f, v1, 1.0f, v2, 0.7f);
                            continue;
                        }
                        renderer.drawTexture(transforms, Textures.SEASONS_EMPTY, x + dx, (float)y + dy, w, h, 0.0f, v1, 1.0f, v2, 0.7f);
                    }
                }
                for (i = 0; i < this.humidityMask.length; ++i) {
                    dx = Textures.HUMIDITY_OFFSETS[i];
                    w = Textures.HUMIDITY_OFFSETS[i + 1] - Textures.HUMIDITY_OFFSETS[i];
                    float u1 = ((float)dx + 0.0f) / 53.0f;
                    float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
                    if (this.humidityMask[i]) {
                        renderer.drawTexture(transforms, Textures.HUMIDITY_FILLED, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f, 0.7f);
                        continue;
                    }
                    renderer.drawTexture(transforms, Textures.HUMIDITY_EMPTY, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f, 0.7f);
                }
                dy += 13.0f;
                for (i = 0; i < this.acidityMask.length; ++i) {
                    dx = Textures.ACIDITY_OFFSETS[i];
                    w = Textures.ACIDITY_OFFSETS[i + 1] - Textures.ACIDITY_OFFSETS[i];
                    float u1 = ((float)dx + 0.0f) / 53.0f;
                    float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
                    if (this.acidityMask[i]) {
                        renderer.drawTexture(transforms, Textures.ACIDITY_FILLED, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f, 0.7f);
                        continue;
                    }
                    renderer.drawTexture(transforms, Textures.ACIDITY_EMPTY, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f, 0.7f);
                }
                dy += 13.0f;
                for (i = 0; i < this.nutrientsMask.length; ++i) {
                    dx = Textures.NUTRIENTS_OFFSETS[i];
                    w = Textures.NUTRIENTS_OFFSETS[i + 1] - Textures.NUTRIENTS_OFFSETS[i];
                    float u1 = ((float)dx + 0.0f) / 53.0f;
                    float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
                    if (this.nutrientsMask[i]) {
                        renderer.drawTexture(transforms, Textures.NUTRIENTS_FILLED, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f, 0.7f);
                        continue;
                    }
                    renderer.drawTexture(transforms, Textures.NUTRIENTS_EMPTY, 10 + dx, dy, w, 12.0f, u1, 0.0f, u2, 1.0f, 0.7f);
                }
            }

            protected void drawGrowthStages(IPageRenderer renderer, MatrixStack transforms) {
                int y0 = 170;
                int delta = 20;
                int rows = this.stages.size() / 6 + (this.stages.size() % 6 > 0 ? 1 : 0);
                int columns = this.stages.size() / rows + (this.stages.size() % rows > 0 ? 1 : 0);
                int row = 0;
                int dx = (renderer.getPageWidth() - 16 * columns) / (columns + 1);
                for (int i = 0; i < this.stages.size(); ++i) {
                    int column = i % columns;
                    if (i > 0 && column == 0) {
                        ++row;
                    }
                    renderer.drawTexture(transforms, Textures.GROWTH_STAGE, (float)(dx * (column + 1) + 16 * column - 1), (float)(y0 - delta * (rows - row - 1) - 1), 18.0f, 18.0f, 0.7f);
                    transforms.func_227860_a_();
                    transforms.func_227861_a_(0.0, 0.0, (double)-0.001f);
                    renderer.drawTexture(transforms, this.stages.get(i), (float)(dx * (column + 1) + 16 * column), (float)(y0 - delta * (rows - row - 1)), 16.0f, 16.0f, 0.7f);
                    transforms.func_227865_b_();
                }
                renderer.drawText(transforms, GROWTH_STAGES, 10.0f, y0 - delta * rows + 4, 0.9f);
            }

            protected void drawProducts(IPageRenderer renderer, MatrixStack transforms) {
                renderer.drawText(transforms, PRODUCTS, 10.0f, 10.0f, 0.8f);
                for (int i = 0; i < this.drops.size(); ++i) {
                    renderer.drawTexture(transforms, Textures.MUTATION, 10 + i * 20, 19.0f, 18.0f, 18.0f, 0.0f, 0.0f, 0.20930232f, 1.0f, 1.0f);
                    renderer.drawItem(transforms, this.drops.get(i), 11 + i * 20, 20.0f);
                }
            }

            protected void drawMutations(IPageRenderer renderer, MatrixStack transforms) {
                renderer.drawText(transforms, MUTATIONS, 10.0f, 45.0f, 0.8f);
                int posX = 10;
                int posY = 54;
                int dy = 20;
                for (List<TextureAtlasSprite> sprites : this.mutationsOnPage) {
                    this.drawMutation(renderer, transforms, posX, posY, sprites, 1.0f);
                    posY += dy;
                }
            }
        }

        public static abstract class Page {
            protected static final float SHADE_LEFT = 0.7f;
            protected static final float SHADE_RIGHT = 1.0f;

            public abstract void drawLeftSheet(IPageRenderer var1, MatrixStack var2);

            public abstract void drawRightSheet(IPageRenderer var1, MatrixStack var2);

            public void onPageOpened() {
            }
        }
    }
}

