/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ResourceHandler {
    private static final ResourceHandler INSTANCE = new ResourceHandler();

    public static ResourceHandler getInstance() {
        return INSTANCE;
    }

    private ResourceHandler() {
    }

    @SubscribeEvent
    public void onReloadListenerRegistration(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new AgriJsonReloadListener(event.getDataPackRegistries()));
    }

    public static class AgriJsonReloadListener
    implements IFutureReloadListener {
        private final DataPackRegistries dataPacks;

        private AgriJsonReloadListener(DataPackRegistries dataPacks) {
            this.dataPacks = dataPacks;
        }

        public DataPackRegistries getDataPacks() {
            return this.dataPacks;
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.readJsons(resourceManager), backgroundExecutor).thenAccept(v -> this.uploadTextures(resourceManager))).thenAccept(v -> this.uploadModels(resourceManager))).thenAccept(v -> this.finalize(resourceManager));
        }

        protected void readJsons(IResourceManager manager) {
        }

        protected void uploadTextures(IResourceManager manager) {
        }

        protected void uploadModels(IResourceManager manager) {
        }

        public void finalize(IResourceManager manager) {
        }
    }
}

