/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.config.Config;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VanillaPlantingHandler {
    private static final VanillaPlantingHandler INSTANCE = new VanillaPlantingHandler();
    private final Set<Item> exceptions = Sets.newConcurrentHashSet();

    public static VanillaPlantingHandler getInstance() {
        return INSTANCE;
    }

    private VanillaPlantingHandler() {
    }

    public void registerException(Item item) {
        this.exceptions.add(item);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void vanillaSeedPlanting(PlayerInteractEvent.RightClickBlock event) {
        if (!((Config)AgriCraft.instance.getConfig()).overrideVanillaFarming()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (this.exceptions.contains(stack.func_77973_b())) {
            return;
        }
        if (AgriApi.getCrop((IBlockReader)event.getWorld(), event.getPos()).isPresent()) {
            return;
        }
        boolean success = AgriApi.getGenomeAdapterizer().valueOf(stack).map(seed -> {
            BlockPos pos = event.getFace() == null ? event.getPos() : event.getPos().func_177972_a(event.getFace());
            World world = event.getWorld();
            PlayerEntity player = event.getPlayer();
            return AgriApi.getSoil((IBlockReader)event.getWorld(), pos.func_177977_b()).map(soil -> {
                BlockState newState = AgriCraft.instance.getModBlockRegistry().crop_plant.getStateForPlacement(world, pos);
                if (newState != null && world.func_180501_a(pos, newState, 11)) {
                    boolean planted = AgriApi.getCrop((IBlockReader)world, pos).map(crop -> crop.plantGenome((IAgriGenome)seed)).orElse(false);
                    if (planted) {
                        if (player == null || !player.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                        return true;
                    }
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                return false;
            }).orElse(false);
        }).orElse(false);
        if (success) {
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void denyBonemeal(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityLiving().func_225608_bj_()) {
            return;
        }
        ItemStack heldItem = event.getEntityLiving().func_184607_cu();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_196106_bc) {
            AgriApi.getCrop((IBlockReader)event.getWorld(), event.getPos()).ifPresent(crop -> event.setUseItem(Event.Result.DENY));
        }
    }
}

