/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneRegistry;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.misc.IAgriRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.plugin.AgriPlugin;
import com.infinityraider.agricraft.api.v1.plugin.IAgriPlugin;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSeasonLogic;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public final class PluginHandler {
    @Nonnull
    private static final Deque<IAgriPlugin> PLUGINS = new ConcurrentLinkedDeque<IAgriPlugin>();

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        PLUGINS.addAll(PluginHandler.getInstances(PluginHandler.getScanData(event), AgriPlugin.class, IAgriPlugin.class));
        PLUGINS.stream().peek(PluginHandler::logPlugin).filter(IAgriPlugin::isEnabled).forEach(plugin -> plugin.onCommonSetupEvent(event));
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(plugin -> plugin.onClientSetupEvent(event));
    }

    private static void executeForPlugins(Consumer<IAgriPlugin> consumer) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(consumer);
    }

    public static void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        PluginHandler.executeForPlugins(plugin -> plugin.onInterModEnqueueEvent(event));
    }

    public static void onInterModProcessEvent(InterModProcessEvent event) {
        PluginHandler.executeForPlugins(plugin -> plugin.onInterModProcessEvent(event));
    }

    public static void populateRegistries() {
        PluginHandler.registerSoils(AgriApi.getSoilRegistry());
        PluginHandler.registerWeeds(AgriApi.getWeedRegistry());
        PluginHandler.registerPlants(AgriApi.getPlantRegistry());
        PluginHandler.registerMutations(AgriApi.getMutationRegistry());
        PluginHandler.registerStats(AgriApi.getStatRegistry());
        PluginHandler.registerGenes(AgriApi.getGeneRegistry());
        PluginHandler.registerGenomes(AgriApi.getGenomeAdapterizer());
        PluginHandler.registerFertilizers(AgriApi.getFertilizerAdapterizer());
        PluginHandler.registerSeasonLogic(AgriApi.getSeasonLogic());
    }

    public static void registerSoils(IAgriSoilRegistry soilRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerSoils(soilRegistry));
    }

    public static void registerWeeds(IAgriRegistry<IAgriWeed> weedRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerWeeds(weedRegistry));
    }

    public static void registerPlants(IAgriRegistry<IAgriPlant> plantRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerPlants(plantRegistry));
    }

    public static void registerMutations(IAgriMutationRegistry mutationRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerMutations(mutationRegistry));
    }

    public static void registerStats(IAgriStatRegistry statRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerStats(statRegistry));
    }

    public static void registerGenes(IAgriGeneRegistry geneRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerGenes(geneRegistry));
    }

    public static void registerGenomes(IAgriAdapterizer<IAgriGenome> adapterizer) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerGenomes(adapterizer));
    }

    public static void registerFertilizers(IAgriAdapterizer<IAgriFertilizer> adapterizer) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerFertilizers(adapterizer));
    }

    public static void registerSeasonLogic(IAgriSeasonLogic seasonLogic) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerSeasonLogic(seasonLogic));
    }

    @Nonnull
    private static <A, T> List<T> getInstances(ModFileScanData data, Class<A> anno, Class<T> type) {
        ArrayList instances = new ArrayList();
        if (data == null) {
            AgriCore.getLogger("agricraft-plugins").error("Failed to load AgriPlugins, ModFileScanData not found", new Object[0]);
        } else if (data.getAnnotations() == null || data.getAnnotations().size() <= 0) {
            AgriCore.getLogger("agricraft-plugins").error("Failed to load AgriPlugins, no PlugIn Annotations found in ModFileScanData", new Object[0]);
        } else {
            data.getAnnotations().stream().filter(annotationData -> Type.getType((Class)anno).equals((Object)annotationData.getAnnotationType())).forEach(annotationData -> {
                try {
                    Object instance = Class.forName(annotationData.getClassType().getClassName()).asSubclass(type).newInstance();
                    instances.add(instance);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
                    AgriCore.getLogger("agricraft-plugins").debug("%nFailed to load AgriPlugin%n\tOf class: {0}!%n\tFor annotation: {1}!%n\tAs Instanceof: {2}!", new Object[]{annotationData.getTargetType(), anno.getCanonicalName(), type.getCanonicalName()});
                }
            });
        }
        return instances;
    }

    private static ModFileScanData getScanData(FMLCommonSetupEvent event) {
        Field field;
        FMLModContainer container = null;
        try {
            field = ModLifecycleEvent.class.getDeclaredField("container");
            field.setAccessible(true);
            container = (FMLModContainer)field.get(event);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            AgriCore.getLogger("agricraft-plugins").error("Failed to fetch ModContainer from FMLCommonSetupEvent", new Object[0]);
        }
        if (container == null) {
            return null;
        }
        try {
            field = FMLModContainer.class.getDeclaredField("scanResults");
            field.setAccessible(true);
            return (ModFileScanData)field.get(container);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            AgriCore.getLogger("agricraft-plugins").error("Failed to fetch ModFileScanData from FMLModContainer", new Object[0]);
            return null;
        }
    }

    private static void logPlugin(IAgriPlugin plugin) {
        AgriCore.getLogger("agricraft").info("\nFound AgriCraft Plugin:\n\t- Id: {0}\n\t- Name: {1}\n\t- Status: {2}", plugin.getId(), plugin.getName(), plugin.isEnabled() ? "Enabled" : "Disabled");
    }
}

