/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatProvider;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.content.core.ItemDynamicAgriSeed;
import com.infinityraider.agricraft.impl.v1.genetics.AgriGeneRegistry;
import com.infinityraider.agricraft.impl.v1.genetics.GeneSpecies;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;

public class AgriGenome
implements IAgriGenome,
IAgriStatsMap,
IAgriStatProvider {
    private final Map<IAgriGene<?>, IAgriGenePair<?>> geneMap;

    private AgriGenome(Map<IAgriGene<?>, IAgriGenePair<?>> geneMap) {
        this.geneMap = geneMap;
    }

    @Override
    public <T> IAgriGenePair<T> getGenePair(IAgriGene<T> gene) {
        return this.geneMap.get(gene);
    }

    @Override
    public ItemStack toSeedStack(int amount) {
        return ItemDynamicAgriSeed.toStack(this, amount);
    }

    @Override
    public IAgriStatsMap getStats() {
        return this;
    }

    @Override
    public IAgriGenome clone() {
        return new AgriGenome(Maps.transformValues(this.geneMap, IAgriGenePair::clone));
    }

    @Override
    public boolean writeToNBT(@Nonnull CompoundNBT tag) {
        ListNBT list = new ListNBT();
        int index = 0;
        for (IAgriGenePair<?> pair : this.geneMap.values()) {
            CompoundNBT geneTag = new CompoundNBT();
            geneTag.func_74778_a("agri_gene", pair.getGene().getId());
            geneTag.func_218657_a("agri_dominant", (INBT)pair.getDominant().writeToNBT());
            geneTag.func_218657_a("agri_recessive", (INBT)pair.getRecessive().writeToNBT());
            list.func_218660_b(index, (INBT)geneTag);
            ++index;
        }
        tag.func_218657_a("agri_genome", (INBT)list);
        return true;
    }

    @Override
    public boolean readFromNBT(@Nonnull CompoundNBT tag) {
        if (tag.func_74764_b("agri_genome")) {
            ListNBT list = tag.func_150295_c("agri_genome", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT geneTag = list.func_150305_b(i);
                AgriGeneRegistry.getInstance().get(geneTag.func_74779_i("agri_gene")).ifPresent(gene -> this.geneMap.put((IAgriGene<?>)gene, this.generateGenePairFromNBT((IAgriGene)gene, geneTag)));
            }
            return this.getPlant().isPlant();
        }
        return false;
    }

    private <T> IAgriGenePair<T> generateGenePairFromNBT(IAgriGene<T> gene, CompoundNBT tag) {
        IAllele<T> dominant = gene.readAlleleFromNBT(tag.func_74775_l("agri_dominant"));
        IAllele<T> recessive = gene.readAlleleFromNBT(tag.func_74775_l("agri_recessive"));
        return gene.generateGenePair(dominant, recessive);
    }

    @Override
    public int getValue(IAgriStat stat) {
        return AgriGeneRegistry.getInstance().get(stat).map(this::getGenePair).map(IAgriGenePair::getTrait).orElse(stat.getMin());
    }

    public static IAgriGenome.Builder builder(IAgriPlant plant) {
        return new Builder(plant);
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<ITextComponent> consumer) {
        this.geneMap.values().forEach(genePair -> genePair.addTooltipDescription(consumer));
    }

    private static class Builder
    implements IAgriGenome.Builder {
        private final Map<IAgriGene<?>, IAgriGenePair<?>> geneMap = Maps.newIdentityHashMap();

        private Builder(IAgriPlant plant) {
            for (IAgriGene gene : AgriApi.getGeneRegistry().all()) {
                this.geneMap.put(gene, this.generateDefaultPair(gene, plant));
            }
            this.geneMap.put(GeneSpecies.getInstance(), GeneSpecies.getInstance().generateGenePair(plant, plant));
        }

        private <T> IAgriGenePair<T> generateDefaultPair(IAgriGene<T> gene, IAgriPlant plant) {
            return gene.generateGenePair(gene.defaultAllele(plant), gene.defaultAllele(plant));
        }

        @Override
        public IAgriGenome build() {
            return new AgriGenome(this.geneMap);
        }

        @Override
        public <T> IAgriGenome.Builder put(IAgriGenePair<T> pair) {
            this.geneMap.put(pair.getGene(), pair);
            return this;
        }
    }
}

