/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.genetics.IMutator;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.genetics.AgriMutationHandler;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GeneStat
implements IAgriGene<Integer> {
    private final IAgriStat stat;
    private final Allele defaultAllele;
    private final Set<IAllele<Integer>> alleles;
    private final Vector3f colorDominant;
    private final Vector3f colorRecessive;
    private static final float COLOR_FACTOR = 0.6f;
    private static final Map<String, Logic> LOGIC_MAP = Maps.newHashMap();

    public GeneStat(IAgriStat stat) {
        this.stat = stat;
        this.defaultAllele = new Allele(this, this.getStat().getMin());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = this.getStat().getMin(); i <= this.getStat().getMax(); ++i) {
            builder.add((Object)(i == this.getStat().getMin() ? this.defaultAllele : new Allele(this, i)));
        }
        this.alleles = builder.build();
        this.colorDominant = stat.getColor();
        this.colorRecessive = GeneStat.getRecessiveVector(stat.getColor());
    }

    public IAgriStat getStat() {
        return this.stat;
    }

    public int getMin() {
        return this.getStat().getMin();
    }

    public int getMax() {
        return this.getStat().getMax();
    }

    public Allele defaultAllele() {
        return this.defaultAllele;
    }

    @Nonnull
    public Allele defaultAllele(IAgriPlant plant) {
        return this.defaultAllele();
    }

    @Nonnull
    public Allele getAllele(Integer value) {
        int val = Math.max(this.getMin(), Math.min(this.getMax(), value));
        return (Allele)this.allAlleles().stream().filter(allel -> (Integer)allel.trait() == val).findFirst().orElse(this.defaultAllele());
    }

    @Nonnull
    public Allele readAlleleFromNBT(@Nonnull CompoundNBT tag) {
        return this.getAllele(tag.func_74762_e(this.getStat().getId()));
    }

    @Override
    @Nonnull
    public Set<IAllele<Integer>> allAlleles() {
        return this.alleles;
    }

    @Override
    @Nonnull
    public IMutator<Integer> mutator() {
        return AgriMutationHandler.getInstance().getActiveStatMutator();
    }

    @Override
    @Nonnull
    public IAgriGenePair<Integer> generateGenePair(IAllele<Integer> first, IAllele<Integer> second) {
        return new GenePair(this, first instanceof Allele ? (Allele)first : this.getAllele(first.trait()), second instanceof Allele ? (Allele)second : this.getAllele(second.trait()));
    }

    @Override
    @Nonnull
    public IFormattableTextComponent getGeneDescription() {
        return this.getStat().getDescription();
    }

    @Override
    @Nonnull
    public Vector3f getDominantColor() {
        return this.colorDominant;
    }

    @Override
    @Nonnull
    public Vector3f getRecessiveColor() {
        return this.colorRecessive;
    }

    @Override
    public int getComparatorWeight() {
        return 10;
    }

    @Override
    public boolean isHidden() {
        return this.getStat().isHidden();
    }

    @Override
    @Nonnull
    public String getId() {
        return this.stat.getId();
    }

    protected static Vector3f getRecessiveVector(Vector3f dominant) {
        return new Vector3f(0.6f * dominant.func_195899_a(), 0.6f * dominant.func_195900_b(), 0.6f * dominant.func_195902_c());
    }

    public static List<String> getLogicOptions() {
        return ImmutableList.copyOf(LOGIC_MAP.keySet());
    }

    public static Logic getLogic(String value) {
        return LOGIC_MAP.getOrDefault(value.toLowerCase(), Logic.MAX);
    }

    static {
        Arrays.stream(Logic.values()).forEach(logic -> LOGIC_MAP.put(logic.name().toLowerCase(), (Logic)((Object)logic)));
    }

    public static enum Logic {
        MIN(Math::min),
        MEAN((a, b) -> (a + b) / 2),
        MAX(Math::max);

        private final IntBinaryOperator function;

        private Logic(IntBinaryOperator function) {
            this.function = function;
        }

        public int apply(int a, int b) {
            return this.function.applyAsInt(a, b);
        }
    }

    private static final class GenePair
    implements IAgriGenePair<Integer> {
        private final GeneStat gene;
        private final Allele dominant;
        private final Allele recessive;

        public GenePair(GeneStat gene, Allele first, Allele second) {
            this.gene = gene;
            if (first.isDominant(second)) {
                this.dominant = first;
                this.recessive = second;
            } else {
                this.dominant = second;
                this.recessive = first;
            }
        }

        public GeneStat getGene() {
            return this.gene;
        }

        @Override
        public Integer getTrait() {
            return GeneStat.getLogic(((Config)AgriCraft.instance.getConfig()).getStatTraitLogic()).apply(this.getDominant().trait(), this.getRecessive().trait());
        }

        public Allele getDominant() {
            return this.dominant;
        }

        public Allele getRecessive() {
            return this.recessive;
        }

        @Override
        public IAgriGenePair<Integer> clone() {
            return new GenePair(this.getGene(), this.getDominant(), this.getRecessive());
        }

        @Override
        public void addTooltipDescription(Consumer<ITextComponent> consumer) {
            if (!this.getGene().isHidden()) {
                consumer.accept(AgriToolTips.getGeneTooltip(this));
            }
        }
    }

    private static final class Allele
    implements IAllele<Integer> {
        private final GeneStat gene;
        private final int value;
        private final StringTextComponent tooltip;

        private Allele(GeneStat gene, int value) {
            this.gene = gene;
            this.value = value;
            this.tooltip = new StringTextComponent("" + this.trait());
        }

        public GeneStat gene() {
            return this.gene;
        }

        @Override
        public Integer trait() {
            return this.value;
        }

        @Override
        public boolean isDominant(IAllele<Integer> other) {
            return this.trait() >= other.trait();
        }

        public StringTextComponent getTooltip() {
            return this.tooltip;
        }

        @Override
        public int comparatorValue() {
            return this.trait();
        }

        @Override
        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a(this.gene().getStat().getId(), this.trait().intValue());
            return tag;
        }
    }
}

