/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.irrigation;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;

public class IrrigationNetworkLayer {
    private final double min;
    private final double max;
    private final int volume;

    public IrrigationNetworkLayer(CompoundNBT tag) {
        this.min = tag.func_74764_b("agri_y1") ? tag.func_74769_h("agri_y1") : 0.0;
        this.max = tag.func_74764_b("agri_y2") ? tag.func_74769_h("agri_y2") : 0.0;
        this.volume = tag.func_74764_b("agri_level") ? tag.func_74762_e("agri_level") : 0;
    }

    public IrrigationNetworkLayer(double min, double max, int volume) {
        this.min = min;
        this.max = max;
        this.volume = volume;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getCapacity(double height) {
        if (height <= this.getMin()) {
            return 0;
        }
        if (height >= this.getMax()) {
            return this.getVolume();
        }
        return (int)((double)this.getVolume() * (height - this.getMin()) / (this.getMax() - this.getMin()));
    }

    public double getHeight(int content) {
        if (content <= 0) {
            return this.getMin();
        }
        if (content >= this.getVolume()) {
            return this.getMax();
        }
        double f = ((double)content + 0.0) / (double)this.getVolume();
        return MathHelper.func_219803_d((double)f, (double)this.getMin(), (double)this.getMax());
    }

    public CompoundNBT writeToTag() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("agri_y1", this.getMin());
        tag.func_74780_a("agri_y2", this.getMax());
        tag.func_74768_a("agri_level", this.getVolume());
        return tag;
    }

    public void split(double level, Consumer<IrrigationNetworkLayer> consumer) {
        if (level <= this.getMin() || level >= this.getMax()) {
            consumer.accept(this);
        } else {
            double f = (level - this.getMin()) / (this.getMax() - this.getMin());
            IrrigationNetworkLayer lower = new IrrigationNetworkLayer(this.getMin(), level, (int)f * this.getVolume());
            IrrigationNetworkLayer upper = new IrrigationNetworkLayer(level, this.getMax(), this.getVolume() - lower.getVolume());
            if (lower.getVolume() > 0) {
                consumer.accept(lower);
            }
            if (upper.getVolume() > 0) {
                consumer.accept(upper);
            }
        }
    }

    public boolean merge(IrrigationNetworkLayer other, Consumer<IrrigationNetworkLayer> consumer) {
        if (this.getMin() != other.getMin() || this.getMax() != other.getMax()) {
            return false;
        }
        consumer.accept(new IrrigationNetworkLayer(this.getMin(), this.getMax(), this.getVolume() + other.getVolume()));
        return true;
    }

    public void distinct(IrrigationNetworkLayer other, Consumer<IrrigationNetworkLayer> consumer) {
        if (this.merge(other, consumer)) {
            return;
        }
        if (this.getMax() <= other.getMin() || this.getMin() >= other.getMax()) {
            consumer.accept(this);
            consumer.accept(other);
        } else if (this.getMin() < other.getMin()) {
            if (this.getMax() > other.getMax()) {
                this.envelope(other, consumer);
            } else {
                this.overlapFromBelow(other, consumer);
            }
        } else if (this.getMax() > other.getMax()) {
            this.overlapFromAbove(other, consumer);
        } else {
            other.envelope(this, consumer);
        }
    }

    private void envelope(IrrigationNetworkLayer other, Consumer<IrrigationNetworkLayer> consumer) {
        this.split(other.getMin(), split1 -> {
            if (split1.getMax() > other.getMax()) {
                split1.split(other.getMax(), split2 -> {
                    if (split2.getMax() > other.getMax()) {
                        consumer.accept((IrrigationNetworkLayer)split2);
                    } else {
                        other.merge((IrrigationNetworkLayer)split2, consumer);
                    }
                });
            } else {
                consumer.accept((IrrigationNetworkLayer)split1);
            }
        });
    }

    private void overlapFromAbove(IrrigationNetworkLayer other, Consumer<IrrigationNetworkLayer> consumer) {
        other.overlapFromBelow(this, consumer);
    }

    private void overlapFromBelow(IrrigationNetworkLayer other, Consumer<IrrigationNetworkLayer> consumer) {
        this.split(other.getMin(), split1 -> {
            if (split1.getMax() > other.getMin()) {
                other.split(split1.getMax(), split2 -> {
                    if (split2.getMax() > this.getMax()) {
                        consumer.accept((IrrigationNetworkLayer)split2);
                    } else {
                        split1.merge((IrrigationNetworkLayer)split2, consumer);
                    }
                });
            } else {
                consumer.accept((IrrigationNetworkLayer)split1);
            }
        });
    }
}

