/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriPlant;
import com.agricraft.agricore.plant.AgriRenderType;
import com.agricraft.agricore.plant.AgriSoilCondition;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.handler.VanillaPlantingHandler;
import com.infinityraider.agricraft.impl.v1.crop.IncrementalGrowthLogic;
import com.infinityraider.agricraft.impl.v1.plant.JsonPlantCallback;
import com.infinityraider.agricraft.impl.v1.requirement.AgriGrowthRequirement;
import com.infinityraider.agricraft.render.plant.AgriPlantQuadGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonPlant
implements IAgriPlant {
    private final AgriPlant plant;
    private final TranslationTextComponent plantName;
    private final TranslationTextComponent seedName;
    private final TranslationTextComponent description;
    private final List<IAgriGrowthStage> growthStages;
    private final IAgriGrowthRequirement growthRequirement;
    private final List<ItemStack> seedItems;
    private final List<IJsonPlantCallback> callbacks;
    private final ResourceLocation seedTexture;
    private final ResourceLocation seedModel;

    public JsonPlant(AgriPlant plant) {
        this.plant = Objects.requireNonNull(plant, "A JSONPlant may not consist of a null AgriPlant! Why would you even try that!?");
        this.plantName = new TranslationTextComponent(plant.getPlantLangKey());
        this.seedName = new TranslationTextComponent(plant.getSeedLangKey());
        this.description = new TranslationTextComponent(plant.getDescLangKey());
        this.growthStages = IncrementalGrowthLogic.getOrGenerateStages(this.plant.getGrowthStages());
        this.growthRequirement = JsonPlant.initGrowthRequirement(plant);
        this.seedItems = this.initSeedItems(plant);
        this.callbacks = JsonPlantCallback.get(plant.getCallbacks());
        this.seedTexture = new ResourceLocation(plant.getSeedTexture());
        this.seedModel = this.initSeedModel(plant.getSeedModel());
    }

    private List<ItemStack> initSeedItems(AgriPlant plant) {
        return plant.getSeeds().stream().flatMap(seed -> {
            boolean override = seed.isOverridePlanting();
            if (override) {
                return seed.convertAll(ItemStack.class).stream();
            }
            return seed.convertAll(ItemStack.class).stream().peek(stack -> VanillaPlantingHandler.getInstance().registerException(stack.func_77973_b()));
        }).collect(Collectors.toList());
    }

    private ResourceLocation initSeedModel(String model) {
        if (model.contains("#")) {
            return new ModelResourceLocation(model);
        }
        return new ResourceLocation(model);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.plant.getId();
    }

    @Nonnull
    public TranslationTextComponent getPlantName() {
        return this.plantName;
    }

    @Nonnull
    public TranslationTextComponent getSeedName() {
        return this.seedName;
    }

    @Override
    public int getTier() {
        return this.plant.getTier();
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getSeedItems() {
        return this.seedItems;
    }

    @Override
    @Nonnull
    public IAgriGrowthRequirement getGrowthRequirement(IAgriGrowthStage stage) {
        return this.growthRequirement;
    }

    @Override
    public boolean isFertilizable(IAgriGrowthStage growthStage, IAgriFertilizer fertilizer) {
        return this.plant.canBonemeal();
    }

    @Override
    public double getSpreadChance(IAgriGrowthStage growthStage) {
        return this.plant.getSpreadChance();
    }

    @Override
    public double getGrowthChanceBase(IAgriGrowthStage growthStage) {
        return this.plant.getGrowthChance();
    }

    @Override
    public double getGrowthChanceBonus(IAgriGrowthStage growthStage) {
        return this.plant.getGrowthBonus();
    }

    @Override
    public double getSeedDropChanceBase(IAgriGrowthStage growthStage) {
        return this.plant.getSeedDropChance();
    }

    @Override
    public double getSeedDropChanceBonus(IAgriGrowthStage growthStage) {
        return this.plant.getSeedDropBonus();
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getInitialGrowthStage() {
        return this.growthStages.get(0);
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getGrowthStageAfterHarvest() {
        return this.growthStages.get(this.plant.getStageAfterHarvest());
    }

    @Override
    @Nonnull
    public Collection<IAgriGrowthStage> getGrowthStages() {
        return this.growthStages;
    }

    @Override
    public double getPlantHeight(IAgriGrowthStage stage) {
        int index = IncrementalGrowthLogic.getGrowthIndex(stage);
        if (index < 0 || index >= this.plant.getGrowthStages()) {
            return 0.0;
        }
        return (float)this.plant.getGrowthStageHeight(index) * this.plant.getTexture().getRenderType().getHeightModifier();
    }

    @Override
    public Optional<BlockState> asBlockState(IAgriGrowthStage stage) {
        return Optional.empty();
    }

    @Nonnull
    public TranslationTextComponent getInformation() {
        return this.description;
    }

    @Override
    public void addTooltip(Consumer<ITextComponent> consumer) {
        consumer.accept((ITextComponent)this.getPlantName());
        consumer.accept((ITextComponent)this.getInformation());
    }

    @Override
    public void getAllPossibleProducts(@Nonnull Consumer<ItemStack> products) {
        this.plant.getProducts().getAll().stream().flatMap(p -> p.convertAll(ItemStack.class).stream()).forEach(products);
    }

    @Override
    public void getHarvestProducts(@Nonnull Consumer<ItemStack> products, @Nonnull IAgriGrowthStage growthStage, @Nonnull IAgriStatsMap stats, @Nonnull Random rand) {
        if (growthStage.isMature()) {
            this.plant.getProducts().getRandom(rand).stream().map(p -> p.convertSingle(ItemStack.class, rand)).filter(Optional::isPresent).map(Optional::get).forEach(products);
        }
    }

    @Override
    public void getAllPossibleClipProducts(@Nonnull Consumer<ItemStack> products) {
        this.plant.getClipProducts().getAll().stream().flatMap(p -> p.convertAll(ItemStack.class).stream()).forEach(products);
    }

    @Override
    public void getClipProducts(@Nonnull Consumer<ItemStack> products, @Nonnull ItemStack clipper, @Nonnull IAgriGrowthStage growthStage, @Nonnull IAgriStatsMap stats, @Nonnull Random rand) {
        if (growthStage.isMature()) {
            this.plant.getClipProducts().getRandom(rand).stream().map(p -> p.convertSingle(ItemStack.class, rand)).filter(Optional::isPresent).map(Optional::get).forEach(products);
        }
    }

    @Override
    public boolean allowsCloning(IAgriGrowthStage stage) {
        return this.plant.allowsCloning();
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction face, IAgriGrowthStage stage) {
        if (!stage.isGrowthStage()) {
            return ImmutableList.of();
        }
        int index = IncrementalGrowthLogic.getGrowthIndex(stage);
        int height = this.plant.getGrowthStageHeight(index);
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        if (this.plant.getTexture().useModels()) {
            ResourceLocation rl = new ResourceLocation(this.plant.getTexture().getPlantModel(index));
            listBuilder.addAll(AgriPlantQuadGenerator.getInstance().fetchQuads(rl));
        } else if (this.plant.getTexture().getRenderType() == AgriRenderType.GOURD) {
            listBuilder.addAll(AgriPlantQuadGenerator.getInstance().bakeQuads(this, stage, face, new ResourceLocation(this.plant.getTexture().getPlantTextures(index)[0]), 0, this.plant.getTexture().getRenderType()));
            if (stage.isFinal()) {
                listBuilder.addAll(AgriPlantQuadGenerator.getInstance().bakeQuads(this, stage, face, new ResourceLocation(this.plant.getTexture().getPlantTextures(index)[1]), 1, this.plant.getTexture().getRenderType()));
            }
        } else {
            int layer = 0;
            int layers = (int)Math.ceil((double)height / 16.0);
            while (16 * layer < height) {
                ResourceLocation rl = new ResourceLocation(this.plant.getTexture().getPlantTextures(index)[layer]);
                listBuilder.addAll(AgriPlantQuadGenerator.getInstance().bakeQuads(this, stage, face, rl, layers - layer - 1, this.plant.getTexture().getRenderType()));
                ++layer;
            }
        }
        return listBuilder.build();
    }

    @Override
    @Nonnull
    public List<ResourceLocation> getTexturesFor(IAgriGrowthStage stage) {
        return Arrays.stream(this.plant.getTexture().getPlantTextures(IncrementalGrowthLogic.getGrowthIndex(stage))).map(ResourceLocation::new).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public ResourceLocation getSeedTexture() {
        return this.seedTexture;
    }

    @Override
    @Nonnull
    public ResourceLocation getSeedModel() {
        return this.seedModel;
    }

    @Override
    public void spawnParticles(@Nonnull IAgriCrop crop, Random rand) {
        int index = IncrementalGrowthLogic.getGrowthIndex(crop.getGrowthStage());
        World world = crop.world();
        if (index == -1 || world == null) {
            return;
        }
        this.plant.getParticleEffects().stream().filter(effect -> effect.allowParticles(index)).forEach(effect -> {
            ParticleType particle = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(effect.getParticle()));
            if (!(particle instanceof IParticleData)) {
                return;
            }
            for (int amount = 0; amount < 3; ++amount) {
                if (!(rand.nextDouble() < effect.getProbability())) continue;
                BlockPos pos = crop.getPosition();
                double x = (double)pos.func_177958_n() + 0.5 + (double)(rand.nextBoolean() ? 1 : -1) * effect.getDeltaX() * rand.nextDouble();
                double y = (double)pos.func_177956_o() + 0.5 + effect.getDeltaY() * rand.nextDouble();
                double z = (double)pos.func_177952_p() + 0.5 + (double)(rand.nextBoolean() ? 1 : -1) * effect.getDeltaZ() * rand.nextDouble();
                world.func_195594_a((IParticleData)particle, x, y, z, 0.0, 0.0, 0.0);
            }
        });
    }

    @Override
    public boolean allowsHarvest(@Nonnull IAgriGrowthStage stage, @Nullable LivingEntity entity) {
        return stage.isMature();
    }

    @Override
    public boolean allowsClipping(@Nonnull IAgriGrowthStage stage, @Nonnull ItemStack clipper, @Nullable LivingEntity entity) {
        return stage.isMature() && this.plant.getClipProducts().getAll().size() > 0;
    }

    @Override
    public int getBrightness(@Nonnull IAgriCrop crop) {
        return this.callbacks.stream().mapToInt(callback -> callback.getBrightness(crop)).max().orElse(0);
    }

    @Override
    public int getRedstonePower(@Nonnull IAgriCrop crop) {
        return this.callbacks.stream().mapToInt(callback -> callback.getRedstonePower(crop)).max().orElse(0);
    }

    @Override
    public void onPlanted(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
        this.callbacks.forEach(callback -> callback.onPlanted(crop, entity));
    }

    @Override
    public void onSpawned(@Nonnull IAgriCrop crop) {
        this.callbacks.forEach(callback -> callback.onSpawned(crop));
    }

    @Override
    public void onGrowth(@Nonnull IAgriCrop crop) {
        this.callbacks.forEach(callback -> callback.onGrowth(crop));
    }

    @Override
    public void onRemoved(@Nonnull IAgriCrop crop) {
        this.callbacks.forEach(callback -> callback.onRemoved(crop));
    }

    @Override
    public void onHarvest(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
        this.callbacks.forEach(callback -> callback.onHarvest(crop, entity));
    }

    @Override
    public void onClipped(@Nonnull IAgriCrop crop, @Nonnull ItemStack clipper, @Nullable LivingEntity entity) {
        this.callbacks.forEach(callback -> callback.onClipped(crop, clipper, entity));
    }

    @Override
    public void onBroken(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
        this.callbacks.forEach(callback -> callback.onBroken(crop, entity));
    }

    @Override
    public void onEntityCollision(@Nonnull IAgriCrop crop, Entity entity) {
        this.callbacks.forEach(callback -> callback.onEntityCollision(crop, entity));
    }

    public static IAgriGrowthRequirement initGrowthRequirement(AgriPlant plant) {
        if (plant == null) {
            return AgriGrowthRequirement.getNone();
        }
        IAgriGrowthRequirement.Builder builder = AgriApi.getGrowthRequirementBuilder();
        String humidityString = plant.getRequirement().getHumiditySoilCondition().getCondition();
        IAgriSoil.Humidity humidity = IAgriSoil.Humidity.fromString(humidityString).orElse(IAgriSoil.Humidity.INVALID);
        JsonPlant.handleSoilCriterion(humidity, builder::defineHumidity, plant.getRequirement().getHumiditySoilCondition().getType(), plant.getRequirement().getHumiditySoilCondition().getToleranceFactor(), () -> AgriCore.getLogger("agricraft").warn("Plant: \"{0}\" has an invalid humidity criterion (\"{1}\")!", plant.getId(), humidityString));
        String acidityString = plant.getRequirement().getAciditySoilCondition().getCondition();
        IAgriSoil.Acidity acidity = IAgriSoil.Acidity.fromString(acidityString).orElse(IAgriSoil.Acidity.INVALID);
        JsonPlant.handleSoilCriterion(acidity, builder::defineAcidity, plant.getRequirement().getAciditySoilCondition().getType(), plant.getRequirement().getAciditySoilCondition().getToleranceFactor(), () -> AgriCore.getLogger("agricraft").warn("Plant: \"{0}\" has an invalid acidity criterion (\"{1}\")!", plant.getId(), acidityString));
        String nutrientString = plant.getRequirement().getNutrientSoilCondition().getCondition();
        IAgriSoil.Nutrients nutrients = IAgriSoil.Nutrients.fromString(nutrientString).orElse(IAgriSoil.Nutrients.INVALID);
        JsonPlant.handleSoilCriterion(nutrients, builder::defineNutrients, plant.getRequirement().getNutrientSoilCondition().getType(), plant.getRequirement().getNutrientSoilCondition().getToleranceFactor(), () -> AgriCore.getLogger("agricraft").warn("Plant: \"{0}\" has an invalid nutrients criterion (\"{1}\")!", plant.getId(), nutrientString));
        double f = plant.getRequirement().getLightToleranceFactor();
        int minLight = plant.getRequirement().getMinLight();
        int maxLight = plant.getRequirement().getMaxLight();
        builder.defineLightLevel((strength, light) -> {
            int lower = minLight - (int)(f * (double)strength.intValue());
            int upper = maxLight + (int)(f * (double)strength.intValue());
            return light >= lower && light <= upper ? IAgriGrowthResponse.FERTILE : IAgriGrowthResponse.INFERTILE;
        });
        plant.getRequirement().getConditions().forEach(obj -> {
            BlockPos min = new BlockPos(obj.getMinX(), obj.getMinY(), obj.getMinZ());
            BlockPos max = new BlockPos(obj.getMaxX(), obj.getMaxY(), obj.getMaxZ());
            builder.addCondition(builder.blockStatesNearby(obj.convertAll(BlockState.class), obj.getAmount(), min, max));
        });
        List seasons = plant.getRequirement().getSeasons().stream().map(AgriSeason::fromString).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
        if (seasons.size() > 0) {
            builder.defineSeasonality((str, season) -> {
                block3: {
                    block2: {
                        if (str >= AgriApi.getStatRegistry().strengthStat().getMax()) break block2;
                        if (!seasons.stream().anyMatch(season::matches)) break block3;
                    }
                    return IAgriGrowthResponse.FERTILE;
                }
                return IAgriGrowthResponse.INFERTILE;
            });
        }
        List fluids = plant.getRequirement().getFluid().convertAll(FluidState.class).stream().map(FluidState::func_206886_c).distinct().collect(Collectors.toList());
        BiFunction<Integer, Fluid, IAgriGrowthResponse> response = (strength, fluid) -> {
            if (fluids.size() > 0) {
                if (fluids.contains(fluid)) {
                    return IAgriGrowthResponse.FERTILE;
                }
                return fluid.equals(Fluids.field_204547_b) ? IAgriGrowthResponse.KILL_IT_WITH_FIRE : IAgriGrowthResponse.LETHAL;
            }
            if (fluid.equals(Fluids.field_204547_b)) {
                return IAgriGrowthResponse.KILL_IT_WITH_FIRE;
            }
            return fluid.equals(Fluids.field_204541_a) ? IAgriGrowthResponse.FERTILE : IAgriGrowthResponse.LETHAL;
        };
        builder.defineFluid(response);
        IAgriGrowthRequirement req = builder.build();
        if (JsonPlant.noSoilsMatch(req)) {
            AgriCore.getLogger("agricraft").warn("Plant: \"{0}\" has no valid soils to plant on for any strength level!", plant.getId());
        }
        return req;
    }

    private static <T extends Enum<T>> void handleSoilCriterion(T criterion, Consumer<BiFunction<Integer, T, IAgriGrowthResponse>> consumer, AgriSoilCondition.Type type, double f, Runnable invalidCallback) {
        if (!((IAgriSoil.SoilProperty)((Object)criterion)).isValid()) {
            invalidCallback.run();
        }
        consumer.accept((strength, humidity) -> {
            if (((IAgriSoil.SoilProperty)((Object)humidity)).isValid() && ((IAgriSoil.SoilProperty)((Object)criterion)).isValid()) {
                int lower = type.lowerLimit(criterion.ordinal() - (int)(f * (double)strength.intValue()));
                int upper = type.upperLimit(criterion.ordinal() + (int)(f * (double)strength.intValue()));
                if (humidity.ordinal() <= upper && humidity.ordinal() >= lower) {
                    return IAgriGrowthResponse.FERTILE;
                }
            }
            return IAgriGrowthResponse.INFERTILE;
        });
    }

    private static boolean noSoilsMatch(IAgriGrowthRequirement requirement) {
        return AgriApi.getSoilRegistry().stream().noneMatch(soil -> {
            int min = AgriApi.getStatRegistry().strengthStat().getMin();
            int max = AgriApi.getStatRegistry().strengthStat().getMax();
            for (int strength = min; strength <= max; ++strength) {
                boolean humidity = requirement.getSoilHumidityResponse(soil.getHumidity(), strength).isFertile();
                boolean acidity = requirement.getSoilAcidityResponse(soil.getAcidity(), strength).isFertile();
                boolean nutrients = requirement.getSoilNutrientsResponse(soil.getNutrients(), strength).isFertile();
                if (!humidity || !acidity || !nutrients) continue;
                return true;
            }
            return false;
        });
    }

    public boolean equals(Object obj) {
        return obj instanceof IAgriPlant && this.getId().equals(((IAgriPlant)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

