/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.plant;

import com.agricraft.agricore.plant.AgriWeed;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.crop.IncrementalGrowthLogic;
import com.infinityraider.agricraft.render.plant.AgriPlantQuadGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JsonWeed
implements IAgriWeed {
    private final AgriWeed weed;
    private final ITextComponent name;
    private final ITextComponent description;
    private final List<IAgriGrowthStage> growthStages;

    public JsonWeed(AgriWeed weed) {
        this.weed = weed;
        this.name = new TranslationTextComponent(weed.getWeedLangKey());
        this.description = new TranslationTextComponent(weed.getDescLangKey());
        this.growthStages = IncrementalGrowthLogic.getOrGenerateStages(this.weed.getGrowthStages());
    }

    @Override
    @Nonnull
    public ITextComponent getWeedName() {
        return this.name;
    }

    @Override
    public double spawnChance(IAgriCrop crop) {
        return this.weed.getSpawnChance();
    }

    @Override
    public double getGrowthChance(IAgriGrowthStage growthStage) {
        return this.weed.getGrowthChance();
    }

    @Override
    public boolean isAggressive() {
        return this.weed.isAggressive();
    }

    @Override
    public boolean isLethal() {
        return this.weed.isLethal();
    }

    @Override
    public void onRake(@Nonnull IAgriGrowthStage stage, @Nonnull Consumer<ItemStack> consumer, @Nonnull Random rand, @Nullable LivingEntity entity) {
        int index = IncrementalGrowthLogic.getGrowthIndex(stage);
        if (index < 0) {
            return;
        }
        if (((Config)AgriCraft.instance.getConfig()).rakingDropsItems()) {
            double probability = ((double)index + 0.0) / ((double)this.weed.getGrowthStages() - 1.0);
            if (rand.nextDouble() < probability) {
                this.weed.getRakeDrops().getRandom(rand).stream().map(p -> p.convertSingle(ItemStack.class, rand)).filter(Optional::isPresent).map(Optional::get).forEach(consumer);
            }
        }
    }

    @Override
    @Nonnull
    public String getId() {
        return this.weed.getId();
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getInitialGrowthStage() {
        return this.growthStages.get(0);
    }

    @Override
    @Nonnull
    public Collection<IAgriGrowthStage> getGrowthStages() {
        return this.growthStages;
    }

    @Override
    public double getPlantHeight(IAgriGrowthStage stage) {
        int index = IncrementalGrowthLogic.getGrowthIndex(stage);
        if (index < 0 || index >= this.weed.getGrowthStages()) {
            return 0.0;
        }
        return (float)this.weed.getGrowthStageHeight(index) * this.weed.getTexture().getRenderType().getHeightModifier();
    }

    @Override
    public void addTooltip(Consumer<ITextComponent> consumer) {
        consumer.accept(this.description);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction face, IAgriGrowthStage stage) {
        if (!stage.isGrowthStage()) {
            return ImmutableList.of();
        }
        int index = IncrementalGrowthLogic.getGrowthIndex(stage);
        int height = this.weed.getGrowthStageHeight(index);
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        int layer = 0;
        while (16 * layer < height) {
            ResourceLocation rl = new ResourceLocation(this.weed.getTexture().getPlantTextures(index)[layer]);
            listBuilder.addAll(AgriPlantQuadGenerator.getInstance().bakeQuads(this, stage, face, rl, layer, this.weed.getTexture().getRenderType()));
            ++layer;
        }
        return listBuilder.build();
    }

    @Override
    @Nonnull
    public List<ResourceLocation> getTexturesFor(IAgriGrowthStage stage) {
        return Arrays.stream(this.weed.getTexture().getPlantTextures(IncrementalGrowthLogic.getGrowthIndex(stage))).map(ResourceLocation::new).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        return obj instanceof IAgriWeed && this.getId().equals(((IAgriWeed)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

