/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.plant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.impl.v1.crop.NoGrowth;
import com.infinityraider.agricraft.impl.v1.requirement.AgriGrowthRequirement;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class NoPlant
implements IAgriPlant {
    private static final IAgriPlant INSTANCE = new NoPlant();
    private final String id;
    private final Set<IAgriGrowthStage> stages = ImmutableSet.of((Object)this.getInitialGrowthStage());
    private final ResourceLocation texture_jei = new ResourceLocation("agricraft", "seed/unknown_jei");
    private final ResourceLocation texture_journal = new ResourceLocation("agricraft", "seed/unknown_journal");
    private final ResourceLocation seed_model = new ResourceLocation("agricraft", "seed/none");

    public static IAgriPlant getInstance() {
        return INSTANCE;
    }

    private NoPlant() {
        this.id = "none";
    }

    @Override
    public final boolean isPlant() {
        return false;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public TranslationTextComponent getPlantName() {
        return AgriToolTips.UNKNOWN;
    }

    @Nonnull
    public TranslationTextComponent getSeedName() {
        return AgriToolTips.UNKNOWN;
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getSeedItems() {
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public IAgriGrowthRequirement getGrowthRequirement(IAgriGrowthStage stage) {
        return AgriGrowthRequirement.getNone();
    }

    @Override
    public boolean isFertilizable(IAgriGrowthStage growthStage, IAgriFertilizer fertilizer) {
        return false;
    }

    @Override
    public double getSpreadChance(IAgriGrowthStage growthStage) {
        return 0.0;
    }

    @Override
    public double getGrowthChanceBase(IAgriGrowthStage growthStage) {
        return 0.0;
    }

    @Override
    public double getGrowthChanceBonus(IAgriGrowthStage growthStage) {
        return 0.0;
    }

    @Override
    public double getSeedDropChanceBase(IAgriGrowthStage growthStage) {
        return 0.0;
    }

    @Override
    public double getSeedDropChanceBonus(IAgriGrowthStage growthStage) {
        return 0.0;
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getInitialGrowthStage() {
        return NoGrowth.getInstance();
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getGrowthStageAfterHarvest() {
        return this.getInitialGrowthStage();
    }

    @Override
    @Nonnull
    public Collection<IAgriGrowthStage> getGrowthStages() {
        return this.stages;
    }

    @Override
    public double getPlantHeight(IAgriGrowthStage stage) {
        return 0.0;
    }

    @Override
    public Optional<BlockState> asBlockState(IAgriGrowthStage stage) {
        return Optional.empty();
    }

    @Nonnull
    public TranslationTextComponent getInformation() {
        return AgriToolTips.UNKNOWN;
    }

    @Override
    public void addTooltip(Consumer<ITextComponent> consumer) {
        consumer.accept((ITextComponent)this.getPlantName());
    }

    @Override
    public void getAllPossibleProducts(@Nonnull Consumer<ItemStack> products) {
    }

    @Override
    public void getHarvestProducts(@Nonnull Consumer<ItemStack> products, @Nonnull IAgriGrowthStage growthStage, @Nonnull IAgriStatsMap stats, @Nonnull Random rand) {
    }

    @Override
    public void getAllPossibleClipProducts(@Nonnull Consumer<ItemStack> products) {
    }

    @Override
    public void getClipProducts(@Nonnull Consumer<ItemStack> products, @Nonnull ItemStack clipper, @Nonnull IAgriGrowthStage growthStage, @Nonnull IAgriStatsMap stats, @Nonnull Random rand) {
    }

    @Override
    public boolean allowsCloning(IAgriGrowthStage stage) {
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation getSeedTexture() {
        return this.texture_journal;
    }

    @Override
    @Nonnull
    public ResourceLocation getSeedModel() {
        return this.seed_model;
    }

    @Override
    public void spawnParticles(@Nonnull IAgriCrop crop, Random rand) {
    }

    public TranslationTextComponent getTooltip() {
        return AgriToolTips.UNKNOWN;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction face, IAgriGrowthStage stage) {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public List<ResourceLocation> getTexturesFor(IAgriGrowthStage stage) {
        return ImmutableList.of((Object)this.texture_jei, (Object)this.texture_journal);
    }
}

