/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.plant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.impl.v1.crop.NoGrowth;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class NoWeed
implements IAgriWeed {
    private static final IAgriWeed INSTANCE = new NoWeed();
    private final String id = "none";
    private final Set<IAgriGrowthStage> stages = ImmutableSet.of((Object)this.getInitialGrowthStage());
    private final String info = "Damnations! This is not a weed";
    private final ITextComponent tooltip = new StringTextComponent(this.info);

    public static IAgriWeed getInstance() {
        return INSTANCE;
    }

    private NoWeed() {
    }

    @Override
    public final boolean isWeed() {
        return false;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public ITextComponent getWeedName() {
        return AgriToolTips.UNKNOWN;
    }

    @Override
    public double spawnChance(IAgriCrop crop) {
        return 0.0;
    }

    @Override
    public double getGrowthChance(IAgriGrowthStage growthStage) {
        return 0.0;
    }

    @Override
    public boolean isAggressive() {
        return false;
    }

    @Override
    public boolean isLethal() {
        return false;
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getInitialGrowthStage() {
        return NoGrowth.getInstance();
    }

    @Nonnull
    public Set<IAgriGrowthStage> getGrowthStages() {
        return this.stages;
    }

    @Override
    public double getPlantHeight(IAgriGrowthStage stage) {
        return 0.0;
    }

    @Override
    public void onRake(@Nonnull IAgriGrowthStage stage, @Nonnull Consumer<ItemStack> consumer, @Nonnull Random rand, @Nullable LivingEntity entity) {
    }

    @Override
    public void addTooltip(Consumer<ITextComponent> consumer) {
        consumer.accept(this.tooltip);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction face, IAgriGrowthStage stage) {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public List<ResourceLocation> getTexturesFor(IAgriGrowthStage stage) {
        return ImmutableList.of();
    }
}

