/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.requirement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowCondition;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.impl.v1.requirement.Factory;
import com.infinityraider.agricraft.impl.v1.requirement.GrowConditionBase;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AgriGrowthRequirement
implements IAgriGrowthRequirement {
    private final Set<IAgriGrowCondition> conditions;
    private final GrowConditionBase<IAgriSoil.Humidity> humidity;
    private final GrowConditionBase<IAgriSoil.Acidity> acidity;
    private final GrowConditionBase<IAgriSoil.Nutrients> nutrients;
    private final GrowConditionBase<Integer> lightLevel;
    private final GrowConditionBase<AgriSeason> season;
    private final GrowConditionBase<Fluid> fluid;
    private static final IAgriGrowthRequirement NONE = new IAgriGrowthRequirement(){

        @Override
        @Nonnull
        public Set<IAgriGrowCondition> getGrowConditions() {
            return ImmutableSet.of();
        }

        @Override
        public IAgriGrowthResponse getSoilHumidityResponse(IAgriSoil.Humidity humidity, int strength) {
            return IAgriGrowthResponse.INFERTILE;
        }

        @Override
        public IAgriGrowthResponse getSoilAcidityResponse(IAgriSoil.Acidity acidity, int strength) {
            return IAgriGrowthResponse.INFERTILE;
        }

        @Override
        public IAgriGrowthResponse getSoilNutrientsResponse(IAgriSoil.Nutrients nutrients, int strength) {
            return IAgriGrowthResponse.INFERTILE;
        }

        @Override
        public IAgriGrowthResponse getLightLevelResponse(int light, int strength) {
            return IAgriGrowthResponse.INFERTILE;
        }

        @Override
        public IAgriGrowthResponse getSeasonResponse(AgriSeason season, int strength) {
            return IAgriGrowthResponse.INFERTILE;
        }

        @Override
        public IAgriGrowthResponse getFluidResponse(Fluid fluid, int strength) {
            return IAgriGrowthResponse.INFERTILE;
        }
    };

    public static IAgriGrowthRequirement.Builder getBuilder() {
        return new Builder();
    }

    public static IAgriGrowthRequirement getNone() {
        return NONE;
    }

    private AgriGrowthRequirement(Set<IAgriGrowCondition> conditions, GrowConditionBase<IAgriSoil.Humidity> humidity, GrowConditionBase<IAgriSoil.Acidity> acidity, GrowConditionBase<IAgriSoil.Nutrients> nutrients, GrowConditionBase<Integer> lightLevel, GrowConditionBase<AgriSeason> season, GrowConditionBase<Fluid> fluid) {
        this.humidity = humidity;
        this.acidity = acidity;
        this.nutrients = nutrients;
        this.lightLevel = lightLevel;
        this.season = season;
        this.fluid = fluid;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object[])new IAgriGrowCondition[]{this.humidity, this.acidity, this.nutrients, this.lightLevel, this.season, this.fluid});
        builder.addAll(conditions);
        this.conditions = builder.build();
    }

    @Override
    @Nonnull
    public Set<IAgriGrowCondition> getGrowConditions() {
        return this.conditions;
    }

    @Override
    public IAgriGrowthResponse getSoilHumidityResponse(IAgriSoil.Humidity humidity, int strength) {
        return this.humidity.apply(strength, humidity);
    }

    @Override
    public IAgriGrowthResponse getSoilAcidityResponse(IAgriSoil.Acidity acidity, int strength) {
        return this.acidity.apply(strength, acidity);
    }

    @Override
    public IAgriGrowthResponse getSoilNutrientsResponse(IAgriSoil.Nutrients nutrients, int strength) {
        return this.nutrients.apply(strength, nutrients);
    }

    @Override
    public IAgriGrowthResponse getLightLevelResponse(int light, int strength) {
        return this.lightLevel.apply((Integer)strength, light);
    }

    @Override
    public IAgriGrowthResponse getSeasonResponse(AgriSeason season, int strength) {
        return this.season.apply(strength, season);
    }

    @Override
    public IAgriGrowthResponse getFluidResponse(Fluid fluid, int strength) {
        return this.fluid.apply(strength, fluid);
    }

    public static final class Tooltips {
        public static final List<ITextComponent> HUMIDITY_DESCRIPTION = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.soil.humidity.general"));
        public static final List<ITextComponent> ACIDITY_DESCRIPTION = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.soil.acidity.general"));
        public static final List<ITextComponent> NUTRIENT_DESCRIPTION = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.soil.nutrients.general"));
        public static final List<ITextComponent> LIGHT_LEVEL_DESCRIPTION = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.light.general"));
        public static final List<ITextComponent> FLUID_DESCRIPTION = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.fluid.general"));
        public static final List<ITextComponent> SEASON_DESCRIPTION = ImmutableList.of((Object)new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.growth_req.season.general"));

        private Tooltips() {
        }
    }

    private static class Builder
    extends Factory
    implements IAgriGrowthRequirement.Builder {
        private final Set<IAgriGrowCondition> conditions = Sets.newIdentityHashSet();
        private GrowConditionBase<IAgriSoil.Humidity> humidity;
        private GrowConditionBase<IAgriSoil.Acidity> acidity;
        private GrowConditionBase<IAgriSoil.Nutrients> nutrients;
        private GrowConditionBase<Integer> lightLevel;
        private GrowConditionBase<AgriSeason> season;
        private GrowConditionBase<Fluid> fluid;

        private Builder() {
        }

        @Override
        public IAgriGrowthRequirement build() {
            if (this.humidity == null) {
                throw new IllegalStateException("Can not build an IAgriGrowthRequirement without initializing the humidity rule");
            }
            if (this.acidity == null) {
                throw new IllegalStateException("Can not build an IAgriGrowthRequirement without initializing the acidity rule");
            }
            if (this.nutrients == null) {
                throw new IllegalStateException("Can not build an IAgriGrowthRequirement without initializing the nutrients rule");
            }
            if (this.lightLevel == null) {
                throw new IllegalStateException("Can not build an IAgriGrowthRequirement without initializing the light level rule");
            }
            if (this.season == null) {
                throw new IllegalStateException("Can not build an IAgriGrowthRequirement without initializing the seasonality rule");
            }
            if (this.fluid == null) {
                throw new IllegalStateException("Can not build an IAgriGrowthRequirement without initializing the fluid rule");
            }
            return new AgriGrowthRequirement(this.conditions, this.humidity, this.acidity, this.nutrients, this.lightLevel, this.season, this.fluid);
        }

        @Override
        public IAgriGrowthRequirement.Builder defineHumidity(BiFunction<Integer, IAgriSoil.Humidity, IAgriGrowthResponse> response) {
            this.humidity = this.soilHumidity((BiFunction)response, (List)Tooltips.HUMIDITY_DESCRIPTION);
            return this;
        }

        @Override
        public IAgriGrowthRequirement.Builder defineAcidity(BiFunction<Integer, IAgriSoil.Acidity, IAgriGrowthResponse> response) {
            this.acidity = this.soilAcidity((BiFunction)response, (List)Tooltips.ACIDITY_DESCRIPTION);
            return this;
        }

        @Override
        public IAgriGrowthRequirement.Builder defineNutrients(BiFunction<Integer, IAgriSoil.Nutrients, IAgriGrowthResponse> response) {
            this.nutrients = this.soilNutrients((BiFunction)response, (List)Tooltips.NUTRIENT_DESCRIPTION);
            return this;
        }

        @Override
        public IAgriGrowthRequirement.Builder defineLightLevel(BiFunction<Integer, Integer, IAgriGrowthResponse> response) {
            this.lightLevel = this.light((BiFunction)response, (List)Tooltips.LIGHT_LEVEL_DESCRIPTION);
            return this;
        }

        @Override
        public IAgriGrowthRequirement.Builder defineFluid(BiFunction<Integer, Fluid, IAgriGrowthResponse> response) {
            this.fluid = this.fluid((BiFunction)response, (List)Tooltips.FLUID_DESCRIPTION);
            return this;
        }

        @Override
        public IAgriGrowthRequirement.Builder defineSeasonality(BiFunction<Integer, AgriSeason, IAgriGrowthResponse> response) {
            this.season = this.season((BiFunction)response, (List)Tooltips.SEASON_DESCRIPTION);
            return this;
        }

        @Override
        public IAgriGrowthRequirement.Builder addCondition(IAgriGrowCondition condition) {
            this.conditions.add(condition);
            return this;
        }
    }
}

